/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.serialization;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagAdapter;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.serialization.TagSerializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AttributeAdapter
implements TagAdapter<Set<AttributeInstance>> {
    @Override
    public Set<AttributeInstance> deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        HashSet<AttributeInstance> attributes = new HashSet<AttributeInstance>();
        Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ATTRIBUTE);
        root.forEach((key, tag1) -> {
            Attribute attribute = (Attribute)registry.get(Key.key((String)key));
            if (attribute == null) {
                return;
            }
            CompoundTag attributeTag = tag1.getAsCompound();
            double baseValue = attributeTag.get("baseValue").getAsDouble();
            HashSet<AttributeModifier> modifiers = new HashSet<AttributeModifier>();
            attributeTag.optional("modifiers").map(Tag::getAsCompound).ifPresent(modifiersTag -> modifiersTag.forEach((key1, modifierTag) -> {
                CompoundTag asCompound = modifierTag.getAsCompound();
                NamespacedKey modifierKey = NamespacedKey.fromString((String)key1);
                if (modifierKey == null) {
                    return;
                }
                int amount = asCompound.get("amount").getAsInt();
                AttributeModifier.Operation operation = context.deserialize((Tag)asCompound.get("operation"), AttributeModifier.Operation.class);
                EquipmentSlotGroup slot = asCompound.optional("slot").map(tag2 -> context.deserialize((Tag)tag2, EquipmentSlotGroup.class)).orElse(EquipmentSlotGroup.ANY);
                modifiers.add(new AttributeModifier(modifierKey, (double)amount, operation, slot));
            }));
            attributes.add(new SimpleAttributeInstance(attribute, baseValue, modifiers));
        });
        return attributes;
    }

    @Override
    public Tag serialize(Set<AttributeInstance> attributes, TagSerializationContext context) throws ParserException {
        CompoundTag tag = CompoundTag.empty();
        attributes.forEach(instance -> {
            CompoundTag attributeTag = CompoundTag.empty();
            attributeTag.add("baseValue", instance.getBaseValue());
            CompoundTag modifiersTag = CompoundTag.empty();
            instance.getModifiers().forEach(modifier -> {
                CompoundTag modifierTag = CompoundTag.empty();
                modifierTag.add("operation", context.serialize(modifier.getOperation()));
                modifierTag.add("amount", modifier.getAmount());
                modifierTag.add("slot", context.serialize(modifier.getSlotGroup()));
                modifiersTag.add(modifier.key().asString(), modifierTag);
            });
            attributeTag.add("modifiers", modifiersTag);
            tag.add(instance.getAttribute().key().asString(), attributeTag);
        });
        return tag;
    }

    private static final class SimpleAttributeInstance
    implements AttributeInstance {
        private final Attribute attribute;
        private final double baseValue;
        private final Collection<AttributeModifier> modifiers;

        public SimpleAttributeInstance(Attribute attribute, double baseValue, Collection<AttributeModifier> modifiers) {
            this.attribute = attribute;
            this.baseValue = baseValue;
            this.modifiers = modifiers;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public void setBaseValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Collection<AttributeModifier> getModifiers() {
            return List.copyOf(this.modifiers);
        }

        @Nullable
        public AttributeModifier getModifier(Key key) {
            throw new UnsupportedOperationException();
        }

        public void removeModifier(Key key) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public AttributeModifier getModifier(UUID uuid) {
            throw new UnsupportedOperationException();
        }

        public void removeModifier(UUID uuid) {
            throw new UnsupportedOperationException();
        }

        public void addModifier(AttributeModifier modifier) {
            throw new UnsupportedOperationException();
        }

        public void addTransientModifier(AttributeModifier modifier) {
            throw new UnsupportedOperationException();
        }

        public void removeModifier(AttributeModifier modifier) {
            throw new UnsupportedOperationException();
        }

        public double getValue() {
            throw new UnsupportedOperationException();
        }

        public double getDefaultValue() {
            throw new UnsupportedOperationException();
        }
    }
}

