/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.listener;

import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.action.ClickType;
import net.thenextlvl.character.event.player.PlayerClickCharacterEvent;
import net.thenextlvl.character.plugin.CharacterPlugin;
import org.bukkit.GameRule;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class EntityListener
implements Listener {
    private final CharacterPlugin plugin;

    public EntityListener(CharacterPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        if (!event.getHand().equals((Object)EquipmentSlot.HAND)) {
            return;
        }
        this.plugin.characterController().getCharacter(event.getRightClicked()).ifPresent(character -> {
            ClickType type = event.getPlayer().isSneaking() ? ClickType.SHIFT_RIGHT : ClickType.RIGHT;
            PlayerClickCharacterEvent characterEvent = new PlayerClickCharacterEvent((Character<?>)character, event.getRightClicked(), event.getPlayer(), type);
            characterEvent.callEvent();
            event.setCancelled(true);
        });
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPrePlayerAttackEntityLowest(PrePlayerAttackEntityEvent event) {
        this.plugin.characterController().getCharacter(event.getAttacked()).ifPresent(character -> {
            ClickType type = event.getPlayer().isSneaking() ? ClickType.SHIFT_LEFT : ClickType.LEFT;
            PlayerClickCharacterEvent characterEvent = new PlayerClickCharacterEvent((Character<?>)character, event.getAttacked(), event.getPlayer(), type);
            event.setCancelled(!characterEvent.callEvent() || event.getAttacked().isInvulnerable());
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (!this.plugin.characterController().isCharacter((Entity)event.getEntity())) {
            return;
        }
        event.setCancelled(event.getEntity().isInvulnerable());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        this.plugin.characterController().getCharacter(event.getEntity()).ifPresent(character -> {
            if (!Boolean.TRUE.equals(event.getEntity().getWorld().getGameRuleValue(GameRule.DO_IMMEDIATE_RESPAWN))) {
                this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> character.spawn(), 75L);
                this.plugin.getServer().getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, task -> character.despawn(), 20L);
            } else {
                character.respawn();
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.plugin.characterController().getCharacter(event.getEntity()).ifPresent(character -> event.deathMessage(null));
    }
}

