/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.tag;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import core.paper.command.argument.EnumArgumentType;
import core.paper.command.argument.codec.EnumStringCodec;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import org.bukkit.entity.TextDisplay;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CharacterTagAlignmentCommand
extends SimpleCommand {
    private CharacterTagAlignmentCommand(CharacterPlugin plugin) {
        super(plugin, "alignment", null);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> set(CharacterPlugin plugin) {
        CharacterTagAlignmentCommand command = new CharacterTagAlignmentCommand(plugin);
        return (LiteralArgumentBuilder)command.create().then(Commands.argument((String)"alignment", EnumArgumentType.of(TextDisplay.TextAlignment.class, EnumStringCodec.lowerHyphen())).executes((Command)command));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> reset(CharacterPlugin plugin) {
        CharacterTagAlignmentCommand command = new CharacterTagAlignmentCommand(plugin);
        return (LiteralArgumentBuilder)command.create().executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Character character = (Character)context.getArgument("character", Character.class);
        TextDisplay.TextAlignment alignment = this.tryGetArgument(context, "alignment", TextDisplay.TextAlignment.class).orElse(TextDisplay.TextAlignment.CENTER);
        boolean success = character.getTagOptions().setAlignment(alignment);
        String message = success ? "character.tag.alignment" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"value", (String)alignment.name().toLowerCase())});
        return success ? 1 : 0;
    }
}

