/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.skin;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.PlayerCharacter;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.brigadier.BrigadierCommand;
import net.thenextlvl.character.plugin.command.skin.CharacterSkinLayerCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CharacterSkinCommand
extends BrigadierCommand {
    private CharacterSkinCommand(CharacterPlugin plugin) {
        super(plugin, "skin", "characters.command.skin");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterSkinCommand command = new CharacterSkinCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(CharacterSkinLayerCommand.create(plugin))).then(command.reset())).then(command.set());
    }

    private ArgumentBuilder<CommandSourceStack, ?> reset() {
        return Commands.literal((String)"reset").then(CharacterCommand.playerCharacterArgument(this.plugin).executes(context -> this.setSkin((CommandContext<CommandSourceStack>)context, null)));
    }

    private ArgumentBuilder<CommandSourceStack, ?> set() {
        return Commands.literal((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)CharacterCommand.playerCharacterArgument(this.plugin).then(this.fileSkinArgument())).then(this.playerSkinArgument())).then(this.urlSkinArgument()));
    }

    private int setSkin(CommandContext<CommandSourceStack> context, @Nullable ProfileProperty textures) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        PlayerCharacter character = (PlayerCharacter)context.getArgument("character", PlayerCharacter.class);
        boolean success = textures == null ? character.clearTextures() : character.setTextures(textures.getValue(), textures.getSignature());
        String message = success ? "character.skin" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"character", (String)character.getName())});
        return success ? 1 : 0;
    }

    private ArgumentBuilder<CommandSourceStack, ?> fileSkinArgument() {
        return Commands.literal((String)"file").then(((RequiredArgumentBuilder)Commands.argument((String)"file", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"slim").executes(context -> this.setFileSkin((CommandContext<CommandSourceStack>)context, true)))).executes(context -> this.setFileSkin((CommandContext<CommandSourceStack>)context, false)));
    }

    private ArgumentBuilder<CommandSourceStack, ?> playerSkinArgument() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"player").then(Commands.argument((String)"offline-player", (ArgumentType)StringArgumentType.word()).executes(this::setOfflinePlayerSkin))).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).executes(this::setPlayerSkin));
    }

    private ArgumentBuilder<CommandSourceStack, ?> urlSkinArgument() {
        return Commands.literal((String)"url").then(((RequiredArgumentBuilder)Commands.argument((String)"url", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"slim").executes(context -> this.setUrlSkin((CommandContext<CommandSourceStack>)context, true)))).executes(context -> this.setUrlSkin((CommandContext<CommandSourceStack>)context, false)));
    }

    private int setFileSkin(CommandContext<CommandSourceStack> context, boolean slim) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        File file = new File((String)context.getArgument("file", String.class));
        if (!file.isFile() || !file.getName().endsWith(".png")) {
            this.plugin.bundle().sendMessage((Audience)sender, "character.skin.file");
            return 0;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "character.skin.generating");
        ((CompletableFuture)this.plugin.skinFactory().skinFromFile(file, slim).thenAccept(textures -> this.setSkin(context, (ProfileProperty)textures))).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)sender, "character.skin.image");
            return null;
        });
        return 1;
    }

    private int setOfflinePlayerSkin(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String name = (String)context.getArgument("offline-player", String.class);
        if (name.length() <= 16) {
            this.plugin.getServer().createProfile(name).update().thenAccept(profile -> profile.getProperties().stream().filter(property -> property.getName().equals("textures")).findAny().ifPresentOrElse(textures -> this.setSkin(context, (ProfileProperty)textures), () -> {
                if (profile.getName() == null) {
                    this.plugin.bundle().sendMessage((Audience)sender, "player.not_found", new TagResolver[]{Placeholder.unparsed((String)"name", (String)name)});
                } else {
                    this.plugin.bundle().sendMessage((Audience)sender, "character.skin.not_found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)profile.getName())});
                }
            }));
            return 1;
        }
        this.plugin.bundle().sendMessage((Audience)sender, "player.not_found", new TagResolver[]{Placeholder.unparsed((String)"name", (String)name)});
        return 0;
    }

    private int setPlayerSkin(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver resolver = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
        Player player = (Player)((List)resolver.resolve((CommandSourceStack)context.getSource())).getFirst();
        ProfileProperty textures = player.getPlayerProfile().getProperties().stream().filter(property -> property.getName().equals("textures")).findAny().orElse(null);
        if (textures != null) {
            return this.setSkin(context, textures);
        }
        this.plugin.bundle().sendMessage((Audience)player, "character.skin.not_found", new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName())});
        return 0;
    }

    private int setUrlSkin(CommandContext<CommandSourceStack> context, boolean slim) {
        try {
            String path = (String)context.getArgument("url", String.class);
            URL url = new URI((String)(!path.startsWith("http") ? "https://" + path : path)).toURL();
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "character.skin.generating");
            ((CompletableFuture)this.plugin.skinFactory().skinFromURL(url, slim).thenAccept(textures -> this.setSkin(context, (ProfileProperty)textures))).exceptionally(throwable -> {
                this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "character.skin.image");
                return null;
            });
            return 1;
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "character.skin.url");
            return 0;
        }
    }
}

