/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command.action.argument;

import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.time.Duration;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.action.ActionType;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.brigadier.SimpleCommand;
import net.thenextlvl.character.plugin.model.ClickTypes;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
abstract class CharacterActionCommand<T>
extends SimpleCommand {
    private final ActionType<T> actionType;

    protected CharacterActionCommand(CharacterPlugin plugin, ActionType<T> actionType, String name) {
        super(plugin, name, null);
        this.actionType = actionType;
    }

    protected int addAction(CommandContext<CommandSourceStack> context, T input) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Character character = (Character)context.getArgument("character", Character.class);
        String actionName = (String)context.getArgument("action", String.class);
        ClickTypes clickTypes = (ClickTypes)((Object)context.getArgument("click-types", ClickTypes.class));
        Optional<ClickAction<?>> previous = character.getAction(actionName);
        Duration cooldown = previous.map(ClickAction::getCooldown).orElse(Duration.ZERO);
        String permission = previous.map(ClickAction::getPermission).orElse(null);
        Integer chance = previous.map(ClickAction::getChance).orElse(100);
        boolean success = character.addAction(actionName, ClickAction.create(this.actionType, clickTypes.getClickTypes(), input, action -> {
            action.setChance(chance);
            action.setCooldown(cooldown);
            action.setPermission(permission);
        }));
        String message = success ? "character.action.added" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.unparsed((String)"action", (String)actionName), Placeholder.unparsed((String)"character", (String)character.getName())});
        return success ? 1 : 0;
    }
}

