/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.PlayerCharacter;
import net.thenextlvl.character.codec.EntityCodec;
import net.thenextlvl.character.codec.EntityCodecRegistry;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.command.argument.NamedTextColorArgumentType;
import net.thenextlvl.character.plugin.command.brigadier.BrigadierCommand;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class CharacterAttributeCommand
extends BrigadierCommand {
    private CharacterAttributeCommand(CharacterPlugin plugin) {
        super(plugin, "attribute", "characters.command.attribute");
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create(CharacterPlugin plugin) {
        CharacterAttributeCommand command = new CharacterAttributeCommand(plugin);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)command.create().then(command.reset())).then(command.set());
    }

    private LiteralArgumentBuilder<CommandSourceStack> reset() {
        RequiredArgumentBuilder tree = (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)CharacterCommand.characterArgument(this.plugin).then(this.resetListed())).then(this.resetPathfinding())).then(this.resetTeamColor());
        return (LiteralArgumentBuilder)Commands.literal((String)"reset").then((ArgumentBuilder)tree);
    }

    private LiteralArgumentBuilder<CommandSourceStack> set() {
        RequiredArgumentBuilder tree = (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)CharacterCommand.characterArgument(this.plugin).then(this.setListed())).then(this.setPathfinding())).then(this.setTeamColor());
        EntityCodecRegistry.registry().codecs().forEach(codec -> {
            ArgumentBuilder<CommandSourceStack, ?> argument = this.setAttribute((EntityCodec)codec);
            if (argument != null) {
                tree.then(argument);
            }
        });
        return (LiteralArgumentBuilder)Commands.literal((String)"set").then((ArgumentBuilder)tree);
    }

    private <E, T> @Nullable ArgumentBuilder<CommandSourceStack, ?> setAttribute(EntityCodec<E, T> codec) {
        if (codec.argumentType() == null) {
            return null;
        }
        RequiredArgumentBuilder argument = Commands.argument((String)"value", codec.argumentType());
        return Commands.literal((String)codec.key().asString()).then(argument.executes(context -> {
            Object value = context.getArgument("value", codec.valueType());
            Character character = (Character)context.getArgument("character", Character.class);
            Boolean success = character.getEntity(codec.entityType()).map(entity -> codec.setter().test(entity, value)).orElse(false);
            String message = success != false ? "character.attribute" : "nothing.changed";
            String[] split = context.getInput().split(" ", 6);
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"attribute", (String)codec.key().asString()), Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"value", (String)split[split.length - 1])});
            return success != false ? 1 : 0;
        }));
    }

    private ArgumentBuilder<CommandSourceStack, ?> attribute(String attribute, BiFunction<Character<?>, Boolean, Boolean> setter) {
        return Commands.literal((String)attribute).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            Boolean enabled = (Boolean)context.getArgument("enabled", Boolean.TYPE);
            boolean success = this.set((CommandContext<CommandSourceStack>)context, attribute, character -> (Boolean)setter.apply((Character<?>)character, enabled), ignored -> enabled);
            return success ? 1 : 0;
        }));
    }

    private ArgumentBuilder<CommandSourceStack, ?> reset(String attribute, Function<Character<?>, Boolean> setter, Function<Character<?>, @Nullable Object> getter) {
        return Commands.literal((String)attribute).executes(context -> {
            boolean success = this.set((CommandContext<CommandSourceStack>)context, attribute, setter, getter);
            return success ? 1 : 0;
        });
    }

    private boolean set(CommandContext<CommandSourceStack> context, String attribute, Function<Character<?>, Boolean> setter, Function<Character<?>, @Nullable Object> getter) {
        Character character = (Character)context.getArgument("character", Character.class);
        Boolean success = setter.apply(character);
        String message = success != false ? "character.attribute" : "nothing.changed";
        this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), message, new TagResolver[]{Placeholder.unparsed((String)"attribute", (String)attribute), Placeholder.unparsed((String)"character", (String)character.getName()), Placeholder.unparsed((String)"value", (String)String.valueOf(getter.apply(character)))});
        return success;
    }

    private ArgumentBuilder<CommandSourceStack, ?> resetListed() {
        return this.reset("character:listed", character -> {
            PlayerCharacter p;
            return character instanceof PlayerCharacter && (p = (PlayerCharacter)character).setListed(false);
        }, character -> {
            PlayerCharacter p;
            return character instanceof PlayerCharacter && (p = (PlayerCharacter)character).isListed();
        });
    }

    private ArgumentBuilder<CommandSourceStack, ?> resetPathfinding() {
        return this.reset("character:pathfinding", character -> character.setPathfinding(false), Character::isPathfinding);
    }

    private ArgumentBuilder<CommandSourceStack, ?> resetTeamColor() {
        return this.reset("character:team-color", character -> character.setTeamColor(null), Character::getTeamColor);
    }

    private ArgumentBuilder<CommandSourceStack, ?> setListed() {
        return this.attribute("character:listed", (c, b) -> {
            PlayerCharacter p;
            return c instanceof PlayerCharacter && (p = (PlayerCharacter)c).setListed((boolean)b);
        });
    }

    private ArgumentBuilder<CommandSourceStack, ?> setPathfinding() {
        return this.attribute("character:pathfinding", Character::setPathfinding);
    }

    private ArgumentBuilder<CommandSourceStack, ?> setTeamColor() {
        return Commands.literal((String)"character:team-color").then(Commands.argument((String)"color", (ArgumentType)new NamedTextColorArgumentType()).executes(context -> {
            NamedTextColor color = (NamedTextColor)context.getArgument("color", NamedTextColor.class);
            boolean success = this.set((CommandContext<CommandSourceStack>)context, "team-color", character -> character.setTeamColor(color), character -> color);
            return success ? 1 : 0;
        }));
    }
}

