/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.character;

import com.destroystokyo.paper.profile.ProfileProperty;
import java.io.File;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.character.mineskin.Java11RequestHandler;
import net.thenextlvl.character.mineskin.MineSkinClient;
import net.thenextlvl.character.mineskin.data.ValueAndSignature;
import net.thenextlvl.character.mineskin.data.Variant;
import net.thenextlvl.character.mineskin.request.GenerateRequest;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.character.PaperSkinPartBuilder;
import net.thenextlvl.character.skin.SkinFactory;
import net.thenextlvl.character.skin.SkinPartBuilder;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class PaperSkinFactory
implements SkinFactory {
    private final MineSkinClient client;

    public PaperSkinFactory(CharacterPlugin plugin) {
        String apiKey = System.getenv("MINESKIN_API_KEY");
        this.client = MineSkinClient.builder().requestHandler(Java11RequestHandler::new).userAgent("Characters/" + plugin.getPluginMeta().getVersion()).apiKey(apiKey).timeout(3000).build();
        if (apiKey != null && !apiKey.isBlank()) {
            return;
        }
        plugin.getComponentLogger().warn("You can define an API key via the environment variable MINESKIN_API_KEY");
        plugin.getComponentLogger().warn("If you don't plan on using the skin file or url service a lot you can ignore this warning");
    }

    @Override
    public CompletableFuture<ProfileProperty> skinFromFile(File image, boolean slim) {
        return this.submit(GenerateRequest.upload(image), slim);
    }

    @Override
    public CompletableFuture<ProfileProperty> skinFromURL(URL url, boolean slim) {
        return this.submit(GenerateRequest.url(url), slim);
    }

    @Override
    public SkinPartBuilder skinPartBuilder() {
        return new PaperSkinPartBuilder();
    }

    private CompletableFuture<ProfileProperty> submit(GenerateRequest request, boolean slim) {
        return ((CompletableFuture)((CompletableFuture)this.client.queue().submit(request.variant(slim ? Variant.SLIM : Variant.AUTO)).thenCompose(response -> response.getJob().waitForCompletion(this.client))).thenCompose(jobReference -> jobReference.getOrLoadSkin(this.client))).thenApply(skinInfo -> {
            ValueAndSignature data = skinInfo.texture().data();
            return new ProfileProperty("textures", data.value(), data.signature());
        });
    }
}

