/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin.character;

import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import core.util.StringUtil;
import io.papermc.paper.util.KeepAlive;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.thenextlvl.character.PlayerCharacter;
import net.thenextlvl.character.plugin.CharacterPlugin;
import net.thenextlvl.character.plugin.character.PaperCharacter;
import net.thenextlvl.character.plugin.character.PaperSkinPartBuilder;
import net.thenextlvl.character.plugin.character.entity.CraftPlayerCharacter;
import net.thenextlvl.character.plugin.network.EmptyPacketListener;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.TagDeserializationContext;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class PaperPlayerCharacter
extends PaperCharacter<org.bukkit.entity.Player>
implements PlayerCharacter {
    private final CraftPlayerProfile profile;
    private SkinParts skinParts = new PaperSkinPartBuilder().build();
    private boolean listed = false;
    private boolean realPlayer = false;

    public PaperPlayerCharacter(CharacterPlugin plugin, String name, UUID uuid) {
        super(plugin, name, EntityType.PLAYER);
        this.profile = new CraftPlayerProfile(uuid, "NPC_" + StringUtil.random(12));
    }

    @Override
    public String getScoreboardName() {
        return Objects.requireNonNull(this.profile.getName());
    }

    @Override
    public boolean setTeamColor(@Nullable NamedTextColor color) {
        if (!super.setTeamColor(color)) {
            return false;
        }
        this.getEntity(CraftPlayer.class).ifPresent(entity -> {
            ClientboundPlayerInfoUpdatePacket update = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, entity.getHandle());
            entity.getTrackedBy().forEach(player -> this.sendPacket((org.bukkit.entity.Player)player, (Packet<?>)update));
        });
        return true;
    }

    @Override
    public boolean spawn(Location location) {
        CraftServer server = (CraftServer)this.plugin.getServer();
        ServerLevel level = ((CraftWorld)location.getWorld()).getHandle();
        if (this.entity != null && !((org.bukkit.entity.Player)this.entity).isValid()) {
            ServerPlayer handle = ((CraftPlayer)this.entity).getHandle();
            handle.setHealth(handle.getMaxHealth());
            if (this.isRealPlayer()) {
                server.getHandle().respawn(handle, false, Entity.RemovalReason.KILLED, PlayerRespawnEvent.RespawnReason.DEATH, location);
            } else {
                handle.unsetRemoved();
                handle.setServerLevel(level);
                handle.spawnIn(level);
                this.broadcastCharacter();
                handle.teleportTo(level, location.getX(), location.getY(), location.getZ(), Set.of(), location.getYaw(), location.getPitch(), false);
            }
            return true;
        }
        if (this.isSpawned()) {
            return false;
        }
        this.spawnLocation = location;
        ClientInformation information = this.createClientInformation();
        CommonListenerCookie cookie = new CommonListenerCookie(this.profile.getGameProfile(), 0, information, false, null, Set.of(), new KeepAlive());
        ServerCharacter serverPlayer = new ServerCharacter((MinecraftServer)server.getServer(), level, information, cookie);
        this.entity = new CraftPlayerCharacter(this, server, serverPlayer);
        server.getServer().getConnection().getConnections().add(serverPlayer.connection.connection);
        if (!this.isRealPlayer()) {
            serverPlayer.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            serverPlayer.setServerLevel(level);
            serverPlayer.spawnIn(level);
            serverPlayer.setPosRaw(location.getX(), location.getY(), location.getZ(), true);
            serverPlayer.setRot(location.getYaw(), location.getPitch());
            serverPlayer.supressTrackerForLogin = true;
            level.addNewPlayer((ServerPlayer)serverPlayer);
            serverPlayer.sentListPacket = true;
            serverPlayer.supressTrackerForLogin = false;
            level.getChunkSource().chunkMap.addEntity((net.minecraft.world.entity.Entity)serverPlayer);
            this.broadcastCharacter();
        } else {
            server.getHandle().placeNewPlayer(serverPlayer.connection.connection, (ServerPlayer)serverPlayer, cookie);
            serverPlayer.teleportTo(level, location.getX(), location.getY(), location.getZ(), Set.of(), location.getYaw(), location.getPitch(), false);
        }
        this.preSpawn((org.bukkit.entity.Player)this.entity);
        this.applySkinPartConfig(serverPlayer);
        serverPlayer.setClientLoaded(true);
        this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> {
            if (this.entity == null) {
                scheduledTask.cancel();
            } else if (serverPlayer.valid) {
                serverPlayer.doTick();
            }
        }, 1L, 1L);
        return true;
    }

    @Override
    public void remove() {
        this.plugin.getServer().getOnlinePlayers().forEach(player -> {
            Team team = player.getScoreboard().getTeam(this.getScoreboardName());
            if (team != null) {
                team.unregister();
            }
        });
        super.remove();
    }

    @Override
    public PlayerCharacter deserialize(Tag tag, TagDeserializationContext context) throws ParserException {
        CompoundTag root = tag.getAsCompound();
        root.optional("listed").map(Tag::getAsBoolean).ifPresent(this::setListed);
        root.optional("properties").map(Tag::getAsList).map(tags -> tags.stream().map(t -> context.deserialize((Tag)t, ProfileProperty.class)).toList()).ifPresent(arg_0 -> ((PlayerProfile)this.getGameProfile()).setProperties(arg_0));
        root.optional("realPlayer").map(Tag::getAsBoolean).ifPresent(this::setRealPlayer);
        root.optional("skinParts").map(Tag::getAsByte).map(PaperSkinParts::new).ifPresent(this::setSkinParts);
        return (PlayerCharacter)super.deserialize(tag, context);
    }

    @Override
    public PlayerProfile getGameProfile() {
        return this.profile;
    }

    @Override
    public @Nullable ProfileProperty getTextures() {
        return this.getGameProfile().getProperties().stream().filter(property -> property.getName().equals("textures")).findAny().orElse(null);
    }

    @Override
    public SkinParts getSkinParts() {
        return this.skinParts;
    }

    @Override
    public boolean setSkinParts(SkinParts parts) {
        if (this.skinParts == parts) {
            return false;
        }
        this.skinParts = parts;
        this.getEntity(CraftPlayer.class).map(CraftPlayer::getHandle).ifPresent(this::applySkinPartConfig);
        return true;
    }

    @Override
    public UUID getUniqueId() {
        return Objects.requireNonNull(this.profile.getId());
    }

    @Override
    public boolean clearTextures() {
        if (!this.getGameProfile().getProperties().removeIf(property -> property.getName().equals("textures"))) {
            return false;
        }
        this.update();
        return true;
    }

    @Override
    public boolean isListed() {
        return this.listed;
    }

    @Override
    public boolean setListed(boolean listed) {
        if (this.listed == listed) {
            return false;
        }
        this.listed = listed;
        this.getEntity(CraftPlayer.class).ifPresent(entity -> {
            entity.getHandle().updateOptionsNoEvents(this.createClientInformation());
            ClientboundPlayerInfoUpdatePacket update = ClientboundPlayerInfoUpdatePacket.updateListed((UUID)entity.getUniqueId(), (boolean)listed);
            entity.getTrackedBy().forEach(player -> this.sendPacket((org.bukkit.entity.Player)player, (Packet<?>)update));
        });
        return true;
    }

    @Override
    public boolean isRealPlayer() {
        return this.realPlayer;
    }

    @Override
    public boolean setRealPlayer(boolean real) {
        if (this.realPlayer == real) {
            return false;
        }
        this.realPlayer = real;
        return true;
    }

    @Override
    public boolean setTextures(String value, @Nullable String signature) {
        ProfileProperty previous = this.getTextures();
        if (previous != null && previous.getValue().equals(value) && Objects.equals(previous.getSignature(), signature)) {
            return false;
        }
        this.getGameProfile().getProperties().removeIf(property -> property.getName().equals("textures"));
        this.getGameProfile().getProperties().add(new ProfileProperty("textures", value, signature));
        this.update();
        return true;
    }

    @Override
    public void loadCharacter(org.bukkit.entity.Player player) {
        this.getEntity(CraftPlayer.class).ifPresent(entity -> {
            if (this.isVisibleByDefault()) {
                this.sendPacket(player, (Packet<?>)new ClientboundBundlePacket(List.of(this.createAddPacket(entity.getHandle()), this.createInitializationPacket(entity.getHandle()))));
            } else if (this.canSee(player)) {
                player.showEntity((Plugin)this.plugin, (Entity)entity);
            } else {
                player.hideEntity((Plugin)this.plugin, (Entity)entity);
            }
            this.updateTeamOptions(this.getCharacterSettingsTeam(player));
        });
    }

    private void applySkinPartConfig(ServerPlayer player) {
        player.getEntityData().set(Player.DATA_PLAYER_MODE_CUSTOMISATION, (Object)((byte)this.getSkinParts().getRaw()));
    }

    private void broadcastCharacter() {
        this.getEntity(CraftPlayer.class).ifPresent(entity -> {
            ServerPlayer handle = entity.getHandle();
            ClientboundBundlePacket packets = new ClientboundBundlePacket(List.of(this.createInitializationPacket(entity.getHandle()), this.createAddPacket(entity.getHandle())));
            entity.getWorld().getPlayersSeeingChunk(entity.getChunk()).stream().filter(this::canSee).forEach(player -> this.sendPacket((org.bukkit.entity.Player)player, (Packet<?>)packets));
        });
    }

    private ClientboundAddEntityPacket createAddPacket(ServerPlayer entity) {
        return new ClientboundAddEntityPacket(entity.getId(), entity.getUUID(), entity.getX(), entity.getY(), entity.getZ(), entity.getXRot(), entity.getYRot(), entity.getType(), 0, entity.getDeltaMovement(), (double)entity.getYHeadRot());
    }

    private ClientInformation createClientInformation() {
        return new ClientInformation("en_us", 2, ChatVisiblity.HIDDEN, true, this.skinParts.getRaw(), Player.DEFAULT_MAIN_HAND, false, this.isListed(), ParticleStatus.MINIMAL);
    }

    private ClientboundPlayerInfoUpdatePacket createInitializationPacket(ServerPlayer entity) {
        return ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing((ServerPlayer)entity, (boolean)this.isListed());
    }

    public void sendPacket(org.bukkit.entity.Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().connection.send(packet);
    }

    private boolean update() {
        if (this.entity == null) {
            return false;
        }
        ServerPlayer handle = ((CraftPlayer)this.entity).getHandle();
        ClientboundRemoveEntitiesPacket remove = new ClientboundRemoveEntitiesPacket(new int[]{handle.getId()});
        ClientboundPlayerInfoRemovePacket removeInfo = new ClientboundPlayerInfoRemovePacket(List.of(handle.getUUID()));
        ClientboundSetEntityDataPacket update = new ClientboundSetEntityDataPacket(handle.getId(), handle.getEntityData().packAll());
        ClientboundBundlePacket packets = new ClientboundBundlePacket(List.of(remove, removeInfo, this.createInitializationPacket(handle), this.createAddPacket(handle), update));
        ((org.bukkit.entity.Player)this.entity).getTrackedBy().forEach(player -> this.sendPacket((org.bukkit.entity.Player)player, (Packet<?>)packets));
        return true;
    }

    @Override
    protected boolean showDisplayName() {
        return this.displayNameVisible;
    }

    public class ServerCharacter
    extends ServerPlayer {
        public ServerCharacter(MinecraftServer server, ServerLevel level, ClientInformation information, CommonListenerCookie cookie) {
            super(server, level, PaperPlayerCharacter.this.profile.getGameProfile(), information);
            this.connection = new EmptyPacketListener(server, this, cookie);
        }

        public boolean isPushable() {
            return false;
        }

        public boolean isCollidable(boolean ignoreClimbing) {
            return false;
        }

        public boolean isPushedByFluid() {
            return true;
        }

        public String getScoreboardName() {
            return PaperPlayerCharacter.this.getScoreboardName();
        }

        public int getTeamColor() {
            return PaperPlayerCharacter.this.teamColor != null ? PaperPlayerCharacter.this.teamColor.value() : super.getTeamColor();
        }

        public Component getTabListDisplayName() {
            return Component.literal((String)"[NPC] ").append(PaperPlayerCharacter.this.getName()).withColor(this.getTeamColor());
        }
    }
}

