/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.plugin;

import com.destroystokyo.paper.profile.ProfileProperty;
import core.i18n.file.ComponentBundle;
import core.io.IO;
import core.io.PathIO;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.TriState;
import net.thenextlvl.character.Character;
import net.thenextlvl.character.CharacterProvider;
import net.thenextlvl.character.PlayerCharacter;
import net.thenextlvl.character.action.ActionType;
import net.thenextlvl.character.action.ClickAction;
import net.thenextlvl.character.bstats.bukkit.Metrics;
import net.thenextlvl.character.plugin.character.PaperCharacter;
import net.thenextlvl.character.plugin.character.PaperCharacterController;
import net.thenextlvl.character.plugin.character.PaperPlayerCharacter;
import net.thenextlvl.character.plugin.character.PaperSkinFactory;
import net.thenextlvl.character.plugin.character.goal.PaperGoalFactory;
import net.thenextlvl.character.plugin.codec.EntityCodecs;
import net.thenextlvl.character.plugin.command.CharacterCommand;
import net.thenextlvl.character.plugin.listener.CharacterListener;
import net.thenextlvl.character.plugin.listener.ConnectionListener;
import net.thenextlvl.character.plugin.listener.EntityListener;
import net.thenextlvl.character.plugin.model.MessageMigrator;
import net.thenextlvl.character.plugin.serialization.ActionTypeAdapter;
import net.thenextlvl.character.plugin.serialization.AttributeAdapter;
import net.thenextlvl.character.plugin.serialization.BlockDataAdapter;
import net.thenextlvl.character.plugin.serialization.BrightnessAdapter;
import net.thenextlvl.character.plugin.serialization.CatVariantAdapter;
import net.thenextlvl.character.plugin.serialization.CharacterSerializer;
import net.thenextlvl.character.plugin.serialization.ClickActionAdapter;
import net.thenextlvl.character.plugin.serialization.ColorAdapter;
import net.thenextlvl.character.plugin.serialization.ComponentAdapter;
import net.thenextlvl.character.plugin.serialization.EntityTypeAdapter;
import net.thenextlvl.character.plugin.serialization.EquipmentSlotGroupAdapter;
import net.thenextlvl.character.plugin.serialization.FrogVariantAdapter;
import net.thenextlvl.character.plugin.serialization.ItemStackAdapter;
import net.thenextlvl.character.plugin.serialization.KeyAdapter;
import net.thenextlvl.character.plugin.serialization.LocationAdapter;
import net.thenextlvl.character.plugin.serialization.NamedTextColorAdapter;
import net.thenextlvl.character.plugin.serialization.ProfilePropertyAdapter;
import net.thenextlvl.character.plugin.serialization.QuaternionfAdapter;
import net.thenextlvl.character.plugin.serialization.SoundAdapter;
import net.thenextlvl.character.plugin.serialization.TitleAdapter;
import net.thenextlvl.character.plugin.serialization.TitleTimesAdapter;
import net.thenextlvl.character.plugin.serialization.Vector3fAdapter;
import net.thenextlvl.character.plugin.serialization.WorldAdapter;
import net.thenextlvl.character.plugin.version.PluginVersionChecker;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.serialization.NBT;
import net.thenextlvl.nbt.serialization.ParserException;
import net.thenextlvl.nbt.serialization.adapter.EnumAdapter;
import net.thenextlvl.nbt.tag.CompoundTag;
import net.thenextlvl.nbt.tag.Tag;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CharacterPlugin
extends JavaPlugin
implements CharacterProvider {
    public static final String ISSUES = "https://github.com/TheNextLvl-net/characters/issues/new";
    private final Metrics metrics = new Metrics((Plugin)this, 24223);
    private final File savesFolder = new File(this.getDataFolder(), "saves");
    private final Path translations = this.getDataPath().resolve("translations");
    private final NBT nbt = NBT.builder().registerTypeHierarchyAdapter((Class<?>)ClickAction.class, new ClickActionAdapter()).registerTypeHierarchyAdapter((Class<?>)ActionType.class, new ActionTypeAdapter()).registerTypeHierarchyAdapter((Class<?>)AttributeAdapter.class, new AttributeAdapter()).registerTypeHierarchyAdapter((Class<?>)AttributeModifier.Operation.class, new EnumAdapter<AttributeModifier.Operation>(AttributeModifier.Operation.class)).registerTypeHierarchyAdapter((Class<?>)BlockData.class, new BlockDataAdapter(this.getServer())).registerTypeHierarchyAdapter((Class<?>)Display.Brightness.class, new BrightnessAdapter()).registerTypeHierarchyAdapter((Class<?>)Cat.Type.class, new CatVariantAdapter()).registerTypeHierarchyAdapter(Character.class, new CharacterSerializer()).registerTypeHierarchyAdapter((Class<?>)Color.class, new ColorAdapter()).registerTypeHierarchyAdapter((Class<?>)Component.class, new ComponentAdapter()).registerTypeHierarchyAdapter((Class<?>)DyeColor.class, new EnumAdapter<DyeColor>(DyeColor.class)).registerTypeHierarchyAdapter((Class<?>)EntityEffect.class, new EnumAdapter<EntityEffect>(EntityEffect.class)).registerTypeHierarchyAdapter((Class<?>)EntityType.class, new EntityTypeAdapter()).registerTypeHierarchyAdapter((Class<?>)EquipmentSlotGroup.class, new EquipmentSlotGroupAdapter()).registerTypeHierarchyAdapter((Class<?>)Fox.Type.class, new EnumAdapter<Fox.Type>(Fox.Type.class)).registerTypeHierarchyAdapter((Class<?>)Frog.Variant.class, new FrogVariantAdapter()).registerTypeHierarchyAdapter((Class<?>)ItemStack.class, new ItemStackAdapter()).registerTypeHierarchyAdapter((Class<?>)Key.class, new KeyAdapter()).registerTypeHierarchyAdapter((Class<?>)Location.class, new LocationAdapter()).registerTypeHierarchyAdapter((Class<?>)NamedTextColor.class, new NamedTextColorAdapter()).registerTypeHierarchyAdapter((Class<?>)Particle.class, new EnumAdapter<Particle>(Particle.class)).registerTypeHierarchyAdapter((Class<?>)Pose.class, new EnumAdapter<Pose>(Pose.class)).registerTypeHierarchyAdapter((Class<?>)PotionType.class, new EnumAdapter<PotionType>(PotionType.class)).registerTypeHierarchyAdapter((Class<?>)ProfileProperty.class, new ProfilePropertyAdapter()).registerTypeHierarchyAdapter((Class<?>)Quaternionf.class, new QuaternionfAdapter()).registerTypeHierarchyAdapter((Class<?>)Sound.class, new SoundAdapter()).registerTypeHierarchyAdapter((Class<?>)Title.Times.class, new TitleTimesAdapter()).registerTypeHierarchyAdapter((Class<?>)Title.class, new TitleAdapter()).registerTypeHierarchyAdapter((Class<?>)TriState.class, new EnumAdapter<TriState>(TriState.class)).registerTypeHierarchyAdapter((Class<?>)Vector3f.class, new Vector3fAdapter()).registerTypeHierarchyAdapter((Class<?>)World.class, new WorldAdapter(this.getServer())).build();
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final PaperCharacterController characterController = new PaperCharacterController(this);
    private final PaperGoalFactory goalFactory = new PaperGoalFactory(this);
    private final PaperSkinFactory skinFactory = new PaperSkinFactory(this);
    private final Key key = Key.key((String)"characters", (String)"translations");
    private final ComponentBundle bundle = ComponentBundle.builder(this.key, this.translations).placeholder("prefix", "prefix").resource("messages.properties", Locale.US).resource("messages_german.properties", Locale.GERMANY).migrator(new MessageMigrator()).build();

    public void onLoad() {
        this.getServer().getServicesManager().register(CharacterProvider.class, (Object)this, (Plugin)this, ServicePriority.Highest);
        this.versionChecker.checkVersion();
    }

    public void onDisable() {
        this.characterController.getCharacters().forEach(character -> {
            character.persist();
            character.remove();
        });
        this.metrics.shutdown();
    }

    public void onEnable() {
        EntityCodecs.registerAll();
        this.readAll().forEach(character -> {
            Optional<Location> location = character.getSpawnLocation();
            if (location.map(character::spawn).orElse(true).booleanValue()) {
                return;
            }
            this.getComponentLogger().warn("Failed to spawn character {}", (Object)character.getName());
        });
        this.registerCommands();
        this.registerListeners();
    }

    public @Unmodifiable List<Character<?>> readAll() {
        File[] files = this.savesFolder.listFiles((file, name) -> name.endsWith(".dat"));
        return files == null ? List.of() : Arrays.stream(files).map(this::readSafe).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public @Nullable Character<?> read(File file) throws IOException {
        Character<?> character;
        block15: {
            NBTInputStream inputStream = this.stream(IO.of(file));
            try {
                character = this.read(inputStream);
                if (inputStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    PathIO io = IO.of(file.getPath() + "_old", new String[0]);
                    if (!io.exists(new LinkOption[0])) {
                        throw e;
                    }
                    this.getComponentLogger().warn("Failed to load character from {}", (Object)file.getPath(), (Object)e);
                    this.getComponentLogger().warn("Falling back to {}", (Object)io);
                    try (NBTInputStream inputStream2 = this.stream(io);){
                        Character<?> character2 = this.read(inputStream2);
                        return character2;
                    }
                }
            }
            inputStream.close();
        }
        return character;
    }

    public ComponentBundle bundle() {
        return this.bundle;
    }

    public File savesFolder() {
        return this.savesFolder;
    }

    public NBT nbt() {
        return this.nbt;
    }

    @Override
    public PaperCharacterController characterController() {
        return this.characterController;
    }

    @Override
    public PaperGoalFactory goalFactory() {
        return this.goalFactory;
    }

    @Override
    public PaperSkinFactory skinFactory() {
        return this.skinFactory;
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> ((Commands)event.registrar()).register(CharacterCommand.create(this), List.of("npc"))));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new CharacterListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
    }

    private @Nullable Character<?> readSafe(File file) {
        try {
            return this.read(file);
        }
        catch (EOFException e) {
            this.getComponentLogger().error("The character file {} is irrecoverably broken", (Object)file.getPath());
            return null;
        }
        catch (Exception e) {
            this.getComponentLogger().error("Failed to load character from {}", (Object)file.getPath(), (Object)e);
            this.getComponentLogger().error("Please look for similar issues or report this on GitHub: {}", (Object)ISSUES);
            return null;
        }
    }

    private NBTInputStream stream(IO file) throws IOException {
        return new NBTInputStream(file.inputStream(StandardOpenOption.READ), StandardCharsets.UTF_8);
    }

    private @Nullable Character<?> read(NBTInputStream inputStream) throws IOException {
        Location location;
        Map.Entry<Tag, Optional<String>> entry = inputStream.readNamedTag();
        CompoundTag root = entry.getKey().getAsCompound();
        String name = entry.getValue().orElseThrow(() -> new ParserException("Character misses root name"));
        EntityType type = this.nbt.deserialize((Tag)root.get("type"), EntityType.class);
        try {
            location = root.optional("location").map(tag -> this.nbt.deserialize((Tag)tag, Location.class)).orElse(null);
        }
        catch (ParserException e) {
            this.getComponentLogger().warn("Skip loading character '{}': {}", (Object)name, (Object)e.getMessage());
            return null;
        }
        Character<Player> character = type.equals((Object)EntityType.PLAYER) ? this.createPlayerCharacter(root, name) : this.createCharacter(root, name, type);
        this.characterController.characters.put(name, character);
        character.setSpawnLocation(location);
        return character;
    }

    private PlayerCharacter createPlayerCharacter(CompoundTag root, String name) {
        UUID uuid = root.optional("uuid").map(tag -> this.nbt.deserialize((Tag)tag, UUID.class)).orElseGet(UUID::randomUUID);
        return new PaperPlayerCharacter(this, name, uuid).deserialize(root, this.nbt);
    }

    private Character<?> createCharacter(CompoundTag root, String name, EntityType type) {
        return new PaperCharacter(this, name, type).deserialize(root, this.nbt);
    }
}

