/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.character.action;

import core.paper.messenger.PluginMessenger;
import io.papermc.paper.entity.TeleportFlag;
import java.net.InetSocketAddress;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.thenextlvl.character.action.ActionType;
import net.thenextlvl.character.action.ActionTypes;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class SimpleActionTypes
implements ActionTypes {
    public static final ActionTypes INSTANCE = new SimpleActionTypes();
    private final PluginMessenger messenger = new PluginMessenger((Plugin)JavaPlugin.getProvidingPlugin(SimpleActionTypes.class));
    private final ActionType<String> sendActionbar = ActionType.builder("send_actionbar", String.class).action((player, character, input) -> {
        TagResolver.Single placeholder = Placeholder.parsed((String)"player", (String)player.getName());
        Component message = MiniMessage.miniMessage().deserialize(input, (TagResolver)placeholder);
        player.sendActionBar(message);
    }).build();
    private final ActionType<String> sendMessage = ActionType.builder("send_message", String.class).action((player, character, input) -> {
        TagResolver.Single placeholder = Placeholder.parsed((String)"player", (String)player.getName());
        player.sendMessage(MiniMessage.miniMessage().deserialize(input, (TagResolver)placeholder));
    }).build();
    private final ActionType<EntityEffect> sendEntityEffect = ActionType.builder("send_entity_effect", EntityEffect.class).action((player, character, effect) -> player.sendEntityEffect(effect, character)).applicable((effect, character) -> effect.isApplicableTo(character.getEntityClass()) && !this.isDeprecated((Enum<?>)effect)).build();
    private final ActionType<InetSocketAddress> transfer = ActionType.builder("transfer", InetSocketAddress.class).action((player, character, address) -> player.transfer(address.getHostName(), address.getPort())).build();
    private final ActionType<Location> teleport = ActionType.builder("teleport", Location.class).action((player, character, location) -> player.teleportAsync(location, PlayerTeleportEvent.TeleportCause.PLUGIN, new TeleportFlag[]{TeleportFlag.EntityState.RETAIN_PASSENGERS})).build();
    private final ActionType<Sound> playSound = ActionType.builder("play_sound", Sound.class).action((player, character, sound) -> player.playSound(sound)).build();
    private final ActionType<String> runConsoleCommand = ActionType.builder("run_console_command", String.class).action((player, character, input) -> {
        String command = input.replace("<player>", player.getName());
        player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), command);
    }).build();
    private final ActionType<String> runCommand = ActionType.builder("run_command", String.class).action((player, character, input) -> player.performCommand(input.replace("<player>", player.getName()))).build();
    private final ActionType<Title> sendTitle = ActionType.builder("send_title", Title.class).action((player, character, title) -> player.showTitle(title)).build();
    private final ActionType<String> connect = ActionType.builder("connect", String.class).action((player, character, server) -> this.messenger.connect(player, (String)server)).build();

    SimpleActionTypes() {
    }

    @Override
    public ActionType<String> sendActionbar() {
        return this.sendActionbar;
    }

    @Override
    public ActionType<String> sendMessage() {
        return this.sendMessage;
    }

    @Override
    public ActionType<EntityEffect> sendEntityEffect() {
        return this.sendEntityEffect;
    }

    @Override
    public ActionType<InetSocketAddress> transfer() {
        return this.transfer;
    }

    @Override
    public ActionType<Location> teleport() {
        return this.teleport;
    }

    @Override
    public ActionType<Sound> playSound() {
        return this.playSound;
    }

    @Override
    public ActionType<String> runConsoleCommand() {
        return this.runConsoleCommand;
    }

    @Override
    public ActionType<String> runCommand() {
        return this.runCommand;
    }

    @Override
    public ActionType<Title> sendTitle() {
        return this.sendTitle;
    }

    @Override
    public ActionType<String> connect() {
        return this.connect;
    }

    private boolean isDeprecated(Enum<?> anEnum) {
        try {
            return anEnum.getDeclaringClass().getField(anEnum.name()).isAnnotationPresent(Deprecated.class);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }
}

