/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class StringUtil {
    private static final char[] chars = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz1234567890".toCharArray();
    private static final Map<Integer, String> symbolMap = new LinkedHashMap<Integer, String>(13);

    public static String random(char[] chars, @Range(from=0L, to=0x7FFFFFFFL) int length) {
        if (chars.length == 0) {
            throw new IllegalArgumentException("Chars must not be empty");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative");
        }
        if (chars.length == 1) {
            return String.valueOf(chars[0]).repeat(length);
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(chars[random.nextInt(0, chars.length)]);
        }
        return builder.toString();
    }

    public static String random(int length) {
        return StringUtil.random(chars, length);
    }

    public static String roman(@Range(from=1L, to=3999L) int input) {
        if (input < 1 || input > 3999) {
            throw new IllegalArgumentException("Input must be between 1 and 3999");
        }
        StringBuilder roman = new StringBuilder();
        for (Map.Entry<Integer, String> entry : symbolMap.entrySet()) {
            int value = entry.getKey();
            String symbol = entry.getValue();
            while (input >= value) {
                roman.append(symbol);
                input -= value;
            }
        }
        return roman.toString();
    }

    public static boolean isPalindrome(String string) {
        int i = 0;
        for (int j = string.length() - 1; i < j; ++i, --j) {
            if (string.charAt(i) == string.charAt(j)) continue;
            return false;
        }
        return true;
    }

    static {
        symbolMap.put(1000, "M");
        symbolMap.put(900, "CM");
        symbolMap.put(500, "D");
        symbolMap.put(400, "CD");
        symbolMap.put(100, "C");
        symbolMap.put(90, "XC");
        symbolMap.put(50, "L");
        symbolMap.put(40, "XL");
        symbolMap.put(10, "X");
        symbolMap.put(9, "IX");
        symbolMap.put(5, "V");
        symbolMap.put(4, "IV");
        symbolMap.put(1, "I");
    }
}

