/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.Instant;
import java.util.Objects;
import java.util.function.Consumer;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.Users.DBUser;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class OnlineUser
extends DBUser {
    protected final Player playerInstance;
    private long afkStartPlaytime;
    private long currentSessionAFKTime;
    private boolean afkTimeFinalized;

    private OnlineUser(Player p) {
        this.playerInstance = p;
        this.uuid = p.getUniqueId().toString();
        this.nickname = p.getName();
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.afkStartPlaytime = 0L;
        this.currentSessionAFKTime = 0L;
        this.afkTimeFinalized = false;
    }

    public static void createOnlineUserAsync(Player p, Consumer<OnlineUser> callback) {
        OnlineUser user = new OnlineUser(p);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            user.userMappingSync();
            user.loadUserDataSync();
            if (user.firstJoin == null) {
                user.firstJoin = Instant.now();
                db.getPlayerDAO().updateFirstJoin(user.uuid, user.firstJoin);
            }
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> callback.accept(user));
        });
    }

    private void userMappingSync() {
        boolean uuidExists = db.getPlayerDAO().playerExists(this.uuid);
        String existingNickname = uuidExists ? db.getPlayerDAO().getNickname(this.uuid) : null;
        String existingUUID = db.getPlayerDAO().getUUIDFromNickname(this.nickname);
        if (uuidExists) {
            if (!this.nickname.equals(existingNickname)) {
                db.getPlayerDAO().updateNickname(this.uuid, this.nickname);
            }
        } else if (existingUUID != null) {
            db.getPlayerDAO().updateUUID(this.uuid, this.nickname);
        } else {
            db.getPlayerDAO().addNewPlayer(this.uuid, this.nickname, this.fromServerOnJoinPlayTime);
        }
    }

    private long getCachedPlayTime() {
        return this.DBplaytime + ((long)this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE) - this.fromServerOnJoinPlayTime);
    }

    public void updatePlayTimeWithSnapshotAsync(long playtimeSnapshot, Runnable callback) {
        long currentPlaytime = this.DBplaytime + (playtimeSnapshot - this.fromServerOnJoinPlayTime);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updatePlaytime(this.uuid, currentPlaytime);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void updatePlayTimeWithSnapshot(long playtimeSnapshot) {
        this.updatePlayTimeWithSnapshotAsync(playtimeSnapshot, null);
    }

    public void updatePlayTimeAsync(Runnable callback) {
        long currentPlaytime = this.getCachedPlayTime();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updatePlaytime(this.uuid, currentPlaytime);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void updatePlayTime() {
        this.updatePlayTimeAsync(null);
    }

    public void updateAFKPlayTimeAsync(Runnable callback) {
        if (!this.afkTimeFinalized) {
            this.finalizeCurrentAFKSession();
        }
        long totalAFKTime = this.DBAFKplaytime + this.currentSessionAFKTime;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updateAFKPlaytime(this.uuid, totalAFKTime);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void updateAFKPlayTime() {
        this.updateAFKPlayTimeAsync(null);
    }

    public void updateAFKPlayTimeWithSnapshotAsync(long playtimeSnapshot, Runnable callback) {
        if (!this.afkTimeFinalized) {
            this.finalizeCurrentAFKSession(playtimeSnapshot);
        }
        long totalAFKTime = this.DBAFKplaytime + this.currentSessionAFKTime;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updateAFKPlaytime(this.uuid, totalAFKTime);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void updateAFKPlayTimeWithSnapshot(long playtimeSnapshot) {
        this.updateAFKPlayTimeWithSnapshotAsync(playtimeSnapshot, null);
    }

    public void updateLastSeenAsync(Runnable callback) {
        Instant timestampToSave = this.lastSeen = Instant.now();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updateLastSeen(this.uuid, timestampToSave);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void updateLastSeen() {
        this.updateLastSeenAsync(null);
    }

    public Player getPlayerInstance() {
        return this.playerInstance;
    }

    @Override
    public long getPlaytime() {
        long totalPlaytime = this.getCachedPlayTime() + this.artificialPlaytime;
        if (plugin.getConfiguration().getBoolean("ignore-afk-time").booleanValue()) {
            totalPlaytime -= this.getAFKPlaytime();
        }
        return Math.max(0L, totalPlaytime);
    }

    @Override
    public long getPlaytimeWithSnapshot(long playtimeSnapshot) {
        long totalPlaytime = this.DBplaytime + (playtimeSnapshot - this.fromServerOnJoinPlayTime) + this.artificialPlaytime;
        if (plugin.getConfiguration().getBoolean("ignore-afk-time").booleanValue()) {
            totalPlaytime -= this.getAFKPlaytimeWithSnapshot(playtimeSnapshot);
        }
        return Math.max(0L, totalPlaytime);
    }

    @Override
    public long getAFKPlaytime() {
        long totalAFK = this.DBAFKplaytime + this.currentSessionAFKTime;
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long currentPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
            long ongoingAFKTime = currentPlaytime - this.afkStartPlaytime;
            totalAFK += ongoingAFKTime;
        }
        return Math.max(0L, totalAFK);
    }

    @Override
    public long getAFKPlaytimeWithSnapshot(long playtimeSnapshot) {
        long totalAFK = this.DBAFKplaytime + this.currentSessionAFKTime;
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long ongoingAFKTime = playtimeSnapshot - this.afkStartPlaytime;
            totalAFK += ongoingAFKTime;
        }
        return Math.max(0L, totalAFK);
    }

    @Override
    public Instant getLastSeen() {
        return Instant.now();
    }

    public void refreshFromServerOnJoinPlayTime() {
        this.fromServerOnJoinPlayTime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
    }

    @Override
    public void setAFK(boolean isAFK) {
        if (isAFK && !this.afk) {
            this.afk = true;
            this.afkStartPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
            this.afkTimeFinalized = false;
        } else if (!isAFK && this.afk) {
            if (this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
                long currentPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
                long afkDuration = currentPlaytime - this.afkStartPlaytime;
                this.currentSessionAFKTime += afkDuration;
            }
            this.afk = false;
            this.afkStartPlaytime = 0L;
            this.afkTimeFinalized = false;
        }
    }

    public void finalizeCurrentAFKSession(long playtimeSnapshot) {
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long afkDuration = playtimeSnapshot - this.afkStartPlaytime;
            this.currentSessionAFKTime += afkDuration;
            this.afkTimeFinalized = true;
        }
    }

    public void finalizeCurrentAFKSession() {
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long currentPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
            long afkDuration = currentPlaytime - this.afkStartPlaytime;
            this.currentSessionAFKTime += afkDuration;
            this.afkTimeFinalized = true;
        }
    }

    public boolean isExpired(RewardSubInstance subInstance) {
        for (RewardSubInstance subInstance2 : this.rewardsToBeClaimed) {
            if (!Objects.equals(subInstance2.mainInstanceID(), subInstance.mainInstanceID()) || !Objects.equals(subInstance2.requiredJoins(), subInstance.requiredJoins())) continue;
            return subInstance2.expired();
        }
        return false;
    }

    public void updateAllOnQuitAsync(long playtimeSnapshot, Runnable callback) {
        Instant lastSeenTime;
        if (!this.afkTimeFinalized) {
            this.finalizeCurrentAFKSession(playtimeSnapshot);
        }
        long currentPlaytime = this.DBplaytime + (playtimeSnapshot - this.fromServerOnJoinPlayTime);
        long totalAFKTime = this.DBAFKplaytime + this.currentSessionAFKTime;
        this.lastSeen = lastSeenTime = Instant.now();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updatePlaytime(this.uuid, currentPlaytime);
            db.getPlayerDAO().updateAFKPlaytime(this.uuid, totalAFKTime);
            db.getPlayerDAO().updateLastSeen(this.uuid, lastSeenTime);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void updateAllOnQuit(long playtimeSnapshot) {
        this.updateAllOnQuitAsync(playtimeSnapshot, null);
    }
}

