/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DBUser {
    protected String uuid;
    protected String nickname;
    protected long DBplaytime;
    protected long artificialPlaytime;
    protected long DBAFKplaytime;
    protected static final PlayTimeManager plugin = PlayTimeManager.getInstance();
    protected long fromServerOnJoinPlayTime;
    protected ArrayList<String> completedGoals;
    protected static DatabaseHandler db = DatabaseHandler.getInstance();
    protected Instant lastSeen;
    protected Instant firstJoin;
    protected final GoalsManager goalsManager = GoalsManager.getInstance();
    protected int relativeJoinStreak;
    protected int absoluteJoinStreak;
    protected ArrayList<RewardSubInstance> receivedRewards = new ArrayList();
    protected ArrayList<RewardSubInstance> rewardsToBeClaimed = new ArrayList();
    protected boolean afk;
    protected OfflinePlayer playerInstance;
    protected ArrayList<String> notReceivedGoals;
    public static final DBUser LOADING = new DBUser();
    public static final DBUser NOT_FOUND = new DBUser();

    private DBUser(String uuid, String nickname, long playtime, long artificialPlaytime, long DBAFKplaytime, ArrayList<String> completedGoals, ArrayList<String> notReceivedGoals, Instant lastSeen, Instant firstJoin, int relativeJoinStreak, int absoluteJoinStreak, ArrayList<RewardSubInstance> receivedRewards, ArrayList<RewardSubInstance> rewardsToBeClaimed) {
        this.uuid = uuid;
        this.nickname = nickname;
        this.DBplaytime = playtime;
        this.artificialPlaytime = artificialPlaytime;
        this.DBAFKplaytime = DBAFKplaytime;
        this.notReceivedGoals = notReceivedGoals;
        this.completedGoals = completedGoals;
        this.lastSeen = lastSeen;
        this.firstJoin = firstJoin;
        this.relativeJoinStreak = relativeJoinStreak;
        this.absoluteJoinStreak = absoluteJoinStreak;
        this.receivedRewards = receivedRewards;
        this.rewardsToBeClaimed = rewardsToBeClaimed;
        this.afk = false;
        this.playerInstance = null;
    }

    protected DBUser() {
        this.completedGoals = new ArrayList();
        this.receivedRewards = new ArrayList();
        this.rewardsToBeClaimed = new ArrayList();
        this.afk = false;
        this.playerInstance = null;
    }

    public static void createDBUserAsync(Player p, Consumer<DBUser> callback) {
        String uuid = p.getUniqueId().toString();
        String nickname = p.getName();
        long fromServerPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            DBUser user = new DBUser(uuid, nickname, 0L, 0L, 0L, new ArrayList<String>(), new ArrayList<String>(), null, null, 0, 0, new ArrayList<RewardSubInstance>(), new ArrayList<RewardSubInstance>());
            user.fromServerOnJoinPlayTime = fromServerPlayTime;
            user.userMapping();
            user.loadUserDataSync();
            if (user.firstJoin == null) {
                user.firstJoin = Instant.now();
                db.getPlayerDAO().updateFirstJoin(uuid, user.firstJoin);
            }
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> callback.accept(user));
        });
    }

    public static void fromUUIDAsync(String uuid, Consumer<DBUser> callback) {
        if (uuid == null) {
            callback.accept(null);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            DBUser user = DBUser.fromUUIDSync(uuid);
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> callback.accept(user));
        });
    }

    private static DBUser fromUUIDSync(String uuid) {
        if (uuid == null) {
            return null;
        }
        String nickname = db.getPlayerDAO().getNickname(uuid);
        long playtime = db.getPlayerDAO().getPlaytime(uuid);
        long artificialPlaytime = db.getPlayerDAO().getArtificialPlaytime(uuid);
        long afkplaytime = db.getPlayerDAO().getAFKPlaytime(uuid);
        ArrayList<String> completedGoals = db.getGoalsDAO().getCompletedGoals(uuid);
        ArrayList<String> notReceivedGoals = db.getGoalsDAO().getNotReceivedGoals(uuid);
        Instant lastSeen = db.getPlayerDAO().getLastSeen(uuid);
        Instant firstJoin = db.getPlayerDAO().getFirstJoin(uuid);
        int relativeJoinStreak = db.getStreakDAO().getRelativeJoinStreak(uuid);
        int absoluteJoinStreak = db.getStreakDAO().getAbsoluteJoinStreak(uuid);
        ArrayList<RewardSubInstance> receivedRewards = db.getStreakDAO().getReceivedRewards(uuid);
        ArrayList<RewardSubInstance> rewardsToBeClaimed = db.getStreakDAO().getRewardsToBeClaimed(uuid);
        return new DBUser(uuid, nickname, playtime, artificialPlaytime, afkplaytime, completedGoals, notReceivedGoals, lastSeen, firstJoin, relativeJoinStreak, absoluteJoinStreak, receivedRewards, rewardsToBeClaimed);
    }

    protected void loadUserDataSync() {
        this.DBplaytime = db.getPlayerDAO().getPlaytime(this.uuid);
        this.DBAFKplaytime = db.getPlayerDAO().getAFKPlaytime(this.uuid);
        this.artificialPlaytime = db.getPlayerDAO().getArtificialPlaytime(this.uuid);
        this.completedGoals = db.getGoalsDAO().getCompletedGoals(this.uuid);
        this.lastSeen = db.getPlayerDAO().getLastSeen(this.uuid);
        this.firstJoin = db.getPlayerDAO().getFirstJoin(this.uuid);
        this.relativeJoinStreak = db.getStreakDAO().getRelativeJoinStreak(this.uuid);
        this.absoluteJoinStreak = db.getStreakDAO().getRelativeJoinStreak(this.uuid);
        this.receivedRewards = db.getStreakDAO().getReceivedRewards(this.uuid);
        this.rewardsToBeClaimed = db.getStreakDAO().getRewardsToBeClaimed(this.uuid);
        this.notReceivedGoals = db.getGoalsDAO().getNotReceivedGoals(this.uuid);
    }

    protected void loadUserDataAsync(Runnable callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            this.loadUserDataSync();
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public boolean isOnline() {
        return this instanceof OnlineUser;
    }

    public OfflinePlayer getPlayerInstance() {
        if (this.playerInstance != null) {
            return this.playerInstance;
        }
        try {
            this.playerInstance = Bukkit.getOfflinePlayer((String)this.uuid);
            return this.playerInstance;
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid UUID format for player: " + this.uuid);
            return null;
        }
        catch (Exception e) {
            plugin.getLogger().warning("Unexpected error loading player " + this.uuid + ": " + e.getMessage());
            return null;
        }
    }

    public Instant getFirstJoin() {
        return this.firstJoin;
    }

    public Instant getLastSeen() {
        return this.lastSeen;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public long getPlaytime() {
        long totalPlaytime = this.DBplaytime + this.artificialPlaytime;
        if (plugin.getConfiguration().getBoolean("ignore-afk-time").booleanValue()) {
            totalPlaytime -= this.DBAFKplaytime;
        }
        return totalPlaytime;
    }

    public long getPlaytimeWithSnapshot(long playtimeSnapshot) {
        return this.getPlaytime();
    }

    public long getArtificialPlaytime() {
        return this.artificialPlaytime;
    }

    public void setArtificialPlaytimeAsync(long artificialPlaytime, Runnable callback) {
        this.artificialPlaytime = artificialPlaytime;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updateArtificialPlaytime(this.uuid, artificialPlaytime);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void setArtificialPlaytime(long artificialPlaytime) {
        this.setArtificialPlaytimeAsync(artificialPlaytime, null);
    }

    public ArrayList<String> getCompletedGoals() {
        return this.completedGoals;
    }

    public ArrayList<String> getNotReceivedGoals() {
        return this.notReceivedGoals;
    }

    public boolean hasCompletedGoal(String goalName) {
        return this.completedGoals.contains(goalName);
    }

    public void markGoalAsReceivedAsync(String goalName, Runnable callback) {
        this.notReceivedGoals.remove(goalName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getGoalsDAO().markGoalAsReceived(this.uuid, goalName);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void markGoalAsCompletedAsync(String goalName, boolean received, Runnable callback) {
        this.completedGoals.add(goalName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getGoalsDAO().addCompletedGoal(this.uuid, this.nickname, goalName, received);
            if (!received) {
                this.notReceivedGoals.add(goalName);
            }
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void unmarkGoalAsCompletedAsync(String goalName, Runnable callback) {
        this.completedGoals.remove(goalName);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getGoalsDAO().removeCompletedGoal(this.uuid, goalName);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void reloadGoalsSync() {
        this.completedGoals.clear();
        this.completedGoals = db.getGoalsDAO().getCompletedGoals(this.uuid);
    }

    public void unmarkGoalAsCompleted(String goalName) {
        this.unmarkGoalAsCompletedAsync(goalName, null);
    }

    public int getAbsoluteJoinStreak() {
        return this.absoluteJoinStreak;
    }

    public int getRelativeJoinStreak() {
        return this.relativeJoinStreak;
    }

    public void incrementRelativeJoinStreakAsync(Runnable callback) {
        ++this.relativeJoinStreak;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().setRelativeJoinStreak(this.uuid, this.relativeJoinStreak);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void incrementRelativeJoinStreak() {
        this.incrementRelativeJoinStreakAsync(null);
    }

    public void incrementAbsoluteJoinStreakAsync(Runnable callback) {
        ++this.absoluteJoinStreak;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().setAbsoluteJoinStreak(this.uuid, this.absoluteJoinStreak);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void incrementAbsoluteJoinStreak() {
        this.incrementAbsoluteJoinStreakAsync(null);
    }

    public void setRelativeJoinStreakAsync(int value, Runnable callback) {
        this.relativeJoinStreak = value;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().setRelativeJoinStreak(this.uuid, this.relativeJoinStreak);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void setRelativeJoinStreak(int value) {
        this.setRelativeJoinStreakAsync(value, null);
    }

    public void resetJoinStreaksAsync(Runnable callback) {
        this.relativeJoinStreak = 0;
        this.absoluteJoinStreak = 0;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().setAbsoluteJoinStreak(this.uuid, 0);
            db.getStreakDAO().setRelativeJoinStreak(this.uuid, 0);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetJoinStreaks() {
        this.resetJoinStreaksAsync(null);
    }

    public void resetRelativeJoinStreakAsync(Runnable callback) {
        this.relativeJoinStreak = 0;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().setRelativeJoinStreak(this.uuid, 0);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetRelativeJoinStreak() {
        this.resetRelativeJoinStreakAsync(null);
    }

    public void migrateUnclaimedRewardsAsync(Runnable callback) {
        if (this.rewardsToBeClaimed.isEmpty()) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        ArrayList<RewardSubInstance> expiredRewards = new ArrayList<RewardSubInstance>();
        for (RewardSubInstance subInstance : this.rewardsToBeClaimed) {
            RewardSubInstance expiredInstance = new RewardSubInstance(subInstance.mainInstanceID(), subInstance.requiredJoins(), true);
            expiredRewards.add(expiredInstance);
        }
        this.rewardsToBeClaimed.clear();
        this.rewardsToBeClaimed.addAll(expiredRewards);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().markRewardsAsExpired(this.uuid);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void migrateUnclaimedRewards() {
        this.migrateUnclaimedRewardsAsync(null);
    }

    public void unclaimRewardAsync(RewardSubInstance rewardSubInstance, Runnable callback) {
        this.rewardsToBeClaimed.removeIf(unclaimedReward -> unclaimedReward.mainInstanceID().equals(rewardSubInstance.mainInstanceID()) && unclaimedReward.requiredJoins().equals(rewardSubInstance.requiredJoins()));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().removeRewardToBeClaimed(this.uuid, rewardSubInstance);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void unclaimReward(RewardSubInstance rewardSubInstance) {
        this.unclaimRewardAsync(rewardSubInstance, null);
    }

    public void unreceiveRewardAsync(RewardSubInstance rewardSubInstance, Runnable callback) {
        this.receivedRewards.removeIf(receivedReward -> receivedReward.mainInstanceID().equals(rewardSubInstance.mainInstanceID()) && receivedReward.requiredJoins().equals(rewardSubInstance.requiredJoins()));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().removeReceivedReward(this.uuid, rewardSubInstance);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void unreceiveReward(RewardSubInstance rewardSubInstance) {
        this.unreceiveRewardAsync(rewardSubInstance, null);
    }

    public void wipeRewardsToBeClaimed(Integer mainInstanceID) {
        this.rewardsToBeClaimed.removeIf(r -> Objects.equals(r.mainInstanceID(), mainInstanceID));
    }

    public void wipeReceivedRewards(Integer mainInstanceID) {
        this.receivedRewards.removeIf(r -> Objects.equals(r.mainInstanceID(), mainInstanceID));
    }

    public void addRewardToBeClaimedAsync(RewardSubInstance rewardSubInstance, Runnable callback) {
        this.rewardsToBeClaimed.add(rewardSubInstance);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().addRewardToBeClaimed(this.uuid, this.nickname, rewardSubInstance);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void addRewardToBeClaimed(RewardSubInstance rewardSubInstance) {
        this.addRewardToBeClaimedAsync(rewardSubInstance, null);
    }

    public void addReceivedRewardAsync(RewardSubInstance rewardSubInstance, Runnable callback) {
        this.receivedRewards.add(rewardSubInstance);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().addReceivedReward(this.uuid, this.nickname, rewardSubInstance);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void addReceivedReward(RewardSubInstance rewardSubInstance) {
        this.addReceivedRewardAsync(rewardSubInstance, null);
    }

    public ArrayList<RewardSubInstance> getReceivedRewards() {
        return new ArrayList<RewardSubInstance>(this.receivedRewards);
    }

    public ArrayList<RewardSubInstance> getRewardsToBeClaimed() {
        return new ArrayList<RewardSubInstance>(this.rewardsToBeClaimed);
    }

    private void userMapping() {
        boolean uuidExists = db.getPlayerDAO().playerExists(this.uuid);
        String existingNickname = uuidExists ? db.getPlayerDAO().getNickname(this.uuid) : null;
        String existingUUID = db.getPlayerDAO().getUUIDFromNickname(this.nickname);
        DBUsersManager dbUsersManager = DBUsersManager.getInstance();
        if (uuidExists) {
            if (!this.nickname.equals(existingNickname)) {
                db.getPlayerDAO().updateNickname(this.uuid, this.nickname);
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> dbUsersManager.updateNicknameInCache(this.uuid, existingNickname, this.nickname));
            }
        } else if (existingUUID != null) {
            db.getPlayerDAO().updateUUID(this.uuid, this.nickname);
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> dbUsersManager.updateUUIDInCache(existingUUID, this.uuid, this.nickname));
        } else {
            db.getPlayerDAO().addNewPlayer(this.uuid, this.nickname, this.fromServerOnJoinPlayTime);
        }
    }

    public long getAFKPlaytime() {
        return this.DBAFKplaytime;
    }

    public long getAFKPlaytimeWithSnapshot(long playtimeSnapshot) {
        return this.getAFKPlaytime();
    }

    public boolean isAFK() {
        return this.afk;
    }

    public void setAFK(boolean afk) {
        this.afk = afk;
    }

    public void resetAsync(Runnable callback) {
        this.DBplaytime = 0L;
        this.DBAFKplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = 0L;
        this.lastSeen = null;
        this.firstJoin = null;
        this.relativeJoinStreak = 0;
        this.absoluteJoinStreak = 0;
        this.completedGoals.clear();
        this.receivedRewards.clear();
        this.rewardsToBeClaimed.clear();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().resetUserInDatabase(this.uuid);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void reset() {
        this.resetAsync(null);
    }

    public void resetPlaytimeAsync(Runnable callback) {
        this.DBplaytime = 0L;
        this.DBAFKplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = 0L;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updatePlaytime(this.uuid, 0L);
            db.getPlayerDAO().updateArtificialPlaytime(this.uuid, 0L);
            db.getPlayerDAO().updateAFKPlaytime(this.uuid, 0L);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetPlaytime() {
        this.resetPlaytimeAsync(null);
    }

    public void resetLastSeenAsync(Runnable callback) {
        this.lastSeen = null;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updateLastSeen(this.uuid, null);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetLastSeen() {
        this.resetLastSeenAsync(null);
    }

    public void resetFirstJoinAsync(Runnable callback) {
        this.firstJoin = null;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getPlayerDAO().updateFirstJoin(this.uuid, null);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetFirstJoin() {
        this.resetFirstJoinAsync(null);
    }

    public void resetJoinStreakRewardsAsync(Runnable callback) {
        this.receivedRewards.clear();
        this.rewardsToBeClaimed.clear();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getStreakDAO().resetAllUserRewards(this.uuid);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetJoinStreakRewards() {
        this.resetJoinStreakRewardsAsync(null);
    }

    public void resetGoalsAsync(Runnable callback) {
        this.completedGoals.clear();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            db.getGoalsDAO().removeAllGoalsFromUser(this.uuid);
            if (callback != null) {
                Bukkit.getScheduler().runTask((Plugin)plugin, callback);
            }
        });
    }

    public void resetGoals() {
        this.resetGoalsAsync(null);
    }
}

