/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.PlayTimeManager;

public class Version351to352Updater {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final GUIsConfiguration guIsConfiguration = GUIsConfiguration.getInstance();
    private final DatabaseHandler database = DatabaseHandler.getInstance();
    private static final Map<String, String> PLACEHOLDER_MAPPINGS = new HashMap<String, String>();

    public void performUpgrade() {
        this.addAFKPlaytimeColumn();
        this.recreateConfigFile();
        this.updatePlaceholders();
    }

    public void addAFKPlaytimeColumn() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN afk_playtime BIGINT NOT NULL DEFAULT 0;");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    public void recreateConfigFile() {
        this.guIsConfiguration.initialize(this.plugin);
        this.guIsConfiguration.updateConfig();
        this.plugin.getConfiguration().updateConfig(true);
    }

    private void updatePlaceholders() {
        try {
            Map<String, Object> backup = this.guIsConfiguration.createConfigBackup();
            for (String key : backup.keySet()) {
                List<Object> updatedList;
                List listValue;
                Object value = backup.get(key);
                if (value instanceof String) {
                    String stringValue = (String)value;
                    String updatedValue = this.updatePlaceholdersInString(stringValue);
                    if (stringValue.equals(updatedValue)) continue;
                    this.guIsConfiguration.set(key, updatedValue);
                    continue;
                }
                if (!(value instanceof List) || (listValue = (List)value).equals(updatedList = this.updatePlaceholdersInList(listValue))) continue;
                this.guIsConfiguration.set(key, updatedList);
            }
            this.plugin.getLogger().info("Successfully updated placeholders to new format");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update placeholders: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String updatePlaceholdersInString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String result = input;
        for (Map.Entry<String, String> mapping : PLACEHOLDER_MAPPINGS.entrySet()) {
            result = result.replace(mapping.getKey(), mapping.getValue());
        }
        return result;
    }

    private List<Object> updatePlaceholdersInList(List<Object> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Object> updatedList = new ArrayList<Object>();
        for (Object item : list) {
            if (item instanceof String) {
                updatedList.add(this.updatePlaceholdersInString((String)item));
                continue;
            }
            updatedList.add(item);
        }
        return updatedList;
    }

    static {
        PLACEHOLDER_MAPPINGS.put("{current_page}", "%CURRENT_PAGE%");
        PLACEHOLDER_MAPPINGS.put("{total_pages}", "%TOTAL_PAGES%");
        PLACEHOLDER_MAPPINGS.put("{required_joins}", "%REQUIRED_JOINS%");
        PLACEHOLDER_MAPPINGS.put("{current_streak}", "%CURRENT_STREAK%");
        PLACEHOLDER_MAPPINGS.put("{count}", "%COUNT%");
        PLACEHOLDER_MAPPINGS.put("{reward_description}", "%REWARD_DESCRIPTION%");
        PLACEHOLDER_MAPPINGS.put("{description}", "%DESCRIPTION%");
        PLACEHOLDER_MAPPINGS.put("{color}", "%JOIN_STREAK_COLOR%");
    }
}

