/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class Version34to341Updater {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();

    public void performUpgrade() {
        this.recreateGoalsConfigFiles();
        this.recreateConfigFile();
        this.updateCommandsConfigFile();
    }

    private void recreateGoalsConfigFiles() {
        File goalsFolder = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "Goals");
        if (!goalsFolder.exists() || !goalsFolder.isDirectory()) {
            this.plugin.getLogger().info("No Goals folder found. Skipping goal configuration update.");
            return;
        }
        File[] goalFiles = goalsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (goalFiles == null || goalFiles.length == 0) {
            this.plugin.getLogger().info("No goal configuration files found. Skipping goal configuration update.");
            return;
        }
        for (File oldGoalFile : goalFiles) {
            try {
                String goalPath = oldGoalFile.getPath();
                String fileName = oldGoalFile.getName();
                YamlConfiguration oldConfig = YamlConfiguration.loadConfiguration((File)oldGoalFile);
                long time = oldConfig.getLong("time", Long.MAX_VALUE);
                String goalMessage = oldConfig.getString("goal-message", this.getDefaultGoalMessage());
                String goalSound = oldConfig.getString("goal-sound", this.getDefaultGoalSound());
                List rewardPermissions = oldConfig.getStringList("permissions");
                List rewardCommands = oldConfig.getStringList("commands");
                boolean active = oldConfig.getBoolean("active", false);
                if (!oldGoalFile.delete()) {
                    this.plugin.getLogger().warning("Could not delete old goal file: " + fileName);
                    continue;
                }
                YamlConfiguration newConfig = new YamlConfiguration();
                newConfig.options().setHeader(Arrays.asList("GUIDE OF AVAILABLE OPTIONS:", "---------------------------", "goal-sound is played to a player if it reaches the time specified in this config.", "A list of available sounds can be found here: https://jd.papermc.io/paper/<VERSION>/org/bukkit/Sound.html", "Replace '<VERSION>' in the link with your current minecraft version. If it doesn't work try with the ", "latest update of your version (e.g. '1.19' doesn't work and you need to use '1.19.4')", "---------------------------", "goal-message is showed to a player if it reaches the time specified in this config.", "Available placeholders: %TIME_REQUIRED%, %PLAYER_NAME%. %GOAL_NAME%", "---------------------------", "active determines whether this goal is enabled and being checked by the plugin", "Set to 'true' to enable the goal and track player progress", "Set to 'false' (default option) to disable the goal without deleting it", "This is useful for:", "* Temporarily disabling goals without removing them", "* Testing new goals before making them live", "* Managing seasonal or event-specific goals", "---------------------------", "requirements:", "  time: Required playtime (in seconds) for the goal to be completed", "  permissions: List of permissions that the player must have to complete this goal", "  placeholders: List of placeholder conditions that must be met to complete this goal", "---------------------------", "reward:", "  permissions: Permissions that will be granted to a player when they reach this goal", "  commands: List of commands that will be executed when a player reaches this goal", "  Available placeholders in commands: PLAYER_NAME"));
                newConfig.set("active", (Object)active);
                newConfig.set("goal-sound", (Object)goalSound);
                newConfig.set("goal-message", (Object)goalMessage);
                newConfig.set("requirements.time", (Object)time);
                newConfig.set("requirements.permissions", new ArrayList());
                newConfig.set("requirements.placeholders", new ArrayList());
                newConfig.set("rewards.permissions", (Object)rewardPermissions);
                newConfig.set("rewards.commands", (Object)rewardCommands);
                File newGoalFile = new File(goalPath);
                newConfig.save(newGoalFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to update goal configuration file " + oldGoalFile.getName() + ": " + e.getMessage());
            }
        }
    }

    private void recreateConfigFile() {
        Configuration.getInstance().updateConfig(true);
    }

    private void updateCommandsConfigFile() {
        File commandsConfigFile = new File(this.plugin.getDataFolder(), "Translations/Commands/commands-config.yml");
        File parentDir = commandsConfigFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create directory structure for commands configuration file");
            return;
        }
        try {
            YamlConfiguration existingConfig = YamlConfiguration.loadConfiguration((File)commandsConfigFile);
            String header = existingConfig.getString("playtimetop.header", "[&6PlayTime&eManager&f]&7 Top 100 players - page: %PAGE_NUMBER%");
            String leaderboardFormat = existingConfig.getString("playtimetop.leaderboard-format", "&7&l#%POSITION%&r &e%PLAYER_NAME% &7- &d%PLAYTIME%");
            String middleText = existingConfig.getString("playtimetop.footer.middle-text", "&7Page %PAGE_NUMBER%/%TOTAL_PAGES%");
            String prevPageExists = existingConfig.getString("playtimetop.footer.previous-page.text-if-page-exists", "&6\u00ab");
            String prevPageNotExists = existingConfig.getString("playtimetop.footer.previous-page.text-if-page-not-exists", "&7\u00ab");
            String prevPageHover = existingConfig.getString("playtimetop.footer.previous-page.over-text", "&7Click to go to previous page");
            String nextPageExists = existingConfig.getString("playtimetop.footer.next-page.text-if-page-exists", "&6\u00bb");
            String nextPageNotExists = existingConfig.getString("playtimetop.footer.next-page.text-if-page-not-exists", "&7\u00bb");
            String nextPageHover = existingConfig.getString("playtimetop.footer.next-page.over-text", "&7Click to go to next page");
            String noPermission = existingConfig.getString("playtimetop.messages.no-permission", "&cYou don't have the permission to execute this command");
            String pageNotExists = existingConfig.getString("playtimetop.messages.page-not-exists", "&cPage %PAGE_NUMBER% doesn't exist!");
            String invalidArgument = existingConfig.getString("playtimetop.messages.invalid-argument", "&cThe argument is not valid! Use p1, p2, etc.");
            String noPlayers = existingConfig.getString("playtimetop.messages.no-players", "&cNo players joined!");
            String invalidPage = existingConfig.getString("playtimetop.messages.invalid-page", "&cInvalid page!");
            String loadingError = existingConfig.getString("playtimetop.messages.loading-error", "&cError while loading top players: %ERROR%");
            if (commandsConfigFile.exists() && !commandsConfigFile.delete()) {
                this.plugin.getLogger().warning("Could not delete old commands configuration file");
                return;
            }
            YamlConfiguration newConfig = new YamlConfiguration();
            newConfig.options().setHeader(Arrays.asList("PlayTimeManager - Commands Configuration", "This file contains all customizable text elements for commands (will be added more in the future)", "", "Hex colors are supported with the following format: &#rrggbb", "where rr (red), gg (green) and bb (blue) are", "hexadecimal values between 00 and ff (same as decimal 0-255)", "Standard minecraft colors and styles are accepted using & format (e.g. \"&5&lTest\").", "", "Placeholders enclosed in {} are FIELD-DEPENDENT. They can only be used within the specific field", "where they're defined. All available placeholders are shown in this configuration file"));
            newConfig.set("playtimetop.header", (Object)header);
            newConfig.set("playtimetop.leaderboard-format", (Object)leaderboardFormat);
            newConfig.set("playtimetop.messages.no-permission", (Object)noPermission);
            newConfig.set("playtimetop.messages.page-not-exists", (Object)pageNotExists);
            newConfig.set("playtimetop.messages.invalid-argument", (Object)invalidArgument);
            newConfig.set("playtimetop.messages.no-players", (Object)noPlayers);
            newConfig.set("playtimetop.messages.invalid-page", (Object)invalidPage);
            newConfig.set("playtimetop.messages.loading-error", (Object)loadingError);
            newConfig.set("playtimetop.footer.middle-text", (Object)middleText);
            newConfig.set("playtimetop.footer.previous-page.text-if-page-exists", (Object)prevPageExists);
            newConfig.set("playtimetop.footer.previous-page.text-if-page-not-exists", (Object)prevPageNotExists);
            newConfig.set("playtimetop.footer.previous-page.over-text", (Object)prevPageHover);
            newConfig.set("playtimetop.footer.next-page.text-if-page-exists", (Object)nextPageExists);
            newConfig.set("playtimetop.footer.next-page.text-if-page-not-exists", (Object)nextPageNotExists);
            newConfig.set("playtimetop.footer.next-page.over-text", (Object)nextPageHover);
            newConfig.save(commandsConfigFile);
            this.plugin.getLogger().info("Successfully updated commands configuration file with new message fields");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to update commands configuration file: " + e.getMessage());
        }
    }

    private String getDefaultGoalSound() {
        return "ENTITY_PLAYER_LEVELUP";
    }

    private String getDefaultGoalMessage() {
        return "[&6PlayTime&eManager&f]&7 Congratulations &e%PLAYER_NAME%&7 you have reached &6%TIME_REQUIRED%&7 of playtime!";
    }
}

