/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.util.ArrayList;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardExecutor;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardMessageService;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardRegistry;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.StreakTracker;
import me.thegabro.playtimemanager.JoinStreaks.Models.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import org.bukkit.entity.Player;

public class RewardProcessor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final RewardRegistry rewardRegistry;
    private final StreakTracker streakTracker;
    private final RewardExecutor rewardExecutor;
    private final RewardMessageService messageService;

    public RewardProcessor(RewardRegistry rewardRegistry, StreakTracker streakTracker, RewardExecutor rewardExecutor, RewardMessageService messageService) {
        this.rewardRegistry = rewardRegistry;
        this.streakTracker = streakTracker;
        this.rewardExecutor = rewardExecutor;
        this.messageService = messageService;
    }

    public void processEligibleRewards(OnlineUser onlineUser) {
        int currentStreak = onlineUser.getRelativeJoinStreak();
        ArrayList<RewardSubInstance> unclaimedRewards = this.rewardRegistry.getRewardIdsForJoinCount(currentStreak, onlineUser);
        for (RewardSubInstance subInstance : unclaimedRewards) {
            JoinStreakReward mainInstance = this.rewardRegistry.getReward(subInstance.mainInstanceID());
            if (onlineUser.isExpired(subInstance)) {
                this.messageService.sendRewardRelatedMessage(onlineUser, subInstance, this.plugin.getConfiguration().getString("join-unclaimed-previous-message"), 0);
                continue;
            }
            if (mainInstance == null) continue;
            this.processQualifiedReward(onlineUser, subInstance);
        }
        JoinStreakReward lastReward = this.rewardRegistry.getLastRewardByJoins();
        if (lastReward != null && onlineUser.getRelativeJoinStreak() >= lastReward.getMaxRequiredJoins()) {
            this.streakTracker.restartUserJoinStreakRewards(onlineUser);
        }
    }

    private void processQualifiedReward(OnlineUser onlineUser, RewardSubInstance subInstance) {
        Player player = onlineUser.getPlayerInstance();
        if (player.hasPermission("playtime.joinstreak.claim.automatic")) {
            this.messageService.sendRewardRelatedMessage(onlineUser, subInstance, this.plugin.getConfiguration().getString("join-warn-autoclaim-message"), 1);
            this.rewardExecutor.processCompletedReward(player, subInstance);
        } else {
            if (!onlineUser.getRewardsToBeClaimed().contains(subInstance)) {
                onlineUser.addRewardToBeClaimed(subInstance);
            }
            this.messageService.sendRewardRelatedMessage(onlineUser, subInstance, this.plugin.getConfiguration().getString("join-warn-claim-message"), 1);
        }
    }
}

