/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.PlaceHolders.PlaceholderConditionEvaluator;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class GoalRewardRequirement {
    private List<String> permissions;
    private List<String> placeholderConditions;
    private long time;
    private final PlaceholderConditionEvaluator placeholderConditionEvaluator = PlaceholderConditionEvaluator.getInstance();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private LuckPermsManager luckPermsManager = null;

    public GoalRewardRequirement() {
        this.permissions = new ArrayList<String>();
        this.placeholderConditions = new ArrayList<String>();
        this.time = Long.MAX_VALUE;
        if (this.plugin.isPermissionsManagerConfigured()) {
            this.luckPermsManager = LuckPermsManager.getInstance(this.plugin);
        }
    }

    public boolean checkRequirements(Player player, long playerTime) {
        if (this.time != Long.MAX_VALUE && playerTime < this.time) {
            return false;
        }
        for (String permission : this.permissions) {
            if (player.hasPermission(permission)) continue;
            return false;
        }
        for (String condition : this.placeholderConditions) {
            if (this.placeholderConditionEvaluator.evaluate(player, condition)) continue;
            return false;
        }
        return true;
    }

    public CompletableFuture<Boolean> checkRequirementsOffline(OfflinePlayer player, long playerTime) {
        CompletionStage<Boolean> permissionChecks;
        UUID uuid = player.getUniqueId();
        if (this.time != Long.MAX_VALUE && playerTime < this.time) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.plugin.isPermissionsManagerConfigured()) {
            permissionChecks = CompletableFuture.completedFuture(true);
            for (String permission : this.permissions) {
                permissionChecks = permissionChecks.thenComposeAsync(prev -> {
                    if (!prev.booleanValue()) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return this.luckPermsManager.hasPermissionAsync(uuid.toString(), permission);
                });
            }
        } else {
            permissionChecks = CompletableFuture.completedFuture(true);
        }
        return ((CompletableFuture)permissionChecks.thenApplyAsync(hasAllPerms -> {
            if (!hasAllPerms.booleanValue()) {
                return false;
            }
            for (String condition : this.placeholderConditions) {
                if (this.placeholderConditionEvaluator.evaluate(player, condition)) continue;
                return false;
            }
            return true;
        })).exceptionally(ex -> {
            this.plugin.getLogger().warning("Failed to check offline requirements for " + player.getName() + ": " + ex.getMessage());
            return false;
        });
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    public void removePermission(String permission) {
        this.permissions.remove(permission);
    }

    public List<String> getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    public void setPlaceholderConditions(List<String> placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }

    public void addPlaceholderCondition(String condition) {
        this.placeholderConditions.add(condition);
    }

    public void removePlaceholderCondition(String condition) {
        this.placeholderConditions.remove(condition);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }
}

