/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.Player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.GUIs.BaseCustomGUI;
import me.thegabro.playtimemanager.GUIs.InventoryListener;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.JoinStreaks.Models.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RewardsInfoGui
extends BaseCustomGUI {
    private final Inventory inv;
    private final ArrayList<Integer> protectedSlots = new ArrayList();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final JoinStreaksManager rewardsManager = JoinStreaksManager.getInstance();
    private final GUIsConfiguration config;
    private final boolean isOwner;
    private final DBUser subject;
    private int currentPage = 0;
    private final List<RewardDisplayItem> allDisplayItems = new ArrayList<RewardDisplayItem>();
    private final List<RewardDisplayItem> filteredDisplayItems = new ArrayList<RewardDisplayItem>();
    private final int REWARDS_PER_PAGE = 28;
    private final int NEXT_BUTTON_SLOT = 50;
    private final int PREV_BUTTON_SLOT = 48;
    private final int PAGE_INDICATOR_SLOT = 49;
    private final int SHOW_CLAIMED_BUTTON_SLOT = 3;
    private final int SHOW_AVAILABLE_BUTTON_SLOT = 4;
    private final int SHOW_LOCKED_BUTTON_SLOT = 5;
    private final int CLAIM_ALL_BUTTON_SLOT = 46;
    private final Map<String, String> globalPlaceholders = new HashMap<String, String>();
    private FilterType currentFilter = FilterType.AVAILABLE;

    public RewardsInfoGui(Player sender, DBUser subject, String sessionToken) {
        super(sender, sessionToken);
        this.config = GUIsConfiguration.getInstance();
        this.subject = subject;
        this.isOwner = sender.getName().equalsIgnoreCase(subject.getNickname());
        this.inv = this.isOwner ? Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors(this.config.getString("rewards-gui.gui.title"))) : Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors(subject.getNickname() + "'s rewards"));
    }

    @Override
    public void openInventory() {
        this.currentPage = 0;
        this.initializeGlobalPlaceholders();
        this.loadRewards();
        this.applyFilters();
        this.initializeItems();
        InventoryListener.getInstance().registerGUI(this.sender.getUniqueId(), this);
        this.sender.openInventory(this.inv);
    }

    public void changePage(int page) {
        this.currentPage = page;
        this.initializeItems();
        this.sender.updateInventory();
    }

    private void applyFilters() {
        this.filteredDisplayItems.clear();
        for (RewardDisplayItem item : this.allDisplayItems) {
            switch (item.getStatus().ordinal()) {
                case 3: {
                    if (this.currentFilter != FilterType.CLAIMED) break;
                    this.filteredDisplayItems.add(item);
                    break;
                }
                case 0: 
                case 1: {
                    if (this.currentFilter != FilterType.AVAILABLE) break;
                    this.filteredDisplayItems.add(item);
                    break;
                }
                case 2: {
                    if (this.currentFilter != FilterType.LOCKED) break;
                    this.filteredDisplayItems.add(item);
                }
            }
        }
    }

    private void loadRewards() {
        RewardStatus status;
        JoinStreakReward reward;
        Integer rewardId;
        this.allDisplayItems.clear();
        ArrayList<RewardSubInstance> joinRewardsMap = this.rewardsManager.getRewardRegistry().getJoinRewardsMap();
        ArrayList<RewardSubInstance> rewardsReceived = this.subject.getReceivedRewards();
        ArrayList<RewardSubInstance> rewardsToBeClaimed = this.subject.getRewardsToBeClaimed();
        for (RewardSubInstance subInstance : joinRewardsMap) {
            rewardId = subInstance.mainInstanceID();
            reward = this.rewardsManager.getRewardRegistry().getReward(rewardId);
            if (reward == null) continue;
            status = rewardsReceived.contains(subInstance) ? RewardStatus.CLAIMED : (rewardsToBeClaimed.contains(subInstance) ? RewardStatus.AVAILABLE : RewardStatus.LOCKED);
            this.allDisplayItems.add(new RewardDisplayItem(reward, subInstance, status));
        }
        for (RewardSubInstance subInstance : this.subject.getRewardsToBeClaimed()) {
            if (!subInstance.expired().booleanValue()) continue;
            rewardId = subInstance.mainInstanceID();
            reward = this.rewardsManager.getRewardRegistry().getReward(rewardId);
            if (reward == null) continue;
            status = RewardStatus.AVAILABLE_OLD;
            this.allDisplayItems.add(new RewardDisplayItem(reward, subInstance, status));
        }
        Collections.sort(this.allDisplayItems);
    }

    public void initializeItems() {
        int totalPages;
        int leftIndex = 9;
        int rightIndex = 17;
        this.protectedSlots.clear();
        this.inv.clear();
        this.updateDynamicPlaceholders();
        for (int i = 0; i < 54; ++i) {
            if (i > 9 && i < 45 && i != leftIndex && i != rightIndex) continue;
            this.inv.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Utils.parseColors(this.config.getString("rewards-gui.gui.border-item-name")), new Component[0]));
            this.protectedSlots.add(i);
            if (i == leftIndex) {
                leftIndex += 9;
            }
            if (i != rightIndex) continue;
            rightIndex += 9;
        }
        this.createFilterButtons();
        if (this.isOwner) {
            this.inv.setItem(46, this.createGuiItem(Material.CHEST, Utils.parseColors(this.config.getString("rewards-gui.claim-all.name")), new Component[0]));
            this.protectedSlots.add(46);
        }
        if ((totalPages = (int)Math.ceil((double)this.filteredDisplayItems.size() / 28.0)) > 1) {
            this.inv.setItem(49, this.createGuiItem(Material.PAPER, Utils.parseColors(this.translateDynamic(this.config.getString("rewards-gui.pagination.page-indicator"))), new Component[0]));
            this.protectedSlots.add(49);
            if (this.currentPage < totalPages - 1) {
                this.inv.setItem(50, this.createGuiItem(Material.ARROW, Utils.parseColors(this.config.getString("rewards-gui.pagination.next-page.name")), Utils.parseColors(this.config.getString("rewards-gui.pagination.next-page.lore"))));
            } else {
                this.inv.setItem(50, this.createGuiItem(Material.BARRIER, Utils.parseColors(this.config.getString("rewards-gui.pagination.no-more-pages")), new Component[0]));
            }
            this.protectedSlots.add(50);
            if (this.currentPage > 0) {
                this.inv.setItem(48, this.createGuiItem(Material.ARROW, Utils.parseColors(this.config.getString("rewards-gui.pagination.prev-page.name")), Utils.parseColors(this.config.getString("rewards-gui.pagination.prev-page.lore"))));
            } else {
                this.inv.setItem(48, this.createGuiItem(Material.BARRIER, Utils.parseColors(this.config.getString("rewards-gui.pagination.first-page")), new Component[0]));
            }
            this.protectedSlots.add(48);
        }
        if (!this.filteredDisplayItems.isEmpty()) {
            int startIndex = this.currentPage * 28;
            int endIndex = Math.min(startIndex + 28, this.filteredDisplayItems.size());
            List<RewardDisplayItem> currentPageRewards = this.filteredDisplayItems.subList(startIndex, endIndex);
            int slot = 10;
            for (RewardDisplayItem displayItem : currentPageRewards) {
                while (this.protectedSlots.contains(slot)) {
                    ++slot;
                }
                if (slot < 45) {
                    String translatedLine;
                    String filled;
                    int n;
                    String statusPrefix;
                    JoinStreakReward reward = displayItem.getReward();
                    int specificJoins = displayItem.getSubInstance().requiredJoins();
                    int currentStreak = this.subject.getRelativeJoinStreak();
                    Material material = Material.valueOf((String)reward.getItemIcon());
                    ArrayList<String> lore = new ArrayList<String>();
                    String rewardType = switch (displayItem.getStatus().ordinal()) {
                        case 0, 1 -> {
                            statusPrefix = this.translateDynamic(this.config.getString("rewards-gui.reward-items.available.prefix"));
                            lore.addAll(this.translateDynamic(this.config.getStringList("rewards-gui.reward-items.available.lore")));
                            yield "CLAIMABLE";
                        }
                        case 3 -> {
                            statusPrefix = this.translateDynamic(this.config.getString("rewards-gui.reward-items.claimed.prefix"));
                            lore.addAll(this.translateDynamic(this.config.getStringList("rewards-gui.reward-items.claimed.lore")));
                            yield "CLAIMED";
                        }
                        default -> {
                            statusPrefix = this.translateDynamic(this.config.getString("rewards-gui.reward-items.locked.prefix"));
                            lore.addAll(this.translateDynamic(this.config.getStringList("rewards-gui.reward-items.locked.lore")));
                            yield "LOCKED";
                        }
                    };
                    String requiredJoins = specificJoins == -1 ? "-" : String.valueOf(specificJoins);
                    this.globalPlaceholders.put("%REQUIRED_JOINS%", requiredJoins);
                    String requiredJoinsText = this.translateDynamic(this.config.getString("rewards-gui.reward-items.info-lore.required-joins"));
                    lore.add(requiredJoinsText);
                    if (displayItem.getStatus() != RewardStatus.AVAILABLE_OLD && displayItem.getStatus() != RewardStatus.AVAILABLE) {
                        String streakColor = currentStreak < specificJoins ? this.config.getString("rewards-gui.reward-items.info-lore.join-streak-color.insufficient") : this.config.getString("rewards-gui.reward-items.info-lore.join-streak-color.sufficient");
                        String string3 = this.translateDynamic(this.config.getString("rewards-gui.reward-items.info-lore.join-streak"));
                        string3 = this.quickTranslate(string3, "%JOIN_STREAK_COLOR%", streakColor);
                        string3 = this.quickTranslate(string3, "%COLOR%", streakColor);
                        lore.add(string3);
                    }
                    if (!reward.getDescription().isEmpty()) {
                        lore.add(this.translateDynamic(this.config.getString("rewards-gui.reward-items.info-lore.description-separator")));
                        String descTemplate = this.config.getString("rewards-gui.reward-items.info-lore.description");
                        String[] stringArray = reward.getDescription().split("/n");
                        int n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            String string = stringArray[n];
                            filled = this.quickTranslate(descTemplate, "%DESCRIPTION%", string);
                            translatedLine = this.translateDynamic(filled);
                            lore.add(translatedLine);
                        }
                    }
                    if (!reward.getRewardDescription().isEmpty()) {
                        lore.add(this.translateDynamic(this.config.getString("rewards-gui.reward-items.info-lore.reward-description-separator")));
                        String rewardDescTemplate = this.config.getString("rewards-gui.reward-items.info-lore.reward-description");
                        String[] stringArray = reward.getRewardDescription().split("/n");
                        int n3 = stringArray.length;
                        for (n = 0; n < n3; ++n) {
                            String string = stringArray[n];
                            filled = this.quickTranslate(rewardDescTemplate, "%REWARD_DESCRIPTION%", string);
                            translatedLine = this.translateDynamic(filled);
                            lore.add(translatedLine);
                        }
                    }
                    ArrayList<Component> componentLore = new ArrayList<Component>();
                    for (String string : lore) {
                        componentLore.add(Utils.parseColors(string));
                    }
                    ItemStack itemStack = new ItemStack(material);
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    itemMeta.displayName(Utils.parseColors(statusPrefix).decoration(TextDecoration.ITALIC, false));
                    ArrayList<Component> metalore = new ArrayList<Component>();
                    for (Component loreLine : componentLore) {
                        metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
                    }
                    itemMeta.lore(metalore);
                    NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, "reward_id");
                    NamespacedKey typeKey = new NamespacedKey((Plugin)this.plugin, "reward_type");
                    itemMeta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.STRING, (Object)(displayItem.reward.getId() + "." + displayItem.getSubInstance().requiredJoins()));
                    itemMeta.getPersistentDataContainer().set(typeKey, PersistentDataType.STRING, (Object)rewardType);
                    itemStack.setItemMeta(itemMeta);
                    this.inv.setItem(slot, itemStack);
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            this.inv.setItem(22, this.createGuiItem(Material.BARRIER, Utils.parseColors(this.config.getString("rewards-gui.no-rewards.name")), Utils.parseColors(this.config.getString("rewards-gui.no-rewards.lore"))));
        }
    }

    private void createFilterButtons() {
        Material claimedMaterial = this.currentFilter == FilterType.CLAIMED ? Material.LIME_DYE : Material.GRAY_DYE;
        String claimedName = this.currentFilter == FilterType.CLAIMED ? this.config.getString("rewards-gui.filters.claimed.enabled-name") : this.config.getString("rewards-gui.filters.claimed.disabled-name");
        String claimedLore = this.currentFilter == FilterType.CLAIMED ? this.config.getString("rewards-gui.filters.claimed.lore-enabled") : this.config.getString("rewards-gui.filters.claimed.lore-disabled");
        this.inv.setItem(3, this.createGuiItem(claimedMaterial, Utils.parseColors(claimedName), Utils.parseColors(claimedLore)));
        this.protectedSlots.add(3);
        Material availableMaterial = this.currentFilter == FilterType.AVAILABLE ? Material.LIME_DYE : Material.GRAY_DYE;
        String availableName = this.currentFilter == FilterType.AVAILABLE ? this.config.getString("rewards-gui.filters.available.enabled-name") : this.config.getString("rewards-gui.filters.available.disabled-name");
        String availableLore = this.currentFilter == FilterType.AVAILABLE ? this.config.getString("rewards-gui.filters.available.lore-enabled") : this.config.getString("rewards-gui.filters.available.lore-disabled");
        this.inv.setItem(4, this.createGuiItem(availableMaterial, Utils.parseColors(availableName), Utils.parseColors(availableLore)));
        this.protectedSlots.add(4);
        Material lockedMaterial = this.currentFilter == FilterType.LOCKED ? Material.LIME_DYE : Material.GRAY_DYE;
        String lockedName = this.currentFilter == FilterType.LOCKED ? this.config.getString("rewards-gui.filters.locked.enabled-name") : this.config.getString("rewards-gui.filters.locked.disabled-name");
        String lockedLore = this.currentFilter == FilterType.LOCKED ? this.config.getString("rewards-gui.filters.locked.lore-enabled") : this.config.getString("rewards-gui.filters.locked.lore-disabled");
        this.inv.setItem(5, this.createGuiItem(lockedMaterial, Utils.parseColors(lockedName), Utils.parseColors(lockedLore)));
        this.protectedSlots.add(5);
    }

    private ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    @Override
    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, @NotNull InventoryAction action, @NotNull InventoryClickEvent event) {
        NamespacedKey typeKey;
        PersistentDataContainer container;
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        if (slot == 3) {
            this.currentFilter = FilterType.CLAIMED;
            this.currentPage = 0;
            this.applyFilters();
            this.initializeItems();
            return;
        }
        if (slot == 4) {
            this.currentFilter = FilterType.AVAILABLE;
            this.currentPage = 0;
            this.applyFilters();
            this.initializeItems();
            return;
        }
        if (slot == 5) {
            this.currentFilter = FilterType.LOCKED;
            this.currentPage = 0;
            this.applyFilters();
            this.initializeItems();
            return;
        }
        if (slot == 46 && this.isOwner) {
            this.claimAllRewards();
            return;
        }
        if (slot == 50 && clickedItem.getType() == Material.ARROW) {
            this.changePage(this.currentPage + 1);
            return;
        }
        if (slot == 48 && clickedItem.getType() == Material.ARROW) {
            this.changePage(this.currentPage - 1);
            return;
        }
        if (clickedItem.getItemMeta().hasDisplayName() && this.isOwner && (container = clickedItem.getItemMeta().getPersistentDataContainer()).has(typeKey = new NamespacedKey((Plugin)this.plugin, "reward_type"), PersistentDataType.STRING) && ((String)container.get(typeKey, PersistentDataType.STRING)).equals("CLAIMABLE")) {
            NamespacedKey idKey = new NamespacedKey((Plugin)this.plugin, "reward_id");
            if (container.has(idKey, PersistentDataType.STRING)) {
                String instance = (String)container.get(idKey, PersistentDataType.STRING);
                this.claimReward(instance);
            } else {
                whoClicked.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + this.config.getString("rewards-gui.messages.not-available")));
                whoClicked.playSound(whoClicked.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            }
        }
    }

    private void claimReward(String instance) {
        String[] parts = instance.split("\\.");
        if (!this.validateSession()) {
            this.handleInvalidSession();
            return;
        }
        if (parts.length != 2) {
            System.err.println("Invalid instance format: " + instance);
            return;
        }
        try {
            int rewardId = Integer.parseInt(parts[0]);
            int specificJoinCount = Integer.parseInt(parts[1]);
            if (!this.sender.hasPermission("playtime.joinstreak.claim")) {
                this.sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + this.config.getString("rewards-gui.messages.no-permission")));
                this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            JoinStreakReward reward = this.rewardsManager.getRewardRegistry().getReward(rewardId);
            if (reward == null) {
                this.sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + this.config.getString("rewards-gui.messages.reward-not-found")));
                this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            try {
                this.rewardsManager.getRewardExecutor().processCompletedReward(this.sender, JoinStreaksManager.getInstance().getRewardRegistry().getSubInstance(rewardId, specificJoinCount));
                this.loadRewards();
                this.applyFilters();
                this.initializeItems();
                this.sender.updateInventory();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing reward for player " + this.sender.getName() + ": " + e.getMessage());
                e.printStackTrace();
                this.sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + this.config.getString("rewards-gui.messages.error-processing")));
                this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Failed to parse numbers from instance: " + instance);
            e.printStackTrace();
        }
    }

    private void claimAllRewards() {
        if (!this.plugin.getSessionManager().validateSession(this.sender.getUniqueId(), this.sessionToken)) {
            this.plugin.getLogger().warning("Player " + this.sender.getName() + " attempted GUI action with invalid session token!");
            this.sender.closeInventory();
            return;
        }
        if (!this.sender.hasPermission("playtime.joinstreak.claim")) {
            this.sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + this.config.getString("rewards-gui.messages.no-permission")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        ArrayList<RewardSubInstance> claimableRewards = this.subject.getRewardsToBeClaimed();
        if (claimableRewards.isEmpty()) {
            return;
        }
        int claimedCount = 0;
        for (RewardSubInstance subInstance : claimableRewards) {
            this.rewardsManager.getRewardExecutor().processCompletedReward(this.sender, subInstance);
            ++claimedCount;
        }
        if (claimedCount > 0) {
            String message = this.quickTranslate(this.config.getString("rewards-gui.messages.claimed-rewards"), "%COUNT%", String.valueOf(claimedCount));
            this.sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + message));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            this.loadRewards();
            this.applyFilters();
            this.initializeItems();
        } else {
            this.sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + this.config.getString("rewards-gui.messages.error-processing")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
    }

    private void initializeGlobalPlaceholders() {
        this.globalPlaceholders.clear();
        this.globalPlaceholders.put("%PLAYER_NAME%", this.subject.getNickname());
        this.globalPlaceholders.put("%CURRENT_STREAK%", String.valueOf(this.subject.getRelativeJoinStreak()));
        this.globalPlaceholders.put("%ABSOLUTE_STREAK%", String.valueOf(this.subject.getAbsoluteJoinStreak()));
    }

    private void updateDynamicPlaceholders() {
        int totalPages = (int)Math.ceil((double)this.filteredDisplayItems.size() / 28.0);
        this.globalPlaceholders.put("%CURRENT_PAGE%", String.valueOf(this.currentPage + 1));
        this.globalPlaceholders.put("%TOTAL_PAGES%", String.valueOf(totalPages));
    }

    private String translateDynamic(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : this.globalPlaceholders.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private List<String> translateDynamic(List<String> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list) {
            result.add(this.translateDynamic(s));
        }
        return result;
    }

    private String quickTranslate(String text, String placeholder, String value) {
        return text != null ? text.replace(placeholder, value) : text;
    }

    private static enum FilterType {
        CLAIMED,
        AVAILABLE,
        LOCKED;

    }

    public static class RewardDisplayItem
    implements Comparable<RewardDisplayItem> {
        private final JoinStreakReward reward;
        private final RewardStatus status;
        private final RewardSubInstance subInstance;

        public RewardDisplayItem(JoinStreakReward reward, RewardSubInstance subInstance, RewardStatus status) {
            this.reward = reward;
            this.status = status;
            this.subInstance = subInstance;
        }

        public JoinStreakReward getReward() {
            return this.reward;
        }

        public RewardStatus getStatus() {
            return this.status;
        }

        public RewardSubInstance getSubInstance() {
            return this.subInstance;
        }

        @Override
        public int compareTo(RewardDisplayItem other) {
            if (this.status != other.status) {
                return this.status.ordinal() - other.status.ordinal();
            }
            if (this.subInstance.requiredJoins() != other.subInstance.requiredJoins() && this.subInstance.requiredJoins() != -1 && other.subInstance.requiredJoins() != -1) {
                return Integer.compare(this.subInstance.requiredJoins(), other.subInstance.requiredJoins());
            }
            if (this.reward.getId() != other.reward.getId()) {
                return Integer.compare(this.reward.getId(), other.reward.getId());
            }
            return Integer.compare(this.subInstance.requiredJoins(), other.subInstance.requiredJoins());
        }
    }

    private static enum RewardStatus {
        AVAILABLE_OLD,
        AVAILABLE,
        LOCKED,
        CLAIMED;

    }
}

