/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.GUIs.Goals.AllGoalsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PlaytimeGoal
implements TabExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final String[] SUBCOMMANDS = new String[]{"create", "remove", "rename", "checknow"};
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("playtime.goal")) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + this.config.getString("no-permission")));
            return false;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Only players can use the GUI!"));
                return false;
            }
            AllGoalsGui gui = new AllGoalsGui();
            gui.openInventory((Player)sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                if (args.length < 2) {
                    sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Usage: /playtimegoal create <goalName>"));
                    return false;
                }
                String goalName = args[1];
                this.createGoal(sender, goalName);
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Usage: /playtimegoal remove <goalName>"));
                    return false;
                }
                String goalName = args[1];
                this.removeGoal(sender, goalName);
                break;
            }
            case "rename": {
                if (args.length != 3) {
                    sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Usage: /playtimegoal rename <oldName> <newName>"));
                    return false;
                }
                String oldName = args[1];
                String newName = args[2];
                this.renameGoal(sender, oldName, newName);
                break;
            }
            case "checknow": {
                if (args.length < 2) {
                    sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Usage: /playtimegoal checknow <goalname>"));
                    return false;
                }
                String goalName = args[1];
                this.checkNow(sender, goalName);
                break;
            }
            default: {
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Subcommand " + subCommand + " is not valid."));
                return false;
            }
        }
        return true;
    }

    private void createGoal(CommandSender sender, String goalName) {
        if (this.goalsManager.getGoal(goalName) != null) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " A goal with the name &e" + goalName + " &7already exists!"));
            return;
        }
        if (goalName.trim().isEmpty()) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Goal name cannot be empty!"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            new Goal(this.plugin, goalName, false);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Goal &e" + goalName + " has been created &asuccessfully &7(inactive by default). &7To edit this goal, use the GUI or manually modify the &e" + goalName + ".yml &7file.")));
        });
    }

    private void renameGoal(CommandSender sender, String oldName, String newName) {
        Goal oldGoal = this.goalsManager.getGoal(oldName);
        if (oldGoal == null) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The goal &e" + oldName + " &7doesn't exist!"));
            return;
        }
        if (this.goalsManager.getGoal(newName) != null) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " A goal with the name &e" + newName + " &7already exists!"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            oldGoal.rename(newName);
            for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
                user.reloadGoalsSync();
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Successfully renamed goal &e" + oldName + " &7to &e" + newName)));
        });
    }

    private void removeGoal(CommandSender sender, String goalName) {
        Goal goal = this.goalsManager.getGoal(goalName);
        if (goal == null) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The goal &e" + goalName + " &7doesn't exist!"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            goal.kill(false);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The goal &e" + goalName + " &7has been removed!")));
        });
    }

    private void checkNow(CommandSender sender, String goalName) {
        Goal goal = this.goalsManager.getGoal(goalName);
        if (goal == null) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The goal &e" + goalName + " &7doesn't exist!"));
            return;
        }
        goal.cancelCheckTask();
        if (!goal.areOfflineRewardsEnabled()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                OnlineUser onlineUser = this.onlineUsersManager.getOnlineUser(player.getName());
                if (onlineUser == null) continue;
                goal.checkCompletion(onlineUser);
            }
            if (goal.isVerbose()) {
                Map<String, Object> scheduleInfo = goal.getNextSchedule();
                this.plugin.getLogger().info(String.format("Goal %s check completed, next check will occur in %s on %s", goal.getName(), scheduleInfo.get("timeRemaining"), scheduleInfo.get("nextCheck")));
            }
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                OnlineUser onlineUser = this.onlineUsersManager.getOnlineUser(player.getName());
                if (onlineUser == null) continue;
                goal.checkCompletion(onlineUser);
            }
            goal.loadPlayersJoinedDuringTimeWindow(users -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (DBUser user : users) {
                    goal.checkCompletion(user);
                }
                if (goal.isVerbose()) {
                    Map<String, Object> scheduleInfo = goal.getNextSchedule();
                    this.plugin.getLogger().info(String.format("Goal %s check completed for %d players, next check in %s on %s", goal.getName(), users.size(), scheduleInfo.get("timeRemaining"), scheduleInfo.get("nextCheck")));
                }
            }));
        }
        goal.restartCompletionCheckTask();
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], Arrays.asList(this.SUBCOMMANDS), completions);
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("rename") || args[0].equalsIgnoreCase("checknow")) {
                StringUtil.copyPartialMatches((String)args[1], this.goalsManager.getGoalsNames(), completions);
            }
            return completions;
        }
        return null;
    }
}

