/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class OnlineUsersManager {
    private static volatile OnlineUsersManager instance;
    private BukkitTask goalSchedule;
    private BukkitTask dbUpdateSchedule;
    private final PlayTimeManager plugin;
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final Map<String, OnlineUser> onlineUsersByName;
    private final Map<String, OnlineUser> onlineUsersByUUID;
    private final Map<String, String> goalMessageReplacements;
    private static final int DB_UPDATE_INTERVAL = 6000;

    private OnlineUsersManager() {
        this.plugin = PlayTimeManager.getInstance();
        this.onlineUsersByName = new ConcurrentHashMap<String, OnlineUser>();
        this.onlineUsersByUUID = new ConcurrentHashMap<String, OnlineUser>();
        this.goalMessageReplacements = new HashMap<String, String>();
        this.loadOnlineUsers();
    }

    public void initialize() {
        this.startGoalCheckSchedule();
        this.startDBUpdateSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnlineUsersManager getInstance() {
        if (instance != null) return instance;
        Class<OnlineUsersManager> clazz = OnlineUsersManager.class;
        synchronized (OnlineUsersManager.class) {
            if (instance != null) return instance;
            instance = new OnlineUsersManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, OnlineUser> getOnlineUsersByUUID() {
        return this.onlineUsersByUUID;
    }

    public void addOnlineUser(OnlineUser onlineUser) {
        this.onlineUsersByName.put(onlineUser.getNickname().toLowerCase(), onlineUser);
        this.onlineUsersByUUID.put(onlineUser.getUuid(), onlineUser);
    }

    public void removeOnlineUser(OnlineUser onlineUser) {
        this.onlineUsersByName.remove(onlineUser.getNickname().toLowerCase());
        this.onlineUsersByUUID.remove(onlineUser.getUuid());
    }

    public void loadOnlineUsers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            OnlineUser onlineUser = new OnlineUser((Player)player);
            this.addOnlineUser(onlineUser);
        });
    }

    public OnlineUser getOnlineUser(String nickname) {
        return this.onlineUsersByName.get(nickname.toLowerCase());
    }

    public OnlineUser getOnlineUserByUUID(String uuid) {
        return this.onlineUsersByUUID.get(uuid);
    }

    public void startGoalCheckSchedule() {
        Set<Goal> goals;
        if (this.goalSchedule != null) {
            this.goalSchedule.cancel();
        }
        if ((goals = this.goalsManager.getGoals()).isEmpty() || this.goalsManager.areAllInactive()) {
            this.plugin.getLogger().info("No active goals found. Goal check schedule not started.");
            return;
        }
        this.goalSchedule = new BukkitRunnable(this){
            final /* synthetic */ OnlineUsersManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.checkGoalsForAllUsers(goals);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)(this.plugin.getConfiguration().getInt("goal-check-rate") * 20));
    }

    private void checkGoalsForAllUsers(Set<Goal> goals) {
        if (this.plugin.getConfiguration().getBoolean("goal-check-verbose").booleanValue()) {
            this.logVerboseInfo();
        }
        this.onlineUsersByName.values().forEach(onlineUser -> {
            Player player = Bukkit.getPlayerExact((String)onlineUser.getNickname());
            if (player != null) {
                this.checkGoalsForUser((OnlineUser)onlineUser, player, goals);
            }
        });
    }

    private void checkGoalsForUser(OnlineUser onlineUser, Player player, Set<Goal> goals) {
        goals.stream().filter(Goal::isActive).filter(goal -> !onlineUser.hasCompletedGoal(goal.getName())).filter(goal -> goal.getRequirements().checkRequirements(player, onlineUser.getPlaytime())).forEach(goal -> this.processCompletedGoal(onlineUser, player, (Goal)goal));
    }

    private void processCompletedGoal(OnlineUser onlineUser, Player player, Goal goal) {
        onlineUser.markGoalAsCompleted(goal.getName());
        if (this.plugin.isPermissionsManagerConfigured()) {
            this.assignPermissionsForGoal(onlineUser, goal);
        }
        this.executeCommands(goal, player);
        this.sendGoalMessage(player, goal);
        if (this.plugin.getConfiguration().getBoolean("goal-check-verbose").booleanValue()) {
            this.plugin.getLogger().info(String.format("User %s has reached the goal %s which requires %s!", onlineUser.getNickname(), goal.getName(), Utils.ticksToFormattedPlaytime(goal.getRequirements().getTime())));
        }
        this.playGoalSound(player, goal);
    }

    private void startDBUpdateSchedule() {
        if (this.dbUpdateSchedule != null) {
            this.dbUpdateSchedule.cancel();
        }
        this.dbUpdateSchedule = new BukkitRunnable(){

            public void run() {
                OnlineUsersManager.this.updateAllOnlineUsersPlaytime();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 6000L);
    }

    public CompletableFuture<Void> updateAllOnlineUsersPlaytime() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.onlineUsersByName.values().forEach(user -> {
                    try {
                        user.updatePlayTime();
                        user.updateAFKPlayTime();
                        user.updateLastSeen();
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe(String.format("Failed to update playtime for user %s: %s", user.getNickname(), e.getMessage()));
                    }
                });
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void assignPermissionsForGoal(OnlineUser onlineUser, Goal goal) {
        ArrayList<String> permissions = goal.getRewardPermissions();
        if (permissions != null && !permissions.isEmpty()) {
            try {
                LuckPermsManager.getInstance(this.plugin).assignGoalPermissions(onlineUser.getUuid(), goal);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Failed to assign permissions for goal %s to player %s: %s", goal.getName(), onlineUser.getNickname(), e.getMessage()));
            }
        }
    }

    private void executeCommands(Goal goal, Player player) {
        ArrayList<String> commands = goal.getRewardCommands();
        if (commands != null && !commands.isEmpty()) {
            commands.forEach(command -> {
                try {
                    String formattedCommand = this.formatCommand((String)command, player);
                    if (this.plugin.getConfiguration().getBoolean("goal-check-verbose").booleanValue()) {
                        this.plugin.getLogger().info("Executing command: " + formattedCommand);
                    }
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formattedCommand);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe(String.format("Failed to execute command for goal %s: %s", goal.getName(), e.getMessage()));
                }
            });
        }
    }

    private String formatCommand(String command, Player player) {
        this.goalMessageReplacements.put("PLAYER_NAME", player.getName());
        return this.replacePlaceholders(command).replaceFirst("/", "");
    }

    private void playGoalSound(Player player, Goal goal) {
        try {
            Sound sound;
            String soundName;
            block6: {
                soundName = goal.getGoalSound();
                sound = null;
                try {
                    sound = (Sound)Sound.class.getField(soundName).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    if (!this.plugin.getConfiguration().getBoolean("goal-check-verbose").booleanValue()) break block6;
                    this.plugin.getLogger().info("Could not find sound directly, attempting fallback: " + e.getMessage());
                }
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for goal '%s'", soundName, goal.getName()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for goal '%s': %s", goal.getGoalSound(), goal.getName(), e.getMessage()));
        }
    }

    private void sendGoalMessage(Player player, Goal goal) {
        this.goalMessageReplacements.put("%PLAYER_NAME%", player.getName());
        this.goalMessageReplacements.put("%TIME_REQUIRED%", goal.getRequirements().getTime() != Long.MAX_VALUE ? Utils.ticksToFormattedPlaytime(goal.getRequirements().getTime()) : "-");
        this.goalMessageReplacements.put("%GOAL_NAME%", goal.getName());
        player.sendMessage(Utils.parseColors(this.replacePlaceholders(goal.getGoalMessage())));
    }

    private String replacePlaceholders(String input) {
        String result = input;
        for (Map.Entry<String, String> entry : this.goalMessageReplacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        this.goalMessageReplacements.clear();
        return result;
    }

    private void logVerboseInfo() {
        this.plugin.getLogger().info(String.format("Goal check schedule started, refresh rate is %ss", this.plugin.getConfiguration().getInt("goal-check-rate")));
    }

    public void stopSchedules() {
        Optional.ofNullable(this.goalSchedule).ifPresent(BukkitTask::cancel);
        Optional.ofNullable(this.dbUpdateSchedule).ifPresent(BukkitTask::cancel);
    }
}

