/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.LocalDateTime;
import me.thegabro.playtimemanager.Users.DBUser;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class OnlineUser
extends DBUser {
    protected final Player playerInstance;
    private long afkStartPlaytime;
    private long currentSessionAFKTime;
    private boolean afkTimeFinalized;

    public OnlineUser(Player p) {
        super(p);
        this.playerInstance = p;
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.afkStartPlaytime = 0L;
        this.currentSessionAFKTime = 0L;
        this.afkTimeFinalized = false;
    }

    private long getCachedPlayTime() {
        return this.DBplaytime + ((long)this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE) - this.fromServerOnJoinPlayTime);
    }

    public void updatePlayTimeWithSnapshot(long playtimeSnapshot) {
        long currentPlaytime = this.DBplaytime + (playtimeSnapshot - this.fromServerOnJoinPlayTime);
        db.updatePlaytime(this.uuid, currentPlaytime);
    }

    public void updatePlayTime() {
        long currentPlaytime = this.getCachedPlayTime();
        db.updatePlaytime(this.uuid, currentPlaytime);
    }

    public void updateAFKPlayTime() {
        if (!this.afkTimeFinalized) {
            this.finalizeCurrentAFKSession();
        }
        long totalAFKTime = this.DBAFKplaytime + this.currentSessionAFKTime;
        db.updateAFKPlaytime(this.uuid, totalAFKTime);
    }

    public void updateLastSeen() {
        this.lastSeen = LocalDateTime.now();
        db.updateLastSeen(this.uuid, this.lastSeen);
    }

    public Player getPlayerInstance() {
        return this.playerInstance;
    }

    @Override
    public long getPlaytime() {
        long totalPlaytime = this.getCachedPlayTime() + this.artificialPlaytime;
        if (plugin.getConfiguration().getBoolean("ignore-afk-time").booleanValue()) {
            totalPlaytime -= this.getAFKPlaytime();
        }
        return Math.max(0L, totalPlaytime);
    }

    @Override
    public long getPlaytimeWithSnapshot(long playtimeSnapshot) {
        long totalPlaytime = this.DBplaytime + (playtimeSnapshot - this.fromServerOnJoinPlayTime) + this.artificialPlaytime;
        if (plugin.getConfiguration().getBoolean("ignore-afk-time").booleanValue()) {
            totalPlaytime -= this.getAFKPlaytimeWithSnapshot(playtimeSnapshot);
        }
        return Math.max(0L, totalPlaytime);
    }

    @Override
    public long getAFKPlaytime() {
        long totalAFK = this.DBAFKplaytime + this.currentSessionAFKTime;
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long currentPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
            long ongoingAFKTime = currentPlaytime - this.afkStartPlaytime;
            totalAFK += ongoingAFKTime;
        }
        return Math.max(0L, totalAFK);
    }

    @Override
    public long getAFKPlaytimeWithSnapshot(long playtimeSnapshot) {
        long totalAFK = this.DBAFKplaytime + this.currentSessionAFKTime;
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long ongoingAFKTime = playtimeSnapshot - this.afkStartPlaytime;
            totalAFK += ongoingAFKTime;
        }
        return Math.max(0L, totalAFK);
    }

    @Override
    public LocalDateTime getLastSeen() {
        return LocalDateTime.now();
    }

    public void refreshFromServerOnJoinPlayTime() {
        this.fromServerOnJoinPlayTime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
    }

    @Override
    public void setAFK(boolean isAFK) {
        if (isAFK && !this.afk) {
            this.afk = true;
            this.afkStartPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
            this.afkTimeFinalized = false;
        } else if (!isAFK && this.afk) {
            if (this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
                long currentPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
                long afkDuration = currentPlaytime - this.afkStartPlaytime;
                this.currentSessionAFKTime += afkDuration;
            }
            this.afk = false;
            this.afkStartPlaytime = 0L;
            this.afkTimeFinalized = false;
        }
    }

    public void finalizeCurrentAFKSession(long playtimeSnapshot) {
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long afkDuration = playtimeSnapshot - this.afkStartPlaytime;
            this.currentSessionAFKTime += afkDuration;
            this.afkTimeFinalized = true;
        }
    }

    public void finalizeCurrentAFKSession() {
        if (this.afk && this.afkStartPlaytime > 0L && !this.afkTimeFinalized) {
            long currentPlaytime = this.playerInstance.getStatistic(Statistic.PLAY_ONE_MINUTE);
            long afkDuration = currentPlaytime - this.afkStartPlaytime;
            this.currentSessionAFKTime += afkDuration;
            this.afkTimeFinalized = true;
        }
    }
}

