/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.PlayTimeManager;

public class Version342to35Updater {
    private final PlayTimeManager plugin;
    private final CommandsConfiguration commandsConfiguration = CommandsConfiguration.getInstance();

    public Version342to35Updater(PlayTimeManager plugin) {
        this.plugin = plugin;
    }

    public void performUpgrade() {
        this.renameCustomizationsFolder();
        this.recreateConfigFile();
    }

    public void renameCustomizationsFolder() {
        try {
            Path sourcePath = Paths.get(String.valueOf(this.plugin.getDataFolder()), "Translations");
            Path targetPath = Paths.get(String.valueOf(this.plugin.getDataFolder()), "Customizations");
            if (Files.exists(sourcePath, new LinkOption[0])) {
                if (Files.exists(targetPath, new LinkOption[0])) {
                    this.plugin.getLogger().warning("Customizations folder already exists. Deleting it");
                    this.deleteDirectory(targetPath);
                }
                this.copyDirectory(sourcePath, targetPath);
                this.deleteDirectory(sourcePath);
                this.plugin.getLogger().info("Successfully created 'Customizations' folder from 'Translations'");
            } else {
                try {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Failed to create 'Customizations' folder: " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to rename Translations folder: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Unexpected error while renaming folder: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void deleteDirectory(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    private void copyDirectory(Path source, Path target) throws IOException {
        try (Stream<Path> pathStream = Files.walk(source, new FileVisitOption[0]);){
            pathStream.forEach(sourcePath -> {
                try {
                    Path targetPath = target.resolve(source.relativize((Path)sourcePath));
                    Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to copy: " + String.valueOf(sourcePath), e);
                }
            });
        }
    }

    private void recreateConfigFile() {
        String playtimeSelfMessage = Configuration.getInstance().getConfig().getString("playtime-self-message");
        String playtimeOthersMessage = Configuration.getInstance().getConfig().getString("playtime-others-message");
        Configuration.getInstance().updateConfig(true);
        this.recreateCommandsConfigurationFile(playtimeSelfMessage, playtimeOthersMessage);
    }

    public void recreateCommandsConfigurationFile(String playtimeSelfMessage, String playtimeOthersMessage) {
        this.commandsConfiguration.initialize(this.plugin);
        this.commandsConfiguration.updateConfig();
        this.commandsConfiguration.set("playtime-self-message", playtimeSelfMessage);
        this.commandsConfiguration.set("playtime-others-message", playtimeOthersMessage);
        this.commandsConfiguration.reload();
    }
}

