/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.SQLite;

public class Version321to33Updater {
    private final PlayTimeManager plugin;
    private final SQLite database;

    public Version321to33Updater(PlayTimeManager plugin) {
        this.plugin = plugin;
        this.database = (SQLite)plugin.getDatabase();
    }

    public void performUpgrade() {
        this.addFirstJoinColumn();
        this.recreateConfigFile();
    }

    public void addFirstJoinColumn() {
        try (Connection connection = this.database.getSQLConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN first_join DATETIME DEFAULT NULL");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    private void recreateConfigFile() {
        Configuration.getInstance().updateConfig(true);
    }
}

