/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.SQLite;
import org.bukkit.configuration.file.YamlConfiguration;

public class Version304To31Updater {
    private final PlayTimeManager plugin;
    private final SQLite database;
    private final GoalsManager goalsManager;

    public Version304To31Updater(PlayTimeManager plugin) {
        this.plugin = plugin;
        this.database = (SQLite)plugin.getDatabase();
        this.goalsManager = GoalsManager.getInstance();
        this.goalsManager.initialize(plugin);
    }

    public void performUpgrade() {
        this.performDatabaseMigration();
        this.recreateConfigFile();
        this.migrateUserGoalData();
    }

    private void performDatabaseMigration() {
        try (Connection connection = this.database.getSQLConnection();){
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN completed_goals TEXT DEFAULT ''");
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Database migration failed: " + e.getMessage());
            }
            this.convertGroupsToGoals(connection);
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Database migration failed: " + e.getMessage());
        }
    }

    private void convertGroupsToGoals(Connection connection) throws SQLException {
        Statement s;
        block25: {
            try {
                s = connection.createStatement();
                try {
                    ResultSet rs = s.executeQuery("SELECT * FROM groups");
                    block19: while (true) {
                        while (rs.next()) {
                            String groupName = rs.getString("group_name");
                            long requiredTime = rs.getLong("playtime_required");
                            File goalsDir = new File(this.plugin.getDataFolder(), "goals");
                            if (!goalsDir.exists()) {
                                goalsDir.mkdirs();
                            }
                            File goalFile = new File(goalsDir, groupName + ".yml");
                            YamlConfiguration config = new YamlConfiguration();
                            String header = "GUIDE OF AVAILABLE OPTIONS:\n---------------------------\ngoal-sound is played to a player if it reaches the time specified in this config.\nA list of available sounds can be found here: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Sound.html\n---------------------------\ngoal-message is showed to a player if it reaches the time specified in this config.\nAvailable placeholders: %TIME_REQUIRED%, %PLAYER_NAME%\n---------------------------\nactive determines whether this goal is enabled and being checked by the plugin\nSet to 'true' to enable the goal and track player progress\nSet to 'false' (default option) to disable the goal without deleting it\nThis is useful for:\n* Temporarily disabling goals without removing them\n* Testing new goals before making them live\n* Managing seasonal or event-specific goals\n---------------------------\npermissions defines what permissions will be granted to a player when they reach this goal\nYou can specify multiple permissions and groups that will all be granted. The plugin will assume that\nthe group has already been created using the permissions manager plugin specified in the main config.\n---------------------------\ncommands defines a list of commands that will be executed when a player reaches this goal\nAvailable placeholders: %PLAYER_NAME%\nExample commands:\n- '/give %PLAYER_NAME% diamond 64'\n- '/broadcast %PLAYER_NAME% has reached an amazing milestone!'";
                            config.options().header(header);
                            config.set("time", (Object)requiredTime);
                            config.set("goal-sound", (Object)"ENTITY_PLAYER_LEVELUP");
                            config.set("goal-message", (Object)"[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Congratulations \u00a7e%PLAYER_NAME%\u00a77 you have reached \u00a76%TIME_REQUIRED%\u00a77 of playtime!");
                            config.set("active", (Object)true);
                            ArrayList<CallSite> permissions = new ArrayList<CallSite>();
                            permissions.add((CallSite)((Object)("group." + groupName)));
                            config.set("permissions", permissions);
                            config.set("commands", new ArrayList());
                            try {
                                config.save(goalFile);
                                this.plugin.getLogger().info("Created goal config for former group: " + groupName);
                                continue block19;
                            }
                            catch (IOException e) {
                                this.plugin.getLogger().severe("Failed to save goal config for " + groupName + ": " + e.getMessage());
                            }
                        }
                        break block25;
                        {
                            continue block19;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (s != null) {
                        s.close();
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().info("Error while migrating groups: " + String.valueOf(e));
            }
        }
        s = connection.createStatement();
        try {
            s.executeUpdate("DROP TABLE IF EXISTS groups");
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    private void recreateConfigFile() {
        Configuration.getInstance().updateConfig(true);
    }

    private void migrateUserGoalData() {
        HashMap<String, Object[]> userData = new HashMap<String, Object[]>();
        String selectUsersQuery = "SELECT uuid, playtime, completed_goals FROM play_time";
        try (Connection conn = this.database.getSQLConnection();
             PreparedStatement stmt = conn.prepareStatement(selectUsersQuery);
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                String string = rs.getString("uuid");
                long userPlaytime = rs.getLong("playtime");
                String completedGoalsStr = rs.getString("completed_goals");
                ArrayList<String> completedGoals = new ArrayList<String>();
                if (completedGoalsStr != null && !completedGoalsStr.isEmpty()) {
                    completedGoals.addAll(Arrays.asList(completedGoalsStr.split(",")));
                }
                userData.put(string, new Object[]{userPlaytime, completedGoals});
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving user data: " + e.getMessage());
            return;
        }
        File goalsDirectory = new File(this.plugin.getDataFolder(), "goals");
        if (!goalsDirectory.exists() || !goalsDirectory.isDirectory()) {
            this.plugin.getLogger().warning("Goals directory not found, skipping user goal data migration");
            return;
        }
        File[] goalFiles = goalsDirectory.listFiles((dir, name) -> name.endsWith(".yml"));
        if (goalFiles == null || goalFiles.length == 0) {
            this.plugin.getLogger().warning("No goal files found, skipping user goal data migration");
            return;
        }
        for (File goalFile : goalFiles) {
            YamlConfiguration goalConfig = YamlConfiguration.loadConfiguration((File)goalFile);
            String goalName = goalFile.getName().replace(".yml", "");
            long goalTime = goalConfig.getLong("time", 0L);
            for (Map.Entry entry : userData.entrySet()) {
                String uuid = (String)entry.getKey();
                long userPlaytime = (Long)((Object[])entry.getValue())[0];
                ArrayList completedGoals = (ArrayList)((Object[])entry.getValue())[1];
                if (userPlaytime < goalTime || completedGoals.contains(goalName)) continue;
                completedGoals.add(goalName);
            }
        }
        for (Map.Entry entry : userData.entrySet()) {
            String uuid = (String)entry.getKey();
            ArrayList completedGoals = (ArrayList)((Object[])entry.getValue())[1];
            this.database.updateCompletedGoals(uuid, completedGoals);
        }
    }
}

