/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import me.thegabro.playtimemanager.JoinStreaks.JoinStreakReward;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;

public class RewardRegistry {
    private final PlayTimeManager plugin;
    private final Set<JoinStreakReward> rewards = new HashSet<JoinStreakReward>();
    private final Map<Integer, LinkedHashSet<String>> joinRewardsMap = new HashMap<Integer, LinkedHashSet<String>>();
    private JoinStreakReward lastRewardByJoins;

    public RewardRegistry(PlayTimeManager plugin) {
        this.plugin = plugin;
    }

    public void createRewardsDirectory() {
        File rewardsFolder = new File(this.plugin.getDataFolder(), "Rewards");
        if (!rewardsFolder.exists()) {
            rewardsFolder.mkdirs();
        }
        this.createWarningFile(rewardsFolder);
    }

    private void createWarningFile(File rewardsFolder) {
        File warningFile = new File(rewardsFolder, "NEVER RENAME FILES IN THIS FOLDER.txt");
        if (!warningFile.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(warningFile));){
                writer.write("NEVER RENAME FILES IN THIS FOLDER\n");
                writer.write("--------------------------------------------------\n");
                writer.write("WARNING: The files in this folder are named according to their ID.\n");
                writer.write("Changing the names of these files will cause the configuration files to be missing in the database.\n");
                writer.write("This could result in failures as IDs are used by the plugin, and modifying the file names will break the mapping.\n");
                writer.write("ID values should never be changed by the user.\n");
                writer.write("--------------------------------------------------");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadRewards() {
        File[] rewardFiles;
        this.rewards.clear();
        this.joinRewardsMap.clear();
        File rewardsFolder = new File(this.plugin.getDataFolder(), "Rewards");
        if (rewardsFolder.exists() && rewardsFolder.isDirectory() && (rewardFiles = rewardsFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : rewardFiles) {
                String rewardID = file.getName().replace(".yml", "");
                try {
                    JoinStreakReward reward = new JoinStreakReward(this.plugin, Integer.parseInt(rewardID), -1);
                    this.addReward(reward);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid reward file name: " + file.getName());
                }
            }
        }
    }

    public void addReward(JoinStreakReward reward) {
        this.rewards.add(reward);
        this.updateJoinRewardsMap(reward);
        this.updateEndLoopReward();
    }

    public void removeReward(JoinStreakReward reward) {
        this.rewards.remove(reward);
        if (this.rewards.isEmpty()) {
            this.plugin.getConfiguration().set("rewards-check-schedule-activation", false);
        }
        this.joinRewardsMap.remove(reward.getId());
        this.updateEndLoopReward();
    }

    public void updateJoinRewardsMap(JoinStreakReward reward) {
        String rewardIdString = String.valueOf(reward.getId());
        int minJoins = reward.getMinRequiredJoins();
        int maxJoins = reward.getMaxRequiredJoins();
        this.joinRewardsMap.entrySet().removeIf(entry -> ((LinkedHashSet)entry.getValue()).stream().anyMatch(val -> val.split("\\.")[0].equals(rewardIdString)));
        if (minJoins == -1) {
            this.joinRewardsMap.put(reward.getId(), new LinkedHashSet());
        } else if (minJoins == maxJoins) {
            this.joinRewardsMap.put(reward.getId(), new LinkedHashSet<CallSite>(Collections.singleton(rewardIdString + "." + minJoins)));
        } else {
            LinkedHashSet<CallSite> set = new LinkedHashSet<CallSite>();
            for (int joinCount = minJoins; joinCount <= maxJoins; ++joinCount) {
                String joinCountStr = String.valueOf(joinCount);
                String valueStr = rewardIdString + "." + joinCountStr;
                set.add((CallSite)((Object)valueStr));
            }
            this.joinRewardsMap.put(reward.getId(), set);
        }
    }

    public void updateEndLoopReward() {
        this.lastRewardByJoins = this.rewards.stream().filter(reward -> reward.getMinRequiredJoins() != -1).max(Comparator.comparingInt(JoinStreakReward::getMaxRequiredJoins)).orElse(null);
    }

    public JoinStreakReward getMainInstance(String instance) {
        if (instance == null || instance.isEmpty()) {
            return null;
        }
        try {
            String[] parts = instance.split("\\.");
            if (parts.length > 0) {
                return this.getReward(Integer.parseInt(parts[0]));
            }
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Invalid reward ID format: " + instance);
        }
        return null;
    }

    public LinkedHashSet<String> getRewardIdsForJoinCount(int joinCount, OnlineUser onlineUser) {
        LinkedHashSet<String> rewardIds = new LinkedHashSet<String>();
        for (Map.Entry<Integer, LinkedHashSet<String>> entry : this.joinRewardsMap.entrySet()) {
            int id = entry.getKey();
            JoinStreakReward reward = this.getReward(id);
            if (reward == null) continue;
            int minJoins = reward.getMinRequiredJoins();
            int maxJoins = reward.getMaxRequiredJoins();
            if (reward.isSingleJoinReward()) {
                if (joinCount < minJoins || minJoins == -1) continue;
                rewardIds.add((String)entry.getValue().iterator().next());
                continue;
            }
            if (joinCount >= maxJoins) {
                rewardIds.addAll((Collection<String>)entry.getValue());
                continue;
            }
            if (joinCount < minJoins) continue;
            int position = joinCount - minJoins;
            Iterator iterator = entry.getValue().iterator();
            for (int count = 0; iterator.hasNext() && count <= position; ++count) {
                rewardIds.add((String)iterator.next());
            }
        }
        this.filterAlreadyProcessedRewards(rewardIds, onlineUser);
        return rewardIds;
    }

    private void filterAlreadyProcessedRewards(LinkedHashSet<String> rewardIds, OnlineUser onlineUser) {
        rewardIds.removeAll(onlineUser.getReceivedRewards());
        HashSet<String> toRemove = new HashSet<String>();
        for (String reward : onlineUser.getRewardsToBeClaimed()) {
            if (reward.endsWith(".R")) {
                String baseId = reward.substring(0, reward.length() - 2);
                String[] parts = baseId.split("\\.");
                if (parts.length < 2 || Integer.parseInt(parts[1]) == onlineUser.getRelativeJoinStreak()) continue;
                toRemove.add(baseId);
                continue;
            }
            toRemove.add(reward);
        }
        rewardIds.removeAll(toRemove);
        rewardIds.removeAll(onlineUser.getRewardsToBeClaimed());
    }

    public JoinStreakReward getReward(int id) {
        return this.rewards.stream().filter(g -> g.getId() == id).findFirst().orElse(null);
    }

    public boolean isEmpty() {
        return this.rewards.isEmpty();
    }

    public Set<JoinStreakReward> getRewards() {
        return new HashSet<JoinStreakReward>(this.rewards);
    }

    public void clearRewards() {
        this.rewards.clear();
        this.joinRewardsMap.clear();
        this.lastRewardByJoins = null;
    }

    public int getNextRewardId() {
        return this.rewards.stream().mapToInt(JoinStreakReward::getId).max().orElse(0) + 1;
    }

    public JoinStreakReward getLastRewardByJoins() {
        return this.lastRewardByJoins;
    }

    public void cleanUp() {
        this.clearRewards();
    }

    public Map<Integer, LinkedHashSet<String>> getJoinRewardsMap() {
        return this.joinRewardsMap;
    }
}

