/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.util.LinkedHashSet;
import me.thegabro.playtimemanager.JoinStreaks.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardExecutor;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardMessageService;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardRegistry;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.StreakTracker;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import org.bukkit.entity.Player;

public class RewardProcessor {
    private final PlayTimeManager plugin;
    private final RewardRegistry rewardRegistry;
    private final StreakTracker streakTracker;
    private final RewardExecutor rewardExecutor;
    private final RewardMessageService messageService;

    public RewardProcessor(PlayTimeManager plugin, RewardRegistry rewardRegistry, StreakTracker streakTracker, RewardExecutor rewardExecutor, RewardMessageService messageService) {
        this.plugin = plugin;
        this.rewardRegistry = rewardRegistry;
        this.streakTracker = streakTracker;
        this.rewardExecutor = rewardExecutor;
        this.messageService = messageService;
    }

    public void processEligibleRewards(OnlineUser onlineUser, Player player) {
        int currentStreak = onlineUser.getRelativeJoinStreak();
        LinkedHashSet<String> unclaimedRewards = this.rewardRegistry.getRewardIdsForJoinCount(currentStreak, onlineUser);
        for (String rewardKey : unclaimedRewards) {
            JoinStreakReward mainInstance = this.rewardRegistry.getMainInstance(rewardKey);
            if (onlineUser.getRewardsToBeClaimed().contains(rewardKey + ".R")) {
                this.messageService.sendRewardRelatedMessage(player, rewardKey, this.plugin.getConfiguration().getString("join-unclaimed-previous-message"), 0);
                continue;
            }
            if (mainInstance == null) continue;
            this.processQualifiedReward(onlineUser, player, mainInstance, rewardKey);
        }
        JoinStreakReward lastReward = this.rewardRegistry.getLastRewardByJoins();
        if (lastReward != null && onlineUser.getRelativeJoinStreak() >= lastReward.getMaxRequiredJoins()) {
            this.streakTracker.restartUserJoinStreakRewards(onlineUser);
        }
    }

    private void processQualifiedReward(OnlineUser onlineUser, Player player, JoinStreakReward reward, String rewardKey) {
        if (player.hasPermission("playtime.joinstreak.claim.automatic")) {
            onlineUser.addReceivedReward(rewardKey);
            this.messageService.sendRewardRelatedMessage(player, rewardKey, this.plugin.getConfiguration().getString("join-warn-autoclaim-message"), 1);
            this.rewardExecutor.processCompletedReward(player, reward, rewardKey);
        } else {
            if (!onlineUser.getRewardsToBeClaimed().contains(rewardKey.concat(".R"))) {
                onlineUser.addRewardToBeClaimed(rewardKey);
            }
            this.messageService.sendRewardRelatedMessage(player, rewardKey, this.plugin.getConfiguration().getString("join-warn-claim-message"), 1);
        }
    }
}

