/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.Player;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.GUIs.BaseCustomGUI;
import me.thegabro.playtimemanager.GUIs.InventoryListener;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerStatsGui
extends BaseCustomGUI {
    private final Inventory inv;
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final GUIsConfiguration config;
    private final DBUser subject;
    private final int guiSize;
    private final Map<Integer, String> slotItemTypes = new HashMap<Integer, String>();
    private static final String PERMISSION_STAFF_VIEW = "playtime.others.stats.staff";

    public PlayerStatsGui(Player sender, DBUser subject, String sessionToken) {
        super(sender, sessionToken);
        this.config = GUIsConfiguration.getInstance();
        this.subject = subject;
        ViewType viewType = this.getViewType();
        this.guiSize = this.getGuiSizeForView(viewType);
        String rawTitle = this.getTitleForView(viewType);
        String processedTitle = this.processInternalPlaceholders(rawTitle, "title");
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)this.guiSize, (Component)Utils.parseColors(processedTitle));
    }

    @Override
    public void openInventory() {
        if (this.subject.isOnline()) {
            this.initializeItems();
            InventoryListener.getInstance().registerGUI(this.sender.getUniqueId(), this);
            this.sender.openInventory(this.inv);
        } else {
            this.initializeItemsAsync(() -> {
                InventoryListener.getInstance().registerGUI(this.sender.getUniqueId(), this);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (this.sender.isOnline()) {
                        this.sender.openInventory(this.inv);
                    }
                });
            });
        }
    }

    private void initializeItems() {
        try {
            this.slotItemTypes.clear();
            this.inv.clear();
            this.createBorders();
            this.createConfigurableItemsSync();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error initializing PlayerStatsGui items: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void initializeItemsAsync(Runnable callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.slotItemTypes.clear();
                this.inv.clear();
                this.createBorders();
                this.createConfigurableItemsAsync(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, callback));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error initializing PlayerStatsGui items: " + e.getMessage());
                e.printStackTrace();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, callback);
            }
        });
    }

    private ViewType getViewType() {
        boolean isOwnStats = this.sender.getUniqueId().toString().equals(this.subject.getUuid());
        boolean hasStaffPermission = this.sender.hasPermission(PERMISSION_STAFF_VIEW);
        if (hasStaffPermission) {
            return ViewType.STAFF;
        }
        if (isOwnStats) {
            return ViewType.OWNER;
        }
        return ViewType.PLAYER;
    }

    private int getGuiSizeForView(ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String sizePath = "player-stats-gui.views." + viewKey + ".size";
        int configuredSize = this.config.getOrDefaultInt(sizePath, 54);
        return this.validateInventorySize(configuredSize);
    }

    private int validateInventorySize(int size) {
        if (size <= 9) {
            return 9;
        }
        if (size <= 18) {
            return 18;
        }
        if (size <= 27) {
            return 27;
        }
        if (size <= 36) {
            return 36;
        }
        if (size <= 45) {
            return 45;
        }
        return 54;
    }

    private String getTitleForView(ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String titlePath = "player-stats-gui.views." + viewKey + ".title";
        if (this.config.contains(titlePath)) {
            return this.config.getString(titlePath);
        }
        return "&6%PLAYER_NAME%'s Statistics";
    }

    private boolean areBordersEnabledForView(ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String borderEnabledPath = "player-stats-gui.views." + viewKey + ".border.enabled";
        if (this.config.contains(borderEnabledPath)) {
            return this.config.getBoolean(borderEnabledPath);
        }
        return true;
    }

    private Material getBorderMaterialForView(ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String borderMaterialPath = "player-stats-gui.views." + viewKey + ".border.material";
        String materialName = this.config.contains(borderMaterialPath) ? this.config.getString(borderMaterialPath) : "BLACK_STAINED_GLASS_PANE";
        try {
            return Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid border material '" + materialName + "' for view " + String.valueOf((Object)viewType) + ". Using BLACK_STAINED_GLASS_PANE.");
            return Material.BLACK_STAINED_GLASS_PANE;
        }
    }

    private String getBorderNameForView(ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String borderNamePath = "player-stats-gui.views." + viewKey + ".border.name";
        if (this.config.contains(borderNamePath)) {
            return this.config.getString(borderNamePath);
        }
        return " ";
    }

    private void createBorders() {
        ViewType currentView = this.getViewType();
        if (!this.areBordersEnabledForView(currentView)) {
            return;
        }
        Material borderMaterial = this.getBorderMaterialForView(currentView);
        String rawBorderName = this.getBorderNameForView(currentView);
        String borderName = this.processInternalPlaceholders(rawBorderName, "border");
        Set<Integer> borderSlots = this.calculateBorderSlots(this.guiSize);
        for (int slot : borderSlots) {
            this.inv.setItem(slot, this.createGuiItem(borderMaterial, Utils.parseColors(borderName), new Component[0]));
        }
    }

    private Set<Integer> calculateBorderSlots(int size) {
        HashSet<Integer> borderSlots = new HashSet<Integer>();
        int rows = size / 9;
        for (int i = 0; i < size; ++i) {
            int row = i / 9;
            int col = i % 9;
            if (row == 0 || row == rows - 1) {
                borderSlots.add(i);
                continue;
            }
            if (col != 0 && col != 8) continue;
            borderSlots.add(i);
        }
        return borderSlots;
    }

    private void createConfigurableItemsSync() {
        ViewType currentView = this.getViewType();
        Map items = this.config.getConfigurationSection("player-stats-gui.items").getValues(false);
        for (String itemKey : items.keySet()) {
            String itemPath = "player-stats-gui.items." + itemKey;
            if (!this.isItemVisibleForView(itemPath, currentView)) continue;
            OnlineUser onlineSubject = (OnlineUser)this.subject;
            Player onlinePlayer = onlineSubject.getPlayerInstance();
            this.processItemWithPlayerData(itemKey, currentView, (OfflinePlayer)onlinePlayer);
        }
    }

    private void createConfigurableItemsAsync(Runnable callback) {
        ViewType currentView = this.getViewType();
        Map items = this.config.getConfigurationSection("player-stats-gui.items").getValues(false);
        ArrayList<String> itemsToProcess = new ArrayList<String>();
        for (String itemKey : items.keySet()) {
            String itemPath = "player-stats-gui.items." + itemKey;
            if (!this.isItemVisibleForView(itemPath, currentView)) continue;
            itemsToProcess.add(itemKey);
        }
        if (this.plugin.isPlaceholdersAPIConfigured()) {
            this.subject.getPlayerInstance(offlinePlayer -> {
                for (String itemKey : itemsToProcess) {
                    this.processItemWithPlayerData(itemKey, currentView, (OfflinePlayer)offlinePlayer);
                }
                callback.run();
            });
        } else {
            for (String itemKey : itemsToProcess) {
                this.processItemWithPlayerData(itemKey, currentView, null);
            }
            callback.run();
        }
    }

    private void processItemWithPlayerData(String itemKey, ViewType currentView, @Nullable OfflinePlayer offlinePlayer) {
        String itemPath = "player-stats-gui.items." + itemKey;
        List<Integer> slots = this.getSlotsForView(itemPath, currentView);
        if (slots.isEmpty()) {
            this.plugin.getLogger().warning("No valid slots configured for item " + itemKey + " in view " + String.valueOf((Object)currentView) + ". Skipping item.");
            return;
        }
        String materialString = this.getMaterialStringForView(itemPath, currentView);
        if (materialString == null) {
            this.plugin.getLogger().warning("No material configured for item " + itemKey + " in view " + String.valueOf((Object)currentView) + ". Skipping item.");
            return;
        }
        String rawName = this.getNameForView(itemPath, currentView);
        List<String> loreConfig = this.getLoreForView(itemPath, currentView);
        for (int slot : slots) {
            if (slot < 0 || slot >= this.inv.getSize()) {
                this.plugin.getLogger().warning("Invalid slot " + slot + " for item " + itemKey + " in view " + String.valueOf((Object)currentView) + ". GUI size is " + this.inv.getSize() + ". Skipping slot.");
                continue;
            }
            this.createStatItem(slot, materialString, rawName, loreConfig, itemKey, offlinePlayer);
            this.slotItemTypes.put(slot, itemKey);
        }
    }

    private boolean isItemVisibleForView(String itemPath, ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String viewPath = itemPath + ".views." + viewKey;
        if (!this.config.contains(viewPath)) {
            return false;
        }
        String enabledPath = viewPath + ".enabled";
        return this.config.getOrDefaultBoolean(enabledPath, true);
    }

    private List<Integer> getSlotsForView(String itemPath, ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String viewSlotPath = itemPath + ".views." + viewKey + ".slot";
        ArrayList<Integer> slots = new ArrayList<Integer>();
        Object slotValue = this.config.get(viewSlotPath);
        if (slotValue instanceof List) {
            List slotList = (List)slotValue;
            for (Object slotObj : slotList) {
                try {
                    int slot;
                    if (slotObj instanceof Integer) {
                        slot = (Integer)slotObj;
                    } else {
                        if (!(slotObj instanceof String)) continue;
                        slot = Integer.parseInt(((String)slotObj).trim());
                    }
                    slots.add(slot);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            try {
                int slot = this.config.getInt(viewSlotPath);
                slots.add(slot);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return slots;
    }

    private String getMaterialStringForView(String itemPath, ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String viewMaterialPath = itemPath + ".views." + viewKey + ".material";
        if (this.config.contains(viewMaterialPath)) {
            return this.config.getString(viewMaterialPath);
        }
        return this.config.getString(itemPath + ".material");
    }

    private String getNameForView(String itemPath, ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String viewNamePath = itemPath + ".views." + viewKey + ".name";
        if (this.config.contains(viewNamePath)) {
            return this.config.getString(viewNamePath);
        }
        return this.config.getOrDefaultString(itemPath + ".name", "");
    }

    private List<String> getLoreForView(String itemPath, ViewType viewType) {
        String viewKey = viewType.name().toLowerCase();
        String viewLorePath = itemPath + ".views." + viewKey + ".lore";
        if (this.config.contains(viewLorePath)) {
            return this.config.getStringList(viewLorePath);
        }
        return this.config.getStringList(itemPath + ".lore");
    }

    private void createStatItem(int slot, String materialString, String rawName, List<String> loreConfig, String itemType, @Nullable OfflinePlayer offlinePlayer) {
        ItemStack item;
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String loreLine : loreConfig) {
            String processedLine = this.processPlaceholders(loreLine, itemType, offlinePlayer);
            lore.add(Utils.parseColors(processedLine));
        }
        String processedName = this.processPlaceholders(rawName, itemType, offlinePlayer);
        if (this.isPlayerHead(materialString)) {
            String processedMaterialString = this.processPlaceholders(materialString, itemType, offlinePlayer);
            String[] parts = processedMaterialString.split(":", 2);
            item = parts.length > 1 && !parts[1].trim().isEmpty() ? Utils.createPlayerHead(processedMaterialString) : Utils.createPlayerHeadWithContext(processedMaterialString, this.subject.getNickname());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                if (processedName != null && !processedName.isEmpty()) {
                    meta.displayName(Utils.parseColors(processedName).decoration(TextDecoration.ITALIC, false));
                }
                ArrayList<Component> metaLore = new ArrayList<Component>();
                for (Component loreLine : lore) {
                    metaLore.add(loreLine.decoration(TextDecoration.ITALIC, false));
                }
                meta.lore(metaLore);
                item.setItemMeta(meta);
            }
        } else {
            try {
                Material material = Material.valueOf((String)materialString);
                item = this.createGuiItem(material, Utils.parseColors(processedName), lore.toArray(new Component[0]));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material '" + materialString + "' for item " + itemType + ". Using STONE as fallback.");
                item = this.createGuiItem(Material.STONE, Utils.parseColors(processedName), lore.toArray(new Component[0]));
            }
        }
        this.inv.setItem(slot, item);
    }

    private boolean isPlayerHead(String materialString) {
        return materialString != null && materialString.toUpperCase().startsWith("PLAYER_HEAD");
    }

    private String processPlaceholders(String text, String itemType, @Nullable OfflinePlayer offlinePlayer) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String internalPlaceholdersParsed = this.processInternalPlaceholders(text, itemType);
        if (this.plugin.isPlaceholdersAPIConfigured()) {
            try {
                return PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)internalPlaceholdersParsed);
            }
            catch (Exception e) {
                return internalPlaceholdersParsed.replaceAll("%[^%]+%", "");
            }
        }
        return internalPlaceholdersParsed;
    }

    private String processInternalPlaceholders(String text, String itemType) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        HashMap<String, String> combinations = new HashMap<String, String>();
        this.addCommonPlaceholders(combinations);
        this.addTypeSpecialPlaceholders(combinations, itemType);
        return Utils.placeholdersReplacer(text, combinations);
    }

    private void addCommonPlaceholders(Map<String, String> combinations) {
        boolean isOnline;
        long playtimeSnapshot;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
        combinations.put("%PLAYER_NAME%", this.subject.getNickname());
        combinations.put("%UUID%", this.subject.getUuid());
        if (this.subject.isOnline()) {
            OnlineUser onlineUser = (OnlineUser)this.subject;
            playtimeSnapshot = onlineUser.getPlayerInstance().getStatistic(Statistic.PLAY_ONE_MINUTE);
        } else {
            playtimeSnapshot = 0L;
        }
        long totalPlaytime = this.subject.getPlaytimeWithSnapshot(playtimeSnapshot);
        long afkPlaytime = this.subject.getAFKPlaytimeWithSnapshot(playtimeSnapshot);
        long artificialPlaytime = this.subject.getArtificialPlaytime();
        long realPlaytime = this.plugin.getConfiguration().getBoolean("ignore-afk-time") != false ? totalPlaytime - artificialPlaytime + afkPlaytime : totalPlaytime - artificialPlaytime;
        combinations.put("%PLAYTIME%", String.valueOf(totalPlaytime));
        combinations.put("%ACTUAL_PLAYTIME%", String.valueOf(realPlaytime));
        combinations.put("%ARTIFICIAL_PLAYTIME%", String.valueOf(artificialPlaytime));
        combinations.put("%AFK_PLAYTIME%", String.valueOf(afkPlaytime));
        LocalDateTime firstJoin = this.subject.getFirstJoin();
        if (firstJoin != null) {
            combinations.put("%FIRST_JOIN_DATE%", firstJoin.format(formatter));
            Duration accountAge = Duration.between(firstJoin, LocalDateTime.now());
            combinations.put("%ACCOUNT_AGE%", Utils.ticksToFormattedPlaytime(accountAge.getSeconds() * 20L));
        } else {
            combinations.put("%FIRST_JOIN_DATE%", "Unknown");
            combinations.put("%ACCOUNT_AGE%", "Unknown");
        }
        LocalDateTime lastSeen = this.subject.getLastSeen();
        boolean bl = isOnline = Bukkit.getPlayer((String)this.subject.getUuid()) != null;
        if (isOnline) {
            combinations.put("%LAST_SEEN_DATE%", "Currently Online");
            combinations.put("%TIME_SINCE_LAST_SEEN%", "0");
        } else if (lastSeen != null && !lastSeen.equals(LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0))) {
            combinations.put("%LAST_SEEN_DATE%", lastSeen.format(formatter));
            Duration timeSinceLastSeen = Duration.between(lastSeen, LocalDateTime.now());
            combinations.put("%TIME_SINCE_LAST_SEEN%", Utils.ticksToFormattedPlaytime(timeSinceLastSeen.getSeconds() * 20L));
        } else {
            combinations.put("%LAST_SEEN_DATE%", "Unknown");
            combinations.put("%TIME_SINCE_LAST_SEEN%", "Unknown");
        }
        combinations.put("%RELATIVE_STREAK%", String.valueOf(this.subject.getRelativeJoinStreak()));
        combinations.put("%ABSOLUTE_STREAK%", String.valueOf(this.subject.getAbsoluteJoinStreak()));
        ArrayList<String> completedGoals = this.subject.getCompletedGoals();
        combinations.put("%GOALS_COUNT%", String.valueOf(completedGoals.size()));
        int position = DBUsersManager.getInstance().getTopPlayers().indexOf(OnlineUsersManager.getInstance().getOnlineUser(this.subject.getNickname()));
        if (position != -1) {
            combinations.put("%POSITION%", String.valueOf(position + 1));
        } else {
            combinations.put("%POSITION%", this.config.getOrDefaultString("player-stats-gui.leaderboard-settings.not-in-leaderboard-position", "-"));
        }
    }

    private void addTypeSpecialPlaceholders(Map<String, String> combinations, String itemType) {
        switch (itemType.toLowerCase()) {
            case "goals": {
                ArrayList<String> completedGoals = this.subject.getCompletedGoals();
                StringBuilder goalsList = new StringBuilder();
                for (int i = 0; i < completedGoals.size(); ++i) {
                    if (i > 0 && i % 3 == 0) {
                        goalsList.append("\n");
                    } else if (i > 0) {
                        goalsList.append(" ");
                    }
                    String goalFormat = this.config.getOrDefaultString("player-stats-gui.goals-settings.list-format", "&7- &e%GOAL%");
                    goalsList.append(goalFormat.replace("%GOAL%", completedGoals.get(i)));
                }
                combinations.put("%GOALS_LIST%", goalsList.toString());
            }
        }
    }

    private ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    @Override
    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, @NotNull InventoryAction action, @NotNull InventoryClickEvent event) {
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR)) {
            return;
        }
        String itemType = this.slotItemTypes.get(slot);
        if (itemType == null) {
            // empty if block
        }
    }

    public static enum ViewType {
        OWNER,
        PLAYER,
        STAFF;

    }
}

