/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport.PlaceHolders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class PlaceholderConditionEvaluator {
    private static PlaceholderConditionEvaluator instance;
    private static final Pattern EXPRESSION_PATTERN;

    private PlaceholderConditionEvaluator() {
    }

    public static synchronized PlaceholderConditionEvaluator getInstance() {
        if (instance == null) {
            instance = new PlaceholderConditionEvaluator();
        }
        return instance;
    }

    public boolean evaluate(Player player, String condition) {
        if (condition == null || condition.isEmpty()) {
            return false;
        }
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)condition.replace("PLAYER_NAME", player.getName()).trim());
        Matcher matcher = EXPRESSION_PATTERN.matcher(parsed);
        if (!matcher.matches()) {
            return false;
        }
        String leftRaw = matcher.group(1).trim();
        String operator = matcher.group(2).trim();
        String rightRaw = matcher.group(3).trim();
        Object left = this.parseValue(leftRaw);
        Object right = this.parseValue(rightRaw);
        return this.compareValues(left, right, operator);
    }

    private Object parseValue(String input) {
        if (input.startsWith("\"") && input.endsWith("\"") || input.startsWith("'") && input.endsWith("'")) {
            input = input.substring(1, input.length() - 1);
        }
        try {
            if (input.contains(".")) {
                return Double.parseDouble(input);
            }
            return Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            return input;
        }
    }

    private boolean compareValues(Object left, Object right, String operator) {
        if (left instanceof Number && right instanceof Number) {
            double leftNum = ((Number)left).doubleValue();
            double rightNum = ((Number)right).doubleValue();
            return switch (operator) {
                case "==" -> {
                    if (leftNum == rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case "!=" -> {
                    if (leftNum != rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (leftNum > rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (leftNum < rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (leftNum >= rightNum) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (leftNum <= rightNum) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        String leftStr = left.toString();
        String rightStr = right.toString();
        return switch (operator) {
            case "==" -> leftStr.equals(rightStr);
            case "!=" -> {
                if (!leftStr.equals(rightStr)) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                if (leftStr.compareTo(rightStr) > 0) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (leftStr.compareTo(rightStr) < 0) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (leftStr.compareTo(rightStr) >= 0) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (leftStr.compareTo(rightStr) <= 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean isValid(Player player, String expression) {
        String parsed = PlaceholderAPI.setPlaceholders((Player)player, (String)expression.trim());
        Matcher matcher = EXPRESSION_PATTERN.matcher(parsed);
        return matcher.matches();
    }

    static {
        EXPRESSION_PATTERN = Pattern.compile("(.+?)\\s*(==|!=|>=|<=|>|<)\\s*(.+)");
    }
}

