/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Events;

import me.thegabro.playtimemanager.ExternalPluginSupport.AFKSyncManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.Statistic;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class QuitEventManager
implements Listener {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final AFKSyncManager afkSyncManager = AFKSyncManager.getInstance();

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        OnlineUser onlineUser = this.onlineUsersManager.getOnlineUser(event.getPlayer().getName());
        if (onlineUser == null) {
            this.plugin.getLogger().severe("OnlineUser is null for player: " + event.getPlayer().getName());
            return;
        }
        try {
            long quitTimePlaytime = event.getPlayer().getStatistic(Statistic.PLAY_ONE_MINUTE);
            if (this.plugin.isAfkDetectionConfigured() && onlineUser.isAFK()) {
                onlineUser.finalizeCurrentAFKSession(quitTimePlaytime);
            }
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    onlineUser.updatePlayTimeWithSnapshot(quitTimePlaytime);
                    if (this.plugin.isAfkDetectionConfigured()) {
                        onlineUser.updateAFKPlayTime();
                    }
                    onlineUser.updateLastSeen();
                    if (this.plugin.isAfkDetectionConfigured()) {
                        this.afkSyncManager.handlePlayerQuit(onlineUser, () -> this.executeCleanup(onlineUser));
                    } else {
                        this.executeCleanup(onlineUser);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Error updating database for " + onlineUser.getNickname() + ": " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error during quit preparation for " + onlineUser.getNickname() + ": " + e.getMessage());
        }
    }

    private void executeCleanup(OnlineUser onlineUser) {
        try {
            this.onlineUsersManager.removeOnlineUser(onlineUser);
            this.dbUsersManager.removeUserFromCache(onlineUser.getUuid());
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    this.dbUsersManager.updateCachedTopPlayers(onlineUser);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Error updating top players cache: " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during quit cleanup for player " + onlineUser.getNickname() + ": " + e.getMessage());
        }
    }
}

