/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands.PlayTimeCommandManager;

import java.util.HashMap;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlaytimeCommand {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();
    private LuckPermsManager luckPermsManager = null;

    public PlaytimeCommand(CommandSender sender, String[] args) {
        if (this.plugin.isPermissionsManagerConfigured()) {
            try {
                this.luckPermsManager = LuckPermsManager.getInstance(this.plugin);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.execute(sender, args);
    }

    public boolean execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            if (!sender.hasPermission("playtime")) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to check playtime."));
                return false;
            }
            return this.handleSelf(sender);
        }
        if (args.length == 1) {
            if (!sender.hasPermission("playtime.others")) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to check other players' playtime."));
                return false;
            }
            return this.handleOther(sender, args[0]);
        }
        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Usage: /playtime [player]"));
        return false;
    }

    private boolean handleSelf(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You must be a player to execute this command"));
            return false;
        }
        Player player = (Player)sender;
        OnlineUser onlineUser = this.onlineUsersManager.getOnlineUser(player.getName());
        if (this.config.getString("playtime-self-message").contains("%PREFIX%") && this.plugin.isPermissionsManagerConfigured()) {
            this.luckPermsManager.getPrefixAsync(String.valueOf(player.getUniqueId())).thenAccept(prefix -> {
                String message = this.createMessage(this.config.getString("playtime-self-message"), player.getName(), String.valueOf(onlineUser.getPlaytime()), (String)prefix);
                sender.sendMessage(Utils.parseColors(message));
            });
        } else {
            String message = this.createMessage(this.config.getString("playtime-self-message"), player.getName(), String.valueOf(onlineUser.getPlaytime()), "");
            sender.sendMessage(Utils.parseColors(message));
        }
        return true;
    }

    private boolean handleOther(CommandSender sender, String playerName) {
        DBUser user = this.dbUsersManager.getUserFromNicknameWithContext(playerName, "playtime command");
        if (this.config.getString("playtime-others-message").contains("%PREFIX%") && this.plugin.isPermissionsManagerConfigured()) {
            this.luckPermsManager.getPrefixAsync(user.getUuid()).thenAccept(prefix -> {
                String message = this.createMessage(this.config.getString("playtime-others-message"), playerName, String.valueOf(user.getPlaytime()), (String)prefix);
                sender.sendMessage(Utils.parseColors(message));
            });
        } else {
            String message = this.createMessage(this.config.getString("playtime-others-message"), playerName, String.valueOf(user.getPlaytime()), "");
            sender.sendMessage(Utils.parseColors(message));
        }
        return true;
    }

    private String createMessage(String template, String playerName, String playtime, String prefix) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLAYER_NAME%", playerName);
        placeholders.put("%PLAYTIME%", playtime);
        if (prefix != null && !prefix.isEmpty()) {
            placeholders.put("%PREFIX%", prefix);
        } else {
            placeholders.put("%PREFIX%", "");
        }
        return Utils.placeholdersReplacer(template, placeholders);
    }
}

