/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Updates.DatabaseBackupUtility;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class PlayTimeBackup
implements CommandExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DatabaseBackupUtility backupUtility = DatabaseBackupUtility.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("playtime.backup")) {
            File success = this.backupUtility.createBackup(this.generateReadmeContent());
            if (success != null) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &7Database backup created successfully!"));
            } else {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &7Failed to create database backup. Check console for details."));
            }
            return true;
        }
        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have the permission to execute this command"));
        return false;
    }

    private String generateReadmeContent() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        String readme = "PlayTimeManager Database Backup\n==============================\n\nBackup created on: " + timestamp + "\n\nPlugin information:\n- Plugin name: PlayTimeManager\n- Version: " + this.plugin.getDescription().getVersion() + "\n- Author: TheGabro\n\nDatabase information:\n- Database name: play_time\n- Backup reason: Manual backup triggered by command\nRestore instructions:\n1. Stop your server\n2. Replace the play_time.db file in your plugins/PlayTimeManager folder with this backup\n3. Restart your server\n\nNote: This backup contains all player playtime data up to the moment of backup creation.\nIf you need assistance, please contact me on discord or refer to the documentation.\n";
        return readme;
    }
}

