/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormat;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormatsConfiguration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Utils {
    private static final long TICKS_PER_SECOND = 20L;
    private static final long TICKS_PER_MINUTE = 1200L;
    private static final long TICKS_PER_HOUR = 72000L;
    private static final long TICKS_PER_DAY = 1728000L;
    private static final long TICKS_PER_YEAR = 630720000L;

    public static Component parseColors(String input) {
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        TextComponent message = Component.empty();
        Style currentStyle = Style.empty();
        StringBuilder currentText = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '&' && i + 1 < input.length()) {
                char formatCode;
                if (currentText.length() > 0) {
                    message = message.append((Component)Component.text((String)currentText.toString(), (Style)currentStyle));
                    currentText.setLength(0);
                }
                if (i + 7 < input.length() && input.charAt(i + 1) == '#') {
                    String hexCode = input.substring(i + 2, i + 8);
                    try {
                        if (hexCode.matches("[0-9A-Fa-f]{6}")) {
                            currentStyle = currentStyle.color(TextColor.fromHexString((String)("#" + hexCode)));
                            i += 7;
                            continue;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if ((formatCode = Character.toLowerCase(input.charAt(i + 1))) == 'r') {
                    currentStyle = Style.empty();
                } else if (Utils.getLegacyColor(String.valueOf(formatCode)) != null) {
                    currentStyle = currentStyle.color(Utils.getLegacyColor(String.valueOf(formatCode)));
                } else if (Utils.getLegacyFormatting(String.valueOf(formatCode)) != null) {
                    currentStyle = currentStyle.decoration(Utils.getLegacyFormatting(String.valueOf(formatCode)), true);
                }
                ++i;
                continue;
            }
            currentText.append(input.charAt(i));
        }
        if (currentText.length() > 0) {
            message = message.append((Component)Component.text((String)currentText.toString(), (Style)currentStyle));
        }
        return message;
    }

    private static TextColor getLegacyColor(String code) {
        return switch (code.toLowerCase()) {
            case "0" -> TextColor.color((int)0, (int)0, (int)0);
            case "1" -> TextColor.color((int)0, (int)0, (int)170);
            case "2" -> TextColor.color((int)0, (int)170, (int)0);
            case "3" -> TextColor.color((int)0, (int)170, (int)170);
            case "4" -> TextColor.color((int)170, (int)0, (int)0);
            case "5" -> TextColor.color((int)170, (int)0, (int)170);
            case "6" -> TextColor.color((int)255, (int)170, (int)0);
            case "7" -> TextColor.color((int)170, (int)170, (int)170);
            case "8" -> TextColor.color((int)85, (int)85, (int)85);
            case "9" -> TextColor.color((int)85, (int)85, (int)255);
            case "a" -> TextColor.color((int)85, (int)255, (int)85);
            case "b" -> TextColor.color((int)85, (int)255, (int)255);
            case "c" -> TextColor.color((int)255, (int)85, (int)85);
            case "d" -> TextColor.color((int)255, (int)85, (int)255);
            case "e" -> TextColor.color((int)255, (int)255, (int)85);
            case "f" -> TextColor.color((int)255, (int)255, (int)255);
            default -> null;
        };
    }

    private static TextDecoration getLegacyFormatting(String code) {
        return switch (code.toLowerCase()) {
            case "k" -> TextDecoration.OBFUSCATED;
            case "l" -> TextDecoration.BOLD;
            case "m" -> TextDecoration.STRIKETHROUGH;
            case "n" -> TextDecoration.UNDERLINED;
            case "o" -> TextDecoration.ITALIC;
            default -> null;
        };
    }

    public static String stripColor(String text) {
        return text.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private static long safeAdd(long a, long b) {
        long result = a + b;
        if (((a ^ result) & (b ^ result)) < 0L) {
            return -1L;
        }
        return result;
    }

    private static long safeMultiply(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long result = a * b;
        if (a != result / b) {
            return -1L;
        }
        return result;
    }

    public static long formattedPlaytimeToTicks(String input) {
        if (input == null || input.trim().isEmpty()) {
            return -1L;
        }
        String[] timeParts = input.split("\\s*,\\s*");
        long timeToTicks = 0L;
        boolean hasYear = false;
        boolean hasDay = false;
        boolean hasHour = false;
        boolean hasMinute = false;
        boolean hasSecond = false;
        block16: for (String part : timeParts) {
            try {
                String format;
                int time = Integer.parseInt(part.replaceAll("[^\\d-]", ""));
                if (time < 0) {
                    return -1L;
                }
                switch (format = part.replaceAll("\\d", "")) {
                    case "y": {
                        if (hasYear) continue block16;
                        long partTicks = Utils.safeMultiply(time, 630720000L);
                        if (partTicks == -1L) {
                            return -1L;
                        }
                        if ((timeToTicks = Utils.safeAdd(timeToTicks, partTicks)) == -1L) {
                            return -1L;
                        }
                        hasYear = true;
                        break;
                    }
                    case "d": {
                        if (hasDay) continue block16;
                        long partTicks = Utils.safeMultiply(time, 1728000L);
                        if (partTicks == -1L) {
                            return -1L;
                        }
                        if ((timeToTicks = Utils.safeAdd(timeToTicks, partTicks)) == -1L) {
                            return -1L;
                        }
                        hasDay = true;
                        break;
                    }
                    case "h": {
                        if (hasHour) continue block16;
                        long partTicks = Utils.safeMultiply(time, 72000L);
                        if (partTicks == -1L) {
                            return -1L;
                        }
                        if ((timeToTicks = Utils.safeAdd(timeToTicks, partTicks)) == -1L) {
                            return -1L;
                        }
                        hasHour = true;
                        break;
                    }
                    case "m": {
                        if (hasMinute) continue block16;
                        long partTicks = Utils.safeMultiply(time, 1200L);
                        if (partTicks == -1L) {
                            return -1L;
                        }
                        if ((timeToTicks = Utils.safeAdd(timeToTicks, partTicks)) == -1L) {
                            return -1L;
                        }
                        hasMinute = true;
                        break;
                    }
                    case "s": {
                        if (hasSecond) continue block16;
                        long partTicks = Utils.safeMultiply(time, 20L);
                        if (partTicks == -1L) {
                            return -1L;
                        }
                        if ((timeToTicks = Utils.safeAdd(timeToTicks, partTicks)) == -1L) {
                            return -1L;
                        }
                        hasSecond = true;
                        break;
                    }
                    default: {
                        return -1L;
                    }
                }
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return timeToTicks;
    }

    public static String ticksToFormattedPlaytime(long ticks) {
        return Utils.ticksToFormattedPlaytime(ticks, PlaytimeFormatsConfiguration.getInstance().getFormat("default"));
    }

    public static String ticksToFormattedPlaytime(long ticks, PlaytimeFormat format) {
        boolean isNegative = ticks < 0L;
        ticks = Math.abs(ticks);
        long seconds = ticks / 20L;
        long SECONDS_PER_YEAR = 31536000L;
        long SECONDS_PER_DAY = 86400L;
        long SECONDS_PER_HOUR = 3600L;
        long SECONDS_PER_MINUTE = 60L;
        long years = seconds / 31536000L;
        long days = (seconds %= 31536000L) / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        Object result = format.getFormatting();
        if (years > 0L) {
            result = ((String)result).replace("%y%", String.valueOf(years));
            result = ((String)result).replace("{years}", format.getYearsLabel((int)years));
        } else {
            result = ((String)result).replaceAll("%y%\\{years\\}(?:,\\s*)?", "");
        }
        if (days > 0L) {
            result = ((String)result).replace("%d%", String.valueOf(days));
            result = ((String)result).replace("{days}", format.getDaysLabel((int)days));
        } else {
            result = ((String)result).replaceAll("%d%\\{days\\}(?:,\\s*)?", "");
        }
        if (hours > 0L) {
            result = ((String)result).replace("%h%", String.valueOf(hours));
            result = ((String)result).replace("{hours}", format.getHoursLabel((int)hours));
        } else {
            result = ((String)result).replaceAll("%h%\\{hours\\}(?:,\\s*)?", "");
        }
        if (minutes > 0L) {
            result = ((String)result).replace("%m%", String.valueOf(minutes));
            result = ((String)result).replace("{minutes}", format.getMinutesLabel((int)minutes));
        } else {
            result = ((String)result).replaceAll("%m%\\{minutes\\}(?:,\\s*)?", "");
        }
        if (seconds > 0L || years == 0L && days == 0L && hours == 0L && minutes == 0L) {
            result = ((String)result).replace("%s%", String.valueOf(seconds));
            result = ((String)result).replace("{seconds}", format.getSecondsLabel((int)seconds));
        } else {
            result = ((String)result).replaceAll("%s%\\{seconds\\}(?:,\\s*)?", "");
        }
        if (years == 0L && days == 0L && hours == 0L && minutes == 0L && seconds == 0L) {
            result = "0" + format.getSecondsLabel(0);
        }
        result = ((String)result).replaceAll("%[ydhms]%", "");
        result = ((String)result).replaceAll("\\{\\w+\\}", "");
        result = ((String)result).replaceAll(",\\s*,", ",");
        result = ((String)result).replaceAll("^,\\s*|,\\s*$", "");
        result = ((String)result).trim();
        return isNegative ? "-" + (String)result : result;
    }

    public static long ticksToTimeUnit(long ticks, String unit) {
        if (ticks < 0L) {
            return 0L;
        }
        long seconds = ticks / 20L;
        return switch (unit.toLowerCase()) {
            case "y" -> seconds / 31536000L;
            case "d" -> seconds / 86400L;
            case "h" -> seconds / 3600L;
            case "m" -> seconds / 60L;
            case "s" -> seconds;
            default -> 0L;
        };
    }

    public static String placeholdersReplacer(String message, Map<String, String> combinations) {
        Pattern pattern = Pattern.compile("%((?:AFK_|ACTUAL_|ARTIFICIAL_)?PLAYTIME)(?::(\\w+))?%");
        Matcher matcher = pattern.matcher(message);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String playtimeValue;
            String playtimeType = matcher.group(1);
            String formatName = matcher.group(2);
            PlaytimeFormatsConfiguration config = PlaytimeFormatsConfiguration.getInstance();
            String actualFormatName = formatName == null ? "default" : formatName;
            PlaytimeFormat format = config.getFormat(actualFormatName);
            format = format == null ? config.getFormat("default") : format;
            String placeholderKey = "%" + playtimeType + "%";
            if (combinations.containsKey(placeholderKey)) {
                try {
                    long ticks = Long.parseLong(combinations.get(placeholderKey));
                    playtimeValue = Utils.ticksToFormattedPlaytime(ticks, format);
                }
                catch (NumberFormatException e) {
                    playtimeValue = "0s";
                }
            } else {
                playtimeValue = "0s";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(playtimeValue));
        }
        matcher.appendTail(result);
        message = result.toString();
        for (Map.Entry<String, String> entry : combinations.entrySet()) {
            message = message.replace(entry.getKey(), entry.getValue());
        }
        message = message.replaceAll("\\s+", " ");
        return message;
    }

    public static ItemStack createPlayerHead(String input) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        if (input == null || input.trim().isEmpty()) {
            return skull;
        }
        String[] parts = input.split(":", 2);
        if (!parts[0].equalsIgnoreCase("PLAYER_HEAD")) {
            return skull;
        }
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (skullMeta != null) {
            try {
                String playerName = parts.length > 1 && !parts[1].trim().isEmpty() ? parts[1].trim() : "Steve";
                PlayerProfile profile = Bukkit.createProfile((String)playerName);
                skullMeta.setPlayerProfile(profile);
                skull.setItemMeta((ItemMeta)skullMeta);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return skull;
    }

    public static ItemStack createPlayerHeadWithContext(String input, String contextPlayerName) {
        String playerName;
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        if (input == null || input.trim().isEmpty()) {
            return skull;
        }
        String[] parts = input.split(":", 2);
        if (!parts[0].equalsIgnoreCase("PLAYER_HEAD")) {
            return skull;
        }
        if (parts.length > 1 && !parts[1].trim().isEmpty()) {
            playerName = parts[1].trim();
        } else if (contextPlayerName != null && !contextPlayerName.trim().isEmpty()) {
            playerName = contextPlayerName.trim();
        } else {
            return skull;
        }
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            try {
                PlayerProfile profile = Bukkit.createProfile((String)playerName);
                meta.setPlayerProfile(profile);
                skull.setItemMeta((ItemMeta)meta);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return skull;
    }
}

