/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.PlayTimeDatabase;
import me.thegabro.playtimemanager.Users.OnlineUser;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DBUser {
    protected String uuid;
    protected String nickname;
    protected long DBplaytime;
    protected long artificialPlaytime;
    protected long DBAFKplaytime;
    protected static final PlayTimeManager plugin = PlayTimeManager.getInstance();
    protected long fromServerOnJoinPlayTime;
    protected ArrayList<String> completedGoals;
    protected static PlayTimeDatabase db = plugin.getDatabase();
    protected LocalDateTime lastSeen;
    protected LocalDateTime firstJoin;
    protected final GoalsManager goalsManager = GoalsManager.getInstance();
    protected int relativeJoinStreak;
    protected int absoluteJoinStreak;
    protected LinkedHashSet<String> receivedRewards = new LinkedHashSet();
    protected LinkedHashSet<String> rewardsToBeClaimed = new LinkedHashSet();
    protected boolean afk;
    protected OfflinePlayer playerInstance;

    private DBUser(String uuid, String nickname, long playtime, long artificialPlaytime, long DBAFKplaytime, ArrayList<String> completedGoals, LocalDateTime lastSeen, LocalDateTime firstJoin, int relativeJoinStreak, int absoluteJoinStreak, LinkedHashSet<String> receivedRewards, LinkedHashSet<String> rewardsToBeClaimed) {
        this.uuid = uuid;
        this.nickname = nickname;
        this.DBplaytime = playtime;
        this.artificialPlaytime = artificialPlaytime;
        this.DBAFKplaytime = DBAFKplaytime;
        this.completedGoals = completedGoals;
        this.lastSeen = lastSeen;
        this.firstJoin = firstJoin;
        this.relativeJoinStreak = relativeJoinStreak;
        this.absoluteJoinStreak = absoluteJoinStreak;
        this.receivedRewards = receivedRewards;
        this.rewardsToBeClaimed = rewardsToBeClaimed;
        this.afk = false;
        this.playerInstance = null;
    }

    public DBUser(Player p) {
        this.uuid = p.getUniqueId().toString();
        this.nickname = p.getName();
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.userMapping();
        this.loadUserData();
        if (this.firstJoin == null) {
            this.firstJoin = LocalDateTime.now();
            db.updateFirstJoin(this.uuid, this.firstJoin);
        }
    }

    protected static DBUser fromUUID(String uuid) {
        if (uuid == null) {
            return null;
        }
        String nickname = db.getNickname(uuid);
        long playtime = db.getPlaytime(uuid);
        long artificialPlaytime = db.getArtificialPlaytime(uuid);
        long afkplaytime = db.getAFKPlaytime(uuid);
        ArrayList<String> completedGoals = db.getCompletedGoals(uuid);
        LocalDateTime lastSeen = db.getLastSeen(uuid);
        LocalDateTime firstJoin = db.getFirstJoin(uuid);
        int relativeJoinStreak = db.getRelativeJoinStreak(uuid);
        int absoluteJoinStreak = db.getAbsoluteJoinStreak(uuid);
        LinkedHashSet<String> receivedRewards = db.getReceivedRewards(uuid);
        LinkedHashSet<String> rewardsToBeClaimed = db.getRewardsToBeClaimed(uuid);
        return new DBUser(uuid, nickname, playtime, artificialPlaytime, afkplaytime, completedGoals, lastSeen, firstJoin, relativeJoinStreak, absoluteJoinStreak, receivedRewards, rewardsToBeClaimed);
    }

    private void loadUserData() {
        this.DBplaytime = db.getPlaytime(this.uuid);
        this.DBAFKplaytime = db.getAFKPlaytime(this.uuid);
        this.artificialPlaytime = db.getArtificialPlaytime(this.uuid);
        this.completedGoals = db.getCompletedGoals(this.uuid);
        this.lastSeen = db.getLastSeen(this.uuid);
        this.firstJoin = db.getFirstJoin(this.uuid);
        this.relativeJoinStreak = db.getRelativeJoinStreak(this.uuid);
        this.absoluteJoinStreak = db.getRelativeJoinStreak(this.uuid);
        this.receivedRewards = db.getReceivedRewards(this.uuid);
        this.rewardsToBeClaimed = db.getRewardsToBeClaimed(this.uuid);
        this.afk = false;
    }

    public boolean isOnline() {
        return this instanceof OnlineUser;
    }

    public void getPlayerInstance(Consumer<OfflinePlayer> callback) {
        if (this.playerInstance != null) {
            callback.accept(this.playerInstance);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try {
                UUID parsedUuid = UUID.fromString(this.uuid);
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)parsedUuid);
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                    this.playerInstance = player;
                    callback.accept(player);
                });
            }
            catch (IllegalArgumentException e) {
                plugin.getLogger().warning("Invalid UUID format for player: " + this.uuid);
                Bukkit.getScheduler().runTask((Plugin)plugin, () -> callback.accept(null));
            }
        });
    }

    public LocalDateTime getFirstJoin() {
        return this.firstJoin;
    }

    public LocalDateTime getLastSeen() {
        return this.lastSeen;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public long getPlaytime() {
        long totalPlaytime = this.DBplaytime + this.artificialPlaytime;
        if (plugin.getConfiguration().getBoolean("ignore-afk-time").booleanValue()) {
            totalPlaytime -= this.DBAFKplaytime;
        }
        return totalPlaytime;
    }

    public long getPlaytimeWithSnapshot(long playtimeSnapshot) {
        return this.getPlaytime();
    }

    public long getArtificialPlaytime() {
        return this.artificialPlaytime;
    }

    public void setArtificialPlaytime(long artificialPlaytime) {
        this.artificialPlaytime = artificialPlaytime;
        db.updateArtificialPlaytime(this.uuid, artificialPlaytime);
    }

    public ArrayList<String> getCompletedGoals() {
        return this.completedGoals;
    }

    public boolean hasCompletedGoal(String goalName) {
        return this.completedGoals.contains(goalName);
    }

    public void markGoalAsCompleted(String goalName) {
        this.completedGoals.add(goalName);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    public void unmarkGoalAsCompleted(String goalName) {
        this.completedGoals.remove(goalName);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    public int getAbsoluteJoinStreak() {
        return this.absoluteJoinStreak;
    }

    public int getRelativeJoinStreak() {
        return this.relativeJoinStreak;
    }

    public void incrementRelativeJoinStreak() {
        ++this.relativeJoinStreak;
        db.setRelativeJoinStreak(this.uuid, this.relativeJoinStreak);
    }

    public void incrementAbsoluteJoinStreak() {
        ++this.absoluteJoinStreak;
        db.setAbsoluteJoinStreak(this.uuid, this.absoluteJoinStreak);
    }

    public void setRelativeJoinStreak(int value) {
        this.relativeJoinStreak = value;
        db.setRelativeJoinStreak(this.uuid, this.relativeJoinStreak);
    }

    public void resetJoinStreaks() {
        this.relativeJoinStreak = 0;
        this.absoluteJoinStreak = 0;
        db.setAbsoluteJoinStreak(this.uuid, 0);
        db.setRelativeJoinStreak(this.uuid, 0);
    }

    public void resetRelativeJoinStreak() {
        this.relativeJoinStreak = 0;
        db.setRelativeJoinStreak(this.uuid, 0);
    }

    public void migrateUnclaimedRewards() {
        LinkedHashSet<String> newRewardsToBeClaimed = new LinkedHashSet<String>();
        for (String reward : this.rewardsToBeClaimed) {
            if (reward == null) continue;
            if (!reward.endsWith("R")) {
                String modifiedReward = reward + ".R";
                newRewardsToBeClaimed.add(modifiedReward);
                continue;
            }
            newRewardsToBeClaimed.add(reward);
        }
        this.rewardsToBeClaimed = newRewardsToBeClaimed;
        db.updateRewardsToBeClaimed(this.uuid, newRewardsToBeClaimed);
    }

    public void unclaimReward(String rewardId) {
        this.rewardsToBeClaimed.remove(rewardId);
        db.updateRewardsToBeClaimed(this.uuid, this.rewardsToBeClaimed);
    }

    public void unreceiveReward(String rewardId) {
        this.receivedRewards.remove(rewardId);
        db.updateReceivedRewards(this.uuid, this.receivedRewards);
    }

    public void wipeRewardToBeClaimed(String rewardId) {
        this.rewardsToBeClaimed.removeIf(reward -> {
            String mainInstance = reward.split("\\.")[0];
            return mainInstance.equals(rewardId);
        });
        db.updateRewardsToBeClaimed(this.uuid, this.rewardsToBeClaimed);
    }

    public void wipeReceivedReward(String rewardId) {
        this.receivedRewards.removeIf(reward -> {
            String mainInstance = reward.split("\\.")[0];
            return mainInstance.equals(rewardId);
        });
        db.updateReceivedRewards(this.uuid, this.receivedRewards);
    }

    public void addRewardToBeClaimed(String rewardKey) {
        this.rewardsToBeClaimed.add(rewardKey);
        db.updateRewardsToBeClaimed(this.uuid, this.rewardsToBeClaimed);
    }

    public void addReceivedReward(String rewardKey) {
        this.receivedRewards.add(rewardKey);
        db.updateReceivedRewards(this.uuid, this.receivedRewards);
    }

    public Set<String> getReceivedRewards() {
        return new HashSet<String>(this.receivedRewards);
    }

    public Set<String> getRewardsToBeClaimed() {
        return new HashSet<String>(this.rewardsToBeClaimed);
    }

    private void userMapping() {
        boolean uuidExists = db.playerExists(this.uuid);
        String existingNickname = uuidExists ? db.getNickname(this.uuid) : null;
        String existingUUID = db.getUUIDFromNickname(this.nickname);
        if (uuidExists) {
            if (!this.nickname.equals(existingNickname)) {
                db.updateNickname(this.uuid, this.nickname);
            }
        } else if (existingUUID != null) {
            db.updateUUID(this.uuid, this.nickname);
        } else {
            db.addNewPlayer(this.uuid, this.nickname, this.fromServerOnJoinPlayTime);
        }
    }

    public long getAFKPlaytime() {
        return this.DBAFKplaytime;
    }

    public long getAFKPlaytimeWithSnapshot(long playtimeSnapshot) {
        return this.getAFKPlaytime();
    }

    public boolean isAFK() {
        return this.afk;
    }

    public void setAFK(boolean afk) {
        this.afk = afk;
    }

    public void reset() {
        this.DBplaytime = 0L;
        this.DBAFKplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = 0L;
        this.lastSeen = null;
        this.firstJoin = null;
        this.relativeJoinStreak = 0;
        this.absoluteJoinStreak = 0;
        this.completedGoals.clear();
        this.receivedRewards.clear();
        this.rewardsToBeClaimed.clear();
        db.updatePlaytime(this.uuid, 0L);
        db.updateAFKPlaytime(this.uuid, 0L);
        db.updateArtificialPlaytime(this.uuid, 0L);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
        db.updateLastSeen(this.uuid, null);
        db.updateFirstJoin(this.uuid, null);
        db.setRelativeJoinStreak(this.uuid, 0);
        db.setAbsoluteJoinStreak(this.uuid, 0);
        db.updateReceivedRewards(this.uuid, this.receivedRewards);
        db.updateRewardsToBeClaimed(this.uuid, this.rewardsToBeClaimed);
    }

    public void resetPlaytime() {
        this.DBplaytime = 0L;
        this.DBAFKplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = 0L;
        db.updatePlaytime(this.uuid, 0L);
        db.updateArtificialPlaytime(this.uuid, 0L);
        db.updateAFKPlaytime(this.uuid, 0L);
    }

    public void resetLastSeen() {
        this.lastSeen = null;
        db.updateLastSeen(this.uuid, null);
    }

    public void resetFirstJoin() {
        this.firstJoin = null;
        db.updateFirstJoin(this.uuid, null);
    }

    public void resetJoinStreakRewards() {
        this.receivedRewards.clear();
        this.rewardsToBeClaimed.clear();
        db.updateReceivedRewards(this.uuid, this.receivedRewards);
        db.updateRewardsToBeClaimed(this.uuid, this.rewardsToBeClaimed);
    }

    public void resetGoals() {
        this.completedGoals.clear();
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }
}

