/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager;

import java.util.Objects;
import me.thegabro.playtimemanager.Commands.ClaimRewards;
import me.thegabro.playtimemanager.Commands.PlayTimeAttributeCommand;
import me.thegabro.playtimemanager.Commands.PlayTimeBackup;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlayTimeCommandManager;
import me.thegabro.playtimemanager.Commands.PlayTimeJoinStreak;
import me.thegabro.playtimemanager.Commands.PlayTimeStats;
import me.thegabro.playtimemanager.Commands.PlaytimeAverage;
import me.thegabro.playtimemanager.Commands.PlaytimeGoal;
import me.thegabro.playtimemanager.Commands.PlaytimePercentage;
import me.thegabro.playtimemanager.Commands.PlaytimeReload;
import me.thegabro.playtimemanager.Commands.PlaytimeTop;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormatsConfiguration;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.Events.JoinEventManager;
import me.thegabro.playtimemanager.Events.QuitEventManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.EssentialsX.EssentialsAFKHook;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.PlaceHolders.PlayTimePlaceHolders;
import me.thegabro.playtimemanager.GUIs.Goals.AllGoalsGui;
import me.thegabro.playtimemanager.GUIs.Goals.GoalRequirementsGui;
import me.thegabro.playtimemanager.GUIs.Goals.GoalRewardsGui;
import me.thegabro.playtimemanager.GUIs.Goals.GoalSettingsGui;
import me.thegabro.playtimemanager.GUIs.JoinStreak.AllJoinStreakRewardsGui;
import me.thegabro.playtimemanager.GUIs.JoinStreak.JoinStreakRewardPrizesGui;
import me.thegabro.playtimemanager.GUIs.JoinStreak.JoinStreakRewardSettingsGui;
import me.thegabro.playtimemanager.GUIs.Misc.ConfirmationGui;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.SQLiteDB.LogFilter;
import me.thegabro.playtimemanager.SQLiteDB.PlayTimeDatabase;
import me.thegabro.playtimemanager.SQLiteDB.SQLite;
import me.thegabro.playtimemanager.SessionManager;
import me.thegabro.playtimemanager.Updates.UpdateManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.bstats.bukkit.Metrics;
import net.luckperms.api.LuckPerms;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayTimeManager
extends JavaPlugin {
    private static PlayTimeManager instance;
    private Configuration config;
    private PlayTimeDatabase db;
    private boolean permissionsManagerConfigured;
    private boolean afkDetectionConfigured;
    private boolean placeholdersapiConfigured;
    private OnlineUsersManager onlineUsersManager;
    private DBUsersManager dbUsersManager;
    private JoinStreaksManager joinStreaksManager;
    private SessionManager sessionManager;
    public final String CURRENT_CONFIG_VERSION = "3.9";
    public final String SERVER_VERSION = Bukkit.getBukkitVersion().split("-")[0];
    public final boolean CACHE_DEBUG = false;

    public void onEnable() {
        int BSTATS_PLUGIN_ID = 24739;
        Metrics metrics = new Metrics(this, BSTATS_PLUGIN_ID);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        instance = this;
        LogFilter.registerFilter();
        this.db = new SQLite(this);
        this.db.load();
        UpdateManager updateManager = UpdateManager.getInstance(this);
        this.config = Configuration.getInstance(this.getDataFolder(), "config", true, true);
        if (!this.config.getString("config-version").equals("3.9")) {
            updateManager.performVersionUpdate(this.config.getString("config-version"), "3.9");
        }
        updateManager.initialize();
        PlaytimeFormatsConfiguration playtimeFormatsConfiguration = PlaytimeFormatsConfiguration.getInstance();
        playtimeFormatsConfiguration.initialize(this);
        GUIsConfiguration guiConfig = GUIsConfiguration.getInstance();
        guiConfig.initialize(this);
        CommandsConfiguration commandsConfig = CommandsConfiguration.getInstance();
        commandsConfig.initialize(this);
        GoalsManager goalsManager = GoalsManager.getInstance();
        goalsManager.initialize(this);
        this.permissionsManagerConfigured = this.checkPermissionsPlugin();
        this.afkDetectionConfigured = this.checkAFKPlugin();
        this.onlineUsersManager = OnlineUsersManager.getInstance();
        this.dbUsersManager = DBUsersManager.getInstance();
        this.joinStreaksManager = JoinStreaksManager.getInstance();
        this.joinStreaksManager.initialize(this);
        this.joinStreaksManager.onServerReload();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlayTimePlaceHolders().register();
            this.placeholdersapiConfigured = true;
        } else {
            this.placeholdersapiConfigured = false;
        }
        this.getServer().getPluginManager().registerEvents((Listener)new QuitEventManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinEventManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)ChatEventManager.getInstance(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AllGoalsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GoalSettingsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GoalRewardsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GoalRequirementsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ConfirmationGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinStreakRewardSettingsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AllJoinStreakRewardsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinStreakRewardPrizesGui(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("playtimegoal")).setExecutor((CommandExecutor)new PlaytimeGoal());
        Objects.requireNonNull(this.getCommand("playtime")).setExecutor((CommandExecutor)new PlayTimeCommandManager(){});
        Objects.requireNonNull(this.getCommand("playtime")).setTabCompleter((TabCompleter)new PlayTimeCommandManager());
        Objects.requireNonNull(this.getCommand("playtimeaverage")).setExecutor((CommandExecutor)new PlaytimeAverage(){});
        Objects.requireNonNull(this.getCommand("playtimepercentage")).setExecutor((CommandExecutor)new PlaytimePercentage(){});
        Objects.requireNonNull(this.getCommand("playtimetop")).setExecutor((CommandExecutor)new PlaytimeTop(){});
        Objects.requireNonNull(this.getCommand("playtimereload")).setExecutor((CommandExecutor)new PlaytimeReload(){});
        Objects.requireNonNull(this.getCommand("playtimebackup")).setExecutor((CommandExecutor)new PlayTimeBackup(){});
        Objects.requireNonNull(this.getCommand("playtimejoinstreak")).setExecutor((CommandExecutor)new PlayTimeJoinStreak(){});
        Objects.requireNonNull(this.getCommand("claimrewards")).setExecutor((CommandExecutor)new ClaimRewards(){});
        Objects.requireNonNull(this.getCommand("playtimeattribute")).setExecutor((CommandExecutor)new PlayTimeAttributeCommand(){});
        Objects.requireNonNull(this.getCommand("playtimestats")).setExecutor((CommandExecutor)new PlayTimeStats(){});
        this.onlineUsersManager.initialize();
        this.dbUsersManager.updateTopPlayersFromDB();
        this.sessionManager = new SessionManager();
        this.getLogger().info("has been enabled!");
    }

    public void onDisable() {
        this.onlineUsersManager.stopSchedules();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.onlineUsersManager.removeOnlineUser(this.onlineUsersManager.getOnlineUser(Objects.requireNonNull(p.getPlayer()).getName()));
        }
        this.db.close();
        HandlerList.unregisterAll((Plugin)this);
        this.dbUsersManager.clearCaches();
        this.joinStreaksManager.cleanUp();
        this.getLogger().info("has been disabled!");
    }

    public static PlayTimeManager getInstance() {
        return instance;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public PlayTimeDatabase getDatabase() {
        return this.db;
    }

    public LuckPerms getLuckPermsApi() {
        return LuckPermsManager.getInstance(this).getLuckPermsApi();
    }

    public boolean isPermissionsManagerConfigured() {
        return this.permissionsManagerConfigured;
    }

    public boolean isAfkDetectionConfigured() {
        return this.afkDetectionConfigured;
    }

    public boolean isPlaceholdersAPIConfigured() {
        return this.placeholdersapiConfigured;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    private boolean checkAFKPlugin() {
        String configuredPlugin = this.config.getString("afk-detection-plugin").toLowerCase();
        if ("essentials".equals(configuredPlugin)) {
            Plugin essentials = Bukkit.getPluginManager().getPlugin("Essentials");
            if (essentials != null && essentials.isEnabled()) {
                try {
                    EssentialsAFKHook afkHook = EssentialsAFKHook.getInstance();
                    this.getServer().getPluginManager().registerEvents((Listener)afkHook, (Plugin)this);
                    this.getLogger().info("Essentials detected! Launching related functions");
                    return true;
                }
                catch (Exception e) {
                    this.getLogger().severe("ERROR: Failed to initialize Essentials API: " + e.getMessage());
                    return false;
                }
            }
            this.getLogger().warning("Failed to initialize afk detection: Essentials plugin configured but not found! \nUntil this is resolved, PlayTimeManager will not be able to detect afk playtime");
            return false;
        }
        return false;
    }

    private boolean checkPermissionsPlugin() {
        String configuredPlugin = this.config.getString("permissions-manager-plugin").toLowerCase();
        if ("luckperms".equals(configuredPlugin)) {
            Plugin luckPerms = Bukkit.getPluginManager().getPlugin("LuckPerms");
            if (luckPerms != null && luckPerms.isEnabled()) {
                try {
                    LuckPermsManager.getInstance(this);
                    this.getLogger().info("LuckPerms detected! Launching related functions");
                    return true;
                }
                catch (Exception e) {
                    this.getLogger().severe("ERROR: Failed to initialize LuckPerms API: " + e.getMessage());
                    return false;
                }
            }
            this.getLogger().warning("Failed to initialize permissions system: LuckPerms plugin configured but not found! \nUntil this is resolved, PlayTimeManager will not be able to manage permissions or groups");
            return false;
        }
        return false;
    }
}

