/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.Goals;

import java.util.ArrayList;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.GUIs.Goals.AllGoalsGui;
import me.thegabro.playtimemanager.GUIs.Goals.GoalRequirementsGui;
import me.thegabro.playtimemanager.GUIs.Goals.GoalRewardsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class GoalSettingsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 45;
    private Inventory inventory;
    private Goal goal;
    private Object previousGui;
    private PlayTimeManager plugin;
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final ChatEventManager chatEventManager = ChatEventManager.getInstance();

    public GoalSettingsGui() {
    }

    public GoalSettingsGui(Goal goal, Object previousGui) {
        this.goal = goal;
        this.previousGui = previousGui;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)45, (Component)Component.text((String)(goal.getName() + " - Settings")));
        this.plugin = PlayTimeManager.getInstance();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void initializeItems() {
        this.inventory.clear();
        this.initializeBackground();
        this.initializeButtons();
    }

    private void initializeBackground() {
        for (int i = 0; i < 45; ++i) {
            if (this.isButtonSlot(i)) continue;
            this.inventory.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, (Component)Component.text((String)"\u00a7f[\u00a76P.T.M.\u00a7f]\u00a77"), new Component[0]));
        }
    }

    private boolean isButtonSlot(int slot) {
        return slot == 19 || slot == 23 || slot == 25 || slot == 40 || slot == 44;
    }

    private void initializeButtons() {
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getRewardPermissions().size() + "\u00a77 " + (this.goal.getRewardPermissions().size() != 1 ? "permissions loaded" : "permission loaded"))));
        lore.add(Component.text((String)"\u00a77Click to change the permissions"));
        if (!PlayTimeManager.getInstance().isPermissionsManagerConfigured()) {
            lore.add(Component.text((String)""));
            lore.add(Component.text((String)"\u00a74\u00a7lWARNING: \u00a7cNo permissions plugin detected!"));
            lore.add(Component.text((String)"\u00a7cPermissions will not be assigned"));
        }
        this.inventory.setItem(19, this.createGuiItem(Material.CHEST_MINECART, (Component)Component.text((String)"\u00a7e\u00a7lRewards"), new Component[]{Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getRewardPermissions().size() + "\u00a77 " + (this.goal.getRewardPermissions().size() != 1 ? "permissions loaded" : "permission loaded"))), Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getRewardCommands().size() + "\u00a77 " + (this.goal.getRewardCommands().size() != 1 ? "commands loaded" : "command loaded"))), Component.text((String)""), Component.text((String)"\u00a77Click to manage rewards")}));
        this.inventory.setItem(23, this.createGuiItem(Material.OAK_SIGN, (Component)Component.text((String)"\u00a7e\u00a7lGoal Message"), new Component[]{Component.text((String)""), Component.text((String)"\u00a77Left-click to edit the message"), Component.text((String)"\u00a77Right-click to display the message")}));
        this.inventory.setItem(25, this.createGuiItem(Material.NOTE_BLOCK, (Component)Component.text((String)"\u00a7e\u00a7lGoal Sound"), new Component[]{Component.text((String)("\u00a77Current: \u00a7f" + this.goal.getGoalSound())), Component.text((String)""), Component.text((String)"\u00a77Left-click to edit the sound"), Component.text((String)"\u00a77Right click to play the sound.")}));
        this.inventory.setItem(40, this.createGuiItem(this.goal.isActive() ? Material.GREEN_CONCRETE : Material.RED_CONCRETE, (Component)Component.text((String)(this.goal.isActive() ? "\u00a7a\u00a7lGoal Active" : "\u00a7c\u00a7lGoal Inactive")), new Component[]{Component.text((String)("\u00a77Click to " + (this.goal.isActive() ? "deactivate" : "activate") + " this goal"))}));
        this.inventory.setItem(21, this.createGuiItem(Material.PAPER, (Component)Component.text((String)"\u00a7c\u00a7lRequirements"), new Component[]{Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getRequirements().getPermissions().size() + "\u00a77 " + (this.goal.getRequirements().getPermissions().size() != 1 ? "permissions loaded" : "permission loaded"))), Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getRequirements().getPlaceholderConditions().size() + "\u00a77 " + (this.goal.getRequirements().getPlaceholderConditions().size() != 1 ? "conditions loaded" : "condition loaded"))), Component.text((String)""), Component.text((String)"\u00a77Click to manage requirements")}));
        this.inventory.setItem(36, this.createGuiItem(Material.PLAYER_HEAD, (Component)Component.text((String)"\u00a7e\u00a7lUncomplete Goal for Player"), new Component[]{Component.text((String)""), Component.text((String)"\u00a77Click to remove this goal's completion"), Component.text((String)"\u00a77from a specific player")}));
        this.inventory.setItem(44, this.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, (Component)Component.text((String)"\u00a7e\u00a7lBack"), new Component[0]));
    }

    public ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    public void onGUIClick(Player player, int slot, ItemStack clickedItem, ClickType clickType) {
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        switch (slot) {
            case 23: {
                if (clickType == ClickType.LEFT) {
                    this.openMessageEditor(player);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                player.sendMessage(Utils.parseColors(this.goal.getGoalMessage()));
                break;
            }
            case 25: {
                if (clickType == ClickType.LEFT) {
                    this.openSoundEditor(player);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                this.playGoalSound(player);
                break;
            }
            case 19: {
                player.closeInventory();
                new GoalRewardsGui(this.goal, this).openInventory(player);
                break;
            }
            case 40: {
                this.goal.setActivation(!this.goal.isActive());
                this.initializeItems();
                break;
            }
            case 21: {
                player.closeInventory();
                new GoalRequirementsGui(this.goal, this).openInventory(player);
                break;
            }
            case 36: {
                this.openUncompleteGoalDialog(player);
                break;
            }
            case 44: {
                this.handleBackButton(player);
            }
        }
    }

    private void openMessageEditor(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&l\u270e Message Editor: &e" + this.goal.getName());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter the new message for this goal.\n&7\u2022 Supports legacy and hex color codes\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component preText = Utils.parseColors("&7You can ");
        Component clickableText = Utils.parseColors("&l&6[click here]").clickEvent(ClickEvent.suggestCommand((String)this.goal.getGoalMessage().replace("\u00a7", "&"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to autocomplete the current message")));
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append((Component)Component.newline())).append(preText)).append(clickableText)).append(Utils.parseColors("&7 to autocomplete the current message"))).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                this.goal.setGoalMessage((String)message);
                player.sendMessage(Utils.parseColors("&aGoal message updated successfully!"));
            } else {
                player.sendMessage(Utils.parseColors("&cGoal message edit cancelled"));
            }
            this.reopenMainGui(player);
        });
    }

    private void openSoundEditor(Player player) {
        player.closeInventory();
        String actualUrl = "https://jd.papermc.io/paper/1.21.5/org/bukkit/Sound.html";
        Component header = Utils.parseColors("&6&l\u270e Sound Editor: &e" + this.goal.getName());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter the new sound for this goal.\n&7\u2022 Input is not case-sensitive\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component linkText = Utils.parseColors("&e&l\u00bb SOUND LIST \u00ab").clickEvent(ClickEvent.openUrl((String)actualUrl)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors("&fClick to open sounds documentation for 1.21.5")));
        Component linkInfo = Utils.parseColors("&7&oDocumentation for server version 1.21.5");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(linkText)).append((Component)Component.newline())).append(linkInfo)).append((Component)Component.newline())).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, input) -> {
            if (!input.equalsIgnoreCase("cancel")) {
                Sound sound = null;
                try {
                    sound = (Sound)Sound.class.getField(input.toUpperCase()).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
                if (sound != null) {
                    this.goal.setGoalSound(input.toUpperCase());
                    player.sendMessage(Utils.parseColors("&aGoal sound updated successfully!"));
                } else {
                    player.sendMessage(Utils.parseColors("&e" + input.toUpperCase() + " is not a valid sound"));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cGoal sound edit cancelled"));
            }
            this.reopenMainGui(player);
        });
    }

    private void playGoalSound(Player player) {
        try {
            Sound sound;
            String soundName;
            block6: {
                soundName = this.goal.getGoalSound();
                sound = null;
                try {
                    sound = (Sound)Sound.class.getField(soundName).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    if (!this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) break block6;
                    this.plugin.getLogger().info("Could not find sound directly, attempting fallback: " + e.getMessage());
                }
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for goal '%s'", soundName, this.goal.getName()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for goal '%s': %s", this.goal.getGoalSound(), this.goal.getName(), e.getMessage()));
        }
    }

    private void handleBackButton(Player player) {
        if (this.previousGui != null) {
            player.closeInventory();
            ((AllGoalsGui)this.previousGui).openInventory(player);
        }
    }

    private void openUncompleteGoalDialog(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&c&l\u270e Uncomplete Goal: &e" + this.goal.getName());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter the player name to uncomplete this goal for.\n&7\u2022 Player must have completed this goal\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, input) -> {
            if (!input.equalsIgnoreCase("cancel")) {
                String playerName = input.replace(" ", "");
                DBUser user = this.dbUsersManager.getUserFromNicknameWithContext(playerName, "uncomplete goal for user");
                if (user == null) {
                    player.sendMessage(Utils.parseColors("&cPlayer not found!"));
                } else if (user.hasCompletedGoal(this.goal.getName())) {
                    user.unmarkGoalAsCompleted(this.goal.getName());
                    player.sendMessage((Component)Component.text((String)("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Successfully uncompleted goal \u00a7a" + this.goal.getName() + "\u00a77 for player \u00a7a" + playerName)));
                } else {
                    player.sendMessage(Utils.parseColors("&cPlayer hasn't completed that goal!"));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cUncomplete goal operation cancelled"));
            }
            this.reopenMainGui(player);
        });
    }

    private void reopenMainGui(Player player) {
        Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(player));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof GoalSettingsGui && e.getRawSlot() < e.getInventory().getSize()) {
            e.setCancelled(true);
            GoalSettingsGui gui = (GoalSettingsGui)e.getInventory().getHolder();
            gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getClick());
        }
    }

    private static final class Slots {
        static final int GOAL_REWARDS = 19;
        static final int GOAL_REQUIREMENTS = 21;
        static final int GOAL_MESSAGE = 23;
        static final int GOAL_SOUND = 25;
        static final int UNCOMPLETE_GOAL = 36;
        static final int GOAL_ACTIVATION_STATUS = 40;
        static final int BACK_BUTTON = 44;

        private Slots() {
        }
    }
}

