/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.Goals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.GUIs.Goals.GoalSettingsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllGoalsGui
implements InventoryHolder,
Listener {
    private final Inventory inv;
    private final ArrayList<Integer> protectedSlots = new ArrayList();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final ChatEventManager chatEventManager = ChatEventManager.getInstance();
    private final int CREATE_GOAL = 4;

    public AllGoalsGui() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Component.text((String)"Goals"));
    }

    public void openInventory(Player p) {
        this.initializeItems();
        p.openInventory(this.inv);
    }

    public void initializeItems() {
        int leftIndex = 9;
        int rightIndex = 17;
        List<Goal> sortedGoals = this.goalsManager.getGoals().stream().sorted(Comparator.comparing(Goal::getName)).toList();
        this.protectedSlots.clear();
        this.inv.clear();
        for (int i = 0; i < 54; ++i) {
            if (i > 9 && i < 45 && i != leftIndex && i != rightIndex) continue;
            this.inv.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, (Component)Component.text((String)"\u00a7f[\u00a76P.T.M.\u00a7f]\u00a77"), new Component[0]));
            this.protectedSlots.add(i);
            if (i == leftIndex) {
                leftIndex += 9;
            }
            if (i != rightIndex) continue;
            rightIndex += 9;
        }
        this.inv.setItem(4, this.createGuiItem(Material.EMERALD, Utils.parseColors("&a&lCreate New Goal"), Utils.parseColors("&7Click to create a new goal")));
        if (!sortedGoals.isEmpty()) {
            int slot = 0;
            for (Goal goal : sortedGoals) {
                while (this.protectedSlots.contains(slot)) {
                    ++slot;
                }
                if (slot < 54) {
                    ItemStack item = goal.isActive() ? new ItemStack(Material.EXPERIENCE_BOTTLE) : new ItemStack(Material.RED_DYE);
                    ItemMeta meta = item.getItemMeta();
                    meta.displayName(Utils.parseColors("&e" + goal.getName()).decoration(TextDecoration.ITALIC, false));
                    List<Component> lore = Arrays.asList(Utils.parseColors("\u00a77Required Time: " + (goal.getRequirements().getTime() == Long.MAX_VALUE ? "-" : Utils.ticksToFormattedPlaytime(goal.getRequirements().getTime()))), Utils.parseColors("\u00a77Active: ").append(Component.text((String)(goal.isActive() ? "true" : "false")).color(goal.isActive() ? TextColor.color((int)0x55FF55) : TextColor.color((int)0xFF5555))).decoration(TextDecoration.ITALIC, false), Utils.parseColors("\u00a7e" + goal.getRewardPermissions().size() + "\u00a77 " + (goal.getRewardPermissions().size() != 1 ? "permissions loaded" : "permission loaded")), Utils.parseColors("\u00a7e" + goal.getRewardCommands().size() + "\u00a77 " + (goal.getRewardCommands().size() != 1 ? "commands loaded" : "command loaded")), Utils.parseColors(""), Utils.parseColors("&c&oShift-Right Click to delete"));
                    meta.lore(lore);
                    item.setItemMeta(meta);
                    this.inv.setItem(slot, item);
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            this.inv.setItem(22, this.createGuiItem(Material.BARRIER, Utils.parseColors("\u00a7l\u00a7cNo goals have been created!"), new Component[0]));
        }
    }

    private ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, @NotNull InventoryAction action, InventoryClickEvent event) {
        String goalName = "";
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        if (slot == 4) {
            this.createGoalDialog(whoClicked);
            return;
        }
        if (clickedItem.getItemMeta().hasDisplayName() && clickedItem.getType() != Material.BARRIER) {
            goalName = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName());
            Goal g = this.goalsManager.getGoal(goalName);
            if (event.isShiftClick() && event.isRightClick()) {
                this.handleDeleteGoal(whoClicked, g);
            } else if (!event.getClick().isCreativeAction()) {
                whoClicked.closeInventory();
                GoalSettingsGui settingsGui = new GoalSettingsGui(g, this);
                settingsGui.openInventory(whoClicked);
            }
        }
    }

    private void handleDeleteGoal(Player player, Goal goal) {
        player.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &7Deleting goal &e" + goal.getName() + "&7..."));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayTimeManager.getInstance(), () -> {
            goal.kill();
            Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getInstance(), () -> {
                player.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &aSuccessfully &7deleted goal &e" + goal.getName()));
                this.initializeItems();
                player.updateInventory();
            });
        });
    }

    private void createGoalDialog(Player player) {
        Component header = Utils.parseColors("&6&l\u2795 Goal creation");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&7Create a new goal, type a new name:\n&7\u2022 Choose a unique name (not already in use)\n&7\u2022 Goal will be set as &einactive&7 by default\n&7\u2022 Type &c&ocancel&r&7 to exit creation\nUse &f/playtimegoal create &7if chat input &cdoesn't work&7\n&7For more info take a look at the wiki");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    new Goal(this.plugin, (String)message, false);
                }
                player.sendMessage(Utils.parseColors("&aGoal \u00a7e" + message + " &ahas been created"));
            } else {
                player.sendMessage(Utils.parseColors("&cGoal creation cancelled"));
            }
            this.openInventory(player);
        });
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof AllGoalsGui) {
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                AllGoalsGui gui = (AllGoalsGui)e.getInventory().getHolder();
                gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getAction(), e);
            } else if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                e.setCancelled(true);
            }
        }
    }
}

