/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport.EssentialsX;

import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;

public class AFKSyncManager {
    private static AFKSyncManager instance;
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();

    private AFKSyncManager() {
    }

    public static AFKSyncManager getInstance() {
        if (instance == null) {
            instance = new AFKSyncManager();
        }
        return instance;
    }

    public void handlePlayerQuit(OnlineUser onlineUser, Runnable quitCleanup) {
        if (onlineUser == null) {
            return;
        }
        try {
            if (onlineUser.isAFK()) {
                onlineUser.setAFK(false);
            }
            quitCleanup.run();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error in handlePlayerQuit for " + onlineUser.getNickname() + ": " + e.getMessage());
            try {
                quitCleanup.run();
            }
            catch (Exception cleanupError) {
                this.plugin.getLogger().severe("Critical error during quit cleanup: " + cleanupError.getMessage());
            }
        }
    }

    public void handleAFKReturn(OnlineUser user) {
        if (user == null) {
            return;
        }
        try {
            if (user.isAFK()) {
                user.setAFK(false);
                user.updateAFKPlayTime();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error updating AFK return for player " + user.getNickname() + ": " + e.getMessage());
        }
    }

    public void handleAFKGo(OnlineUser user) {
        if (user == null) {
            return;
        }
        try {
            if (!user.isAFK()) {
                user.updateAFKPlayTime();
                user.setAFK(true);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error setting AFK status for player " + user.getNickname() + ": " + e.getMessage());
        }
    }
}

