/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Events;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class ChatEventManager
implements Listener {
    private static ChatEventManager instance;
    private final Map<UUID, ChatInputSession> activeSessions = new HashMap<UUID, ChatInputSession>();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();

    public ChatEventManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public static synchronized ChatEventManager getInstance() {
        if (instance == null) {
            instance = new ChatEventManager();
        }
        return instance;
    }

    public void startChatInput(Player player, BiConsumer<Player, String> callback) {
        UUID playerId = player.getUniqueId();
        this.activeSessions.put(playerId, new ChatInputSession(callback, false, false));
    }

    public void startChatInput(Player player, BiConsumer<Player, String> callback, boolean allowNewlines, String oldMessage) {
        UUID playerId = player.getUniqueId();
        ChatInputSession session = new ChatInputSession(callback, false, allowNewlines);
        if (oldMessage != null && !oldMessage.isEmpty()) {
            String[] lines;
            for (String line : lines = oldMessage.split("/n")) {
                session.addRow(line);
            }
        }
        this.activeSessions.put(playerId, session);
        this.displayCurrentMessage(player, session, "Edit Previous Message");
    }

    public void startCommandInput(Player player, BiConsumer<Player, String> callback) {
        UUID playerId = player.getUniqueId();
        this.activeSessions.put(playerId, new ChatInputSession(callback, true, false));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        ChatInputSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return;
        }
        if (!session.commandOnly()) {
            return;
        }
        event.setCancelled(true);
        String command = event.getMessage();
        if (!command.startsWith("/")) {
            player.sendMessage(Component.text((String)"Please enter a valid command starting with '/' or type 'cancel' to exit").color((TextColor)NamedTextColor.RED));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleInput(player, command, session));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        ChatInputSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return;
        }
        event.setCancelled(true);
        String message = PlainTextComponentSerializer.plainText().serialize(event.message());
        if (message.equalsIgnoreCase("cancel")) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                String finalMessage = session.allowNewlines() ? session.getMessageAsString() : "cancel";
                session.callback().accept(player, finalMessage);
                this.activeSessions.remove(playerId);
            });
            return;
        }
        if (message.equalsIgnoreCase("confirm")) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                String finalMessage = session.allowNewlines() ? session.getMessageAsString() : "confirm";
                session.callback().accept(player, finalMessage);
                this.activeSessions.remove(playerId);
            });
            return;
        }
        if (session.allowNewlines() && message.startsWith("edit:")) {
            try {
                String[] parts = message.split(":", 3);
                if (parts.length >= 3) {
                    int rowIndex = Integer.parseInt(parts[1]) - 1;
                    String newContent = parts[2];
                    if (rowIndex >= 0 && rowIndex < session.getRows().size()) {
                        session.updateRow(rowIndex, newContent);
                        this.displayCurrentMessage(player, session, "Row " + (rowIndex + 1) + " updated");
                    } else {
                        player.sendMessage(Component.text((String)("Invalid row number: " + (rowIndex + 1))).color((TextColor)NamedTextColor.RED));
                    }
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(Component.text((String)"Invalid row format. Use edit:ROW_NUMBER:NEW_TEXT").color((TextColor)NamedTextColor.RED));
            }
            return;
        }
        if (session.allowNewlines()) {
            if (message.equalsIgnoreCase("newline")) {
                session.addRow("");
                this.displayCurrentMessage(player, session, "New line added");
                return;
            }
            if (message.equalsIgnoreCase("removeline")) {
                if (!session.getRows().isEmpty()) {
                    session.removeLastRow();
                    this.displayCurrentMessage(player, session, "Last line removed");
                } else {
                    player.sendMessage(Component.text((String)"No lines to remove").color((TextColor)NamedTextColor.RED));
                }
                return;
            }
        }
        if (session.commandOnly() && !message.startsWith("/")) {
            player.sendMessage(Component.text((String)"Please enter a valid command starting with '/' or type 'cancel' to exit").color((TextColor)NamedTextColor.RED));
            return;
        }
        if (session.allowNewlines()) {
            if (session.getCurrentEditingRow() >= 0) {
                session.updateRow(session.getCurrentEditingRow(), message);
                session.setCurrentEditingRow(-1);
            } else if (session.getRows().isEmpty()) {
                session.addRow(message);
            } else {
                session.updateRow(session.getRows().size() - 1, message);
            }
            this.displayCurrentMessage(player, session, "Message updated");
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleInput(player, message, session));
        }
    }

    private void displayCurrentMessage(Player player, ChatInputSession session, String headerMessage) {
        List<String> rows = session.getRows();
        Component message = ((TextComponent)Component.empty().append(((TextComponent)Component.text((String)headerMessage).color((TextColor)NamedTextColor.GOLD)).decorate(TextDecoration.BOLD))).append((Component)Component.newline());
        if (rows.isEmpty()) {
            message = message.append(Component.text((String)"No content yet. Type a message to begin.").color((TextColor)NamedTextColor.GRAY));
        } else {
            for (int i = 0; i < rows.size(); ++i) {
                String rowContent = rows.get(i);
                Component rowDisplay = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)("[" + (i + 1) + "] ")).color((TextColor)NamedTextColor.YELLOW))).append(Utils.parseColors(rowContent.isEmpty() ? "<empty>" : rowContent))).append((Component)Component.space())).append(((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[Edit]").color((TextColor)NamedTextColor.AQUA)).decorate(TextDecoration.BOLD)).clickEvent(ClickEvent.suggestCommand((String)("edit:" + (i + 1) + ":" + rowContent)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to edit this line").color((TextColor)NamedTextColor.GRAY))))).append((Component)Component.newline());
                message = message.append(rowDisplay);
            }
        }
        message = message.append((Component)Component.newline()).append(((TextComponent)((TextComponent)Component.text((String)"[+Line]").color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.suggestCommand((String)"newline"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Add a new line").color((TextColor)NamedTextColor.GRAY)))).append((Component)Component.space()).append(((TextComponent)((TextComponent)Component.text((String)"[-Line]").color((TextColor)NamedTextColor.RED)).clickEvent(ClickEvent.suggestCommand((String)"removeline"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Remove last line").color((TextColor)NamedTextColor.GRAY)))).append((Component)Component.space()).append(((TextComponent)((TextComponent)Component.text((String)"[Confirm]").color((TextColor)NamedTextColor.GOLD)).clickEvent(ClickEvent.suggestCommand((String)"confirm"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Submit your message").color((TextColor)NamedTextColor.GRAY)))).append((Component)Component.space()).append(((TextComponent)((TextComponent)Component.text((String)"[Cancel]").color((TextColor)NamedTextColor.DARK_RED)).clickEvent(ClickEvent.suggestCommand((String)"cancel"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Cancel input").color((TextColor)NamedTextColor.GRAY)))).append((Component)Component.newline()).append(Component.text((String)"\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac").color((TextColor)NamedTextColor.DARK_GRAY));
        player.sendMessage(message);
    }

    private void handleInput(Player player, String message, ChatInputSession session) {
        UUID playerId = player.getUniqueId();
        session.callback().accept(player, message);
        this.activeSessions.remove(playerId);
    }

    private static class ChatInputSession {
        private final BiConsumer<Player, String> callback;
        private final boolean commandOnly;
        private final boolean allowNewlines;
        private final List<String> rows;
        private int currentEditingRow;

        public ChatInputSession(BiConsumer<Player, String> callback, boolean commandOnly, boolean allowNewlines) {
            this.callback = callback;
            this.commandOnly = commandOnly;
            this.allowNewlines = allowNewlines;
            this.rows = new ArrayList<String>();
            this.currentEditingRow = -1;
        }

        public BiConsumer<Player, String> callback() {
            return this.callback;
        }

        public boolean commandOnly() {
            return this.commandOnly;
        }

        public boolean allowNewlines() {
            return this.allowNewlines;
        }

        public List<String> getRows() {
            return this.rows;
        }

        public void addRow(String content) {
            this.rows.add(content);
        }

        public void updateRow(int index, String content) {
            if (index >= 0 && index < this.rows.size()) {
                this.rows.set(index, content);
            } else if (index == this.rows.size()) {
                this.rows.add(content);
            }
        }

        public void removeLastRow() {
            if (!this.rows.isEmpty()) {
                this.rows.remove(this.rows.size() - 1);
            }
        }

        public String getMessageAsString() {
            return String.join((CharSequence)"/n", this.rows);
        }

        public int getCurrentEditingRow() {
            return this.currentEditingRow;
        }

        public void setCurrentEditingRow(int row) {
            this.currentEditingRow = row;
        }
    }
}

