/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.thegabro.playtimemanager.GUIs.Player.PlayerStatsGui;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayTimeStats
implements CommandExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private static final Map<UUID, Long> lastGuiOpenTime = new HashMap<UUID, Long>();
    private static final long GUI_OPEN_COOLDOWN = 1000L;

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String targetPlayerName;
        if (!sender.hasPermission("playtime.stats")) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to use this command!"));
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You must specify a player name!"));
                return true;
            }
            targetPlayerName = sender.getName();
        } else {
            targetPlayerName = args[0];
        }
        DBUser user = this.dbUsersManager.getUserFromNicknameWithContext(targetPlayerName, "ptstats command");
        if (user == null) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &cPlayer not found!"));
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            this.sendTextStats(sender, user);
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.openStatsGui(player, user);
            return true;
        }
        this.sendTextStats(sender, user);
        return true;
    }

    private void sendTextStats(CommandSender sender, DBUser user) {
        long playtimeSnapshot;
        if (user.isOnline()) {
            OnlineUser onlineUser = (OnlineUser)user;
            playtimeSnapshot = onlineUser.getPlayerInstance().getStatistic(Statistic.PLAY_ONE_MINUTE);
        } else {
            playtimeSnapshot = 0L;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
        LocalDateTime lastSeen = user.getLastSeen();
        LocalDateTime firstJoin = user.getFirstJoin();
        long totalPlaytime = user.getPlaytimeWithSnapshot(playtimeSnapshot);
        long afkPlaytime = user.getAFKPlaytimeWithSnapshot(playtimeSnapshot);
        long artificialPlaytime = user.getArtificialPlaytime();
        int relativeJoinStreak = user.getRelativeJoinStreak();
        int absoluteJoinStreak = user.getAbsoluteJoinStreak();
        long realPlaytime = this.plugin.getConfiguration().getBoolean("ignore-afk-time") != false ? totalPlaytime - artificialPlaytime + afkPlaytime : totalPlaytime - artificialPlaytime;
        sender.sendMessage(Utils.parseColors("&8&l===============[ &6&lPlayer Stats &8&l]==============="));
        sender.sendMessage(Utils.parseColors("&7Player: &e" + user.getNickname()));
        sender.sendMessage(Utils.parseColors("\n&6&lPlaytime Information:"));
        sender.sendMessage(Utils.parseColors("&7Total Playtime: &e" + Utils.ticksToFormattedPlaytime(totalPlaytime)));
        sender.sendMessage(Utils.parseColors("&7- Real Playtime: &e" + Utils.ticksToFormattedPlaytime(realPlaytime)));
        sender.sendMessage(Utils.parseColors("&7- Artificial Playtime: &e" + Utils.ticksToFormattedPlaytime(artificialPlaytime)));
        sender.sendMessage(Utils.parseColors("&7- AFK Playtime: &e" + Utils.ticksToFormattedPlaytime(afkPlaytime)));
        if (firstJoin != null) {
            sender.sendMessage(Utils.parseColors("\n&6&lFirst Join:"));
            sender.sendMessage(Utils.parseColors("&7Date: &e" + firstJoin.format(formatter)));
            Duration accountAge = Duration.between(firstJoin, LocalDateTime.now());
            sender.sendMessage(Utils.parseColors("&7Account Age: &e" + Utils.ticksToFormattedPlaytime(accountAge.getSeconds() * 20L)));
        }
        if (lastSeen != null && !lastSeen.equals(LocalDateTime.of(1970, 1, 1, 0, 0, 0, 0))) {
            sender.sendMessage(Utils.parseColors("\n&6&lLast Seen:"));
            sender.sendMessage(Utils.parseColors("&7Date: &e" + lastSeen.format(formatter)));
            Duration timeSinceLastSeen = Duration.between(lastSeen, LocalDateTime.now());
            sender.sendMessage(Utils.parseColors("&7Time Elapsed: &e" + Utils.ticksToFormattedPlaytime(timeSinceLastSeen.getSeconds() * 20L)));
        }
        sender.sendMessage(Utils.parseColors("\n&6&lJoin Streak:"));
        sender.sendMessage(Utils.parseColors("&7Streak for the current cycle: &e" + relativeJoinStreak));
        sender.sendMessage(Utils.parseColors("&7Total Streak: &e" + absoluteJoinStreak));
        sender.sendMessage(Utils.parseColors("\n&6&lCompleted Goals:"));
        if (user.getCompletedGoals().isEmpty()) {
            sender.sendMessage(Utils.parseColors("&7No goals completed yet"));
        } else {
            for (String goal : user.getCompletedGoals()) {
                sender.sendMessage(Utils.parseColors("&7- &e" + goal));
            }
        }
        sender.sendMessage(Utils.parseColors("&8&l============================================"));
    }

    private void openStatsGui(Player player, DBUser user) {
        long lastTime;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (lastGuiOpenTime.containsKey(playerId) && currentTime - (lastTime = lastGuiOpenTime.get(playerId).longValue()) < 1000L) {
            player.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &cPlease wait before using this command again."));
            return;
        }
        lastGuiOpenTime.put(playerId, currentTime);
        String sessionToken = UUID.randomUUID().toString();
        this.plugin.getSessionManager().createSession(player.getUniqueId(), sessionToken);
        PlayerStatsGui gui = new PlayerStatsGui(player, user, sessionToken);
        gui.openInventory();
    }
}

