/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.ArrayList;
import java.util.List;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.PlayTimeDatabase;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayTimeAttributeCommand
implements CommandExecutor,
TabCompleter {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final PlayTimeDatabase db = this.plugin.getDatabase();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        boolean newValue;
        if (!sender.hasPermission("playtime.others.attributes")) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
            return false;
        }
        if (args.length < 2 || args.length > 3) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Usage: /playtimeattribute <player> <attribute> [true|false]"));
            return false;
        }
        String playerName = args[0];
        String attribute = args[1].toLowerCase();
        if (!attribute.equals("hidefromleaderboard")) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Invalid attribute. Available: hidefromleaderboard"));
            return false;
        }
        DBUser user = DBUsersManager.getInstance().getUserFromNicknameWithContext(playerName, "set hidefromleaderboard attribute command");
        if (user == null) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " The player &e" + playerName + "&7 has never joined the server!"));
            return false;
        }
        if (args.length == 3) {
            String value = args[2].toLowerCase();
            if (!value.equals("true") && !value.equals("false")) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Invalid value. Use: true or false"));
                return false;
            }
            newValue = Boolean.parseBoolean(value);
        } else {
            newValue = !this.getCurrentAttributeValue(user, attribute);
        }
        this.updatePlayerAttribute(sender, user, attribute, newValue, playerName);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String alias, @NotNull String[] args) {
        if (!sender.hasPermission("playtime.attribute")) {
            return new ArrayList<String>();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (player.getName().toLowerCase().startsWith(partial)) {
                    completions.add(player.getName());
                }
            });
        } else if (args.length == 2) {
            String partial = args[1].toLowerCase();
            if ("hidefromleaderboard".startsWith(partial)) {
                completions.add("hidefromleaderboard");
            }
        } else if (args.length == 3) {
            String partial = args[2].toLowerCase();
            if ("true".startsWith(partial)) {
                completions.add("true");
            }
            if ("false".startsWith(partial)) {
                completions.add("false");
            }
        }
        return completions;
    }

    private boolean getCurrentAttributeValue(DBUser user, String attribute) {
        switch (attribute) {
            case "hidefromleaderboard": {
                return DBUsersManager.getInstance().getPlayersHiddenFromLeaderBoard().contains(user.getNickname());
            }
        }
        return false;
    }

    private void updatePlayerAttribute(CommandSender sender, DBUser user, String attribute, boolean value, String playerName) {
        try {
            switch (attribute) {
                case "hidefromleaderboard": {
                    this.handleHiddenFromLeaderboardAttribute(sender, user, value, playerName);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error updating player attribute: " + e.getMessage());
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Failed to update player attribute"));
        }
    }

    private void handleHiddenFromLeaderboardAttribute(CommandSender sender, DBUser user, boolean hide, String playerName) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                if (hide) {
                    DBUsersManager.getInstance().hidePlayerFromLeaderBoard(user.getNickname());
                } else {
                    DBUsersManager.getInstance().unhidePlayerFromLeaderBoard(user.getNickname());
                }
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        DBUsersManager.getInstance().updateTopPlayersFromDB();
                        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Successfully set hidefromleaderboard to " + hide + " for player " + playerName));
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Failed to update leaderboard after setting attribute: " + e.getMessage());
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to update leaderboard visibility for player " + user.getNickname() + ": " + e.getMessage());
                e.printStackTrace();
            }
        });
    }
}

