/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.LocalDateTime;
import me.thegabro.playtimemanager.Users.DBUser;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class OnlineUser
extends DBUser {
    protected final Player p;

    public OnlineUser(Player p) {
        super(p);
        this.p = p;
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
    }

    private long getCachedPlayTime() {
        return this.DBplaytime + ((long)this.p.getStatistic(Statistic.PLAY_ONE_MINUTE) - this.fromServerOnJoinPlayTime);
    }

    public void updatePlayTime() {
        db.updatePlaytime(this.uuid, this.getCachedPlayTime());
    }

    public void updateLastSeen() {
        this.lastSeen = LocalDateTime.now();
        db.updateLastSeen(this.uuid, this.lastSeen);
    }

    public Player getPlayer() {
        return this.p;
    }

    @Override
    public long getPlaytime() {
        return this.getCachedPlayTime() + this.artificialPlaytime;
    }

    @Override
    public LocalDateTime getLastSeen() {
        return LocalDateTime.now();
    }

    public void refreshFromServerOnJoinPlayTime() {
        this.fromServerOnJoinPlayTime = this.p.getStatistic(Statistic.PLAY_ONE_MINUTE);
    }

    @Override
    public void reset() {
        this.DBplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = this.p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.lastSeen = null;
        this.firstJoin = null;
        this.relativeJoinStreak = 0;
        this.absoluteJoinStreak = 0;
        this.completedGoals.clear();
        this.receivedRewards.clear();
        this.rewardsToBeClaimed.clear();
        db.updatePlaytime(this.uuid, 0L);
        db.updateArtificialPlaytime(this.uuid, 0L);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
        db.updateLastSeen(this.uuid, this.lastSeen);
        db.updateFirstJoin(this.uuid, this.firstJoin);
        db.setRelativeJoinStreak(this.uuid, 0);
        db.setAbsoluteJoinStreak(this.uuid, 0);
        db.updateReceivedRewards(this.uuid, this.receivedRewards);
        db.updateRewardsToBeClaimed(this.uuid, this.rewardsToBeClaimed);
    }
}

