/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.PlayTimeDatabase;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DBUsersManager {
    private final PlayTimeDatabase db;
    private final PlayTimeManager plugin;
    private static volatile DBUsersManager instance;
    private final List<DBUser> topPlayers;
    private final Map<String, DBUser> userCache;
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final CommandsConfiguration commandsConfiguration = CommandsConfiguration.getInstance();
    private final Configuration configuration = Configuration.getInstance();
    private final GUIsConfiguration guIsConfiguration = GUIsConfiguration.getInstance();
    private static final int TOP_PLAYERS_LIMIT = 100;
    private List<String> playersHiddenFromLeaderBoard;

    private DBUsersManager() {
        this.plugin = PlayTimeManager.getInstance();
        this.db = this.plugin.getDatabase();
        this.topPlayers = Collections.synchronizedList(new ArrayList());
        this.userCache = new ConcurrentHashMap<String, DBUser>();
        this.startCacheMaintenanceTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBUsersManager getInstance() {
        if (instance != null) return instance;
        Class<DBUsersManager> clazz = DBUsersManager.class;
        synchronized (DBUsersManager.class) {
            if (instance != null) return instance;
            instance = new DBUsersManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void startCacheMaintenanceTask() {
        long clearInterval = 432000L;
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.clearCaches();
            this.updateTopPlayersFromDB();
        }, clearInterval, clearInterval);
    }

    public DBUser getUserFromNickname(String nickname) {
        String uuid = this.db.getUUIDFromNickname(nickname);
        if (uuid != null) {
            return this.getUserFromUUID(uuid);
        }
        return null;
    }

    public DBUser getUserFromUUID(String uuid) {
        OnlineUser onlineUser = this.onlineUsersManager.getOnlineUserByUUID(uuid);
        if (onlineUser != null) {
            return onlineUser;
        }
        if (!this.db.playerExists(uuid)) {
            return null;
        }
        return this.userCache.computeIfAbsent(uuid, k -> DBUser.fromUUID(uuid));
    }

    public void updateTopPlayersFromDB() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.onlineUsersManager.updateAllOnlineUsersPlaytime().get();
                this.playersHiddenFromLeaderBoard = this.plugin.getConfiguration().getStringList("placeholders.playtime-leaderboard-blacklist");
                Map<String, String> dbTopPlayers = this.db.getTopPlayersByPlaytime(100 + this.playersHiddenFromLeaderBoard.size());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    List<DBUser> validTopPlayers = dbTopPlayers.keySet().stream().map(this::getUserFromUUID).filter(Objects::nonNull).filter(user -> !this.playersHiddenFromLeaderBoard.contains(user.getNickname())).limit(100L).toList();
                    List<DBUser> list = this.topPlayers;
                    synchronized (list) {
                        this.topPlayers.clear();
                        this.topPlayers.addAll(validTopPlayers);
                    }
                });
            }
            catch (InterruptedException | ExecutionException e) {
                this.plugin.getLogger().severe("Error updating top players: " + e.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedTopPlayers(OnlineUser onlineUser) {
        if (this.playersHiddenFromLeaderBoard.contains(onlineUser.getNickname())) {
            return;
        }
        List<DBUser> list = this.topPlayers;
        synchronized (list) {
            if (this.topPlayers.size() < 100 && this.topPlayers.stream().noneMatch(player -> player.getUuid().equals(onlineUser.getUuid()))) {
                this.topPlayers.add(this.getUserFromUUID(onlineUser.getUuid()));
            }
            for (int i = 0; i < this.topPlayers.size(); ++i) {
                if (!this.topPlayers.get(i).getUuid().equals(onlineUser.getUuid())) continue;
                this.topPlayers.set(i, this.getUserFromUUID(onlineUser.getUuid()));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBUser getTopPlayerAtPosition(int position) {
        if (position < 1 || position > this.topPlayers.size()) {
            return null;
        }
        List<DBUser> list = this.topPlayers;
        synchronized (list) {
            List<DBUser> sortedPlayers = this.topPlayers.stream().sorted(Comparator.comparing(DBUser::getPlaytime).reversed()).toList();
            return sortedPlayers.get(position - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBUser> getTopPlayers() {
        List<DBUser> list = this.topPlayers;
        synchronized (list) {
            return this.topPlayers.stream().sorted(Comparator.comparing(DBUser::getPlaytime).reversed()).collect(Collectors.toList());
        }
    }

    public void removeGoalFromAllUsers(String goalName) {
        for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
            user.unmarkGoalAsCompleted(goalName);
        }
        this.db.removeGoalFromAllUsers(goalName);
    }

    public void removeRewardFromAllUsers(String rewardID) {
        for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
            user.wipeReceivedReward(rewardID);
            user.wipeRewardToBeClaimed(rewardID);
        }
        this.db.removeRewardFromAllUsers(rewardID);
    }

    public List<DBUser> getAllDBUsers() {
        return this.db.getAllNicknames().stream().map(this::getUserFromNickname).collect(Collectors.toList());
    }

    public List<String> getPlayersHiddenFromLeaderBoard() {
        return new ArrayList<String>(this.playersHiddenFromLeaderBoard);
    }

    public void hidePlayerFromLeaderBoard(String nickname) {
        this.playersHiddenFromLeaderBoard.add(nickname);
        this.plugin.getConfiguration().set("placeholders.playtime-leaderboard-blacklist", this.playersHiddenFromLeaderBoard);
    }

    public void unhidePlayerFromLeaderBoard(String nickname) {
        this.playersHiddenFromLeaderBoard.remove(nickname);
        this.plugin.getConfiguration().set("placeholders.playtime-leaderboard-blacklist", this.playersHiddenFromLeaderBoard);
    }

    public void removeUserFromCache(String uuid) {
        this.userCache.remove(uuid);
    }

    public void clearCaches() {
        this.userCache.clear();
        this.commandsConfiguration.clearCache();
        this.configuration.clearCache();
        this.guIsConfiguration.clearCache();
    }
}

