/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.text.SimpleDateFormat;
import java.util.Date;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Updates.DatabaseBackupUtility;
import me.thegabro.playtimemanager.Updates.Version304To31Updater;
import me.thegabro.playtimemanager.Updates.Version31to32Updater;
import me.thegabro.playtimemanager.Updates.Version321to33Updater;
import me.thegabro.playtimemanager.Updates.Version332to34Updater;
import me.thegabro.playtimemanager.Updates.Version341to342Updater;
import me.thegabro.playtimemanager.Updates.Version342to35Updater;
import me.thegabro.playtimemanager.Updates.Version34to341Updater;
import me.thegabro.playtimemanager.updatechecker.UpdateCheckSource;
import me.thegabro.playtimemanager.updatechecker.UpdateChecker;
import me.thegabro.playtimemanager.updatechecker.UserAgentBuilder;
import org.bukkit.Bukkit;

public class UpdateManager {
    private static UpdateManager instance;
    private final PlayTimeManager plugin;
    private UpdateChecker updateChecker;
    private final DatabaseBackupUtility backupUtility = DatabaseBackupUtility.getInstance();
    private String plugin_version;

    private UpdateManager(PlayTimeManager plugin) {
        this.plugin = plugin;
    }

    public static UpdateManager getInstance(PlayTimeManager plugin) {
        if (instance == null) {
            instance = new UpdateManager(plugin);
        }
        return instance;
    }

    public void initialize() {
        if (this.plugin.getConfiguration().getBoolean("check-for-updates").booleanValue()) {
            this.setupUpdateChecker();
        } else {
            this.plugin.getLogger().info("Update checking is disabled in configuration.");
        }
        try {
            this.plugin_version = this.plugin.getPluginMeta().getVersion();
        }
        catch (NoSuchMethodError e) {
            this.plugin_version = this.plugin.getDescription().getVersion();
        }
    }

    private void setupUpdateChecker() {
        this.updateChecker = new UpdateChecker(this.plugin, UpdateCheckSource.HANGAR, "TheGaBr0/PlayTimeManager/Release").setUserAgent(new UserAgentBuilder().addPluginNameAndVersion()).checkEveryXHours(24.0).onSuccess((commandSenders, latestVersion) -> {
            this.updateChecker.setDownloadLink("https://modrinth.com/plugin/playtimemanager/version/" + latestVersion);
            this.updateChecker.setChangelogLink("https://modrinth.com/plugin/playtimemanager/version/" + latestVersion);
        }).onFail((commandSenders, exception) -> this.plugin.getLogger().warning("hangar.papermc.io seems offline, update check has failed")).setNotifyOpsOnJoin(true).checkNow();
    }

    public void performVersionUpdate(String currentVersion, String targetVersion) {
        switch (currentVersion) {
            case "3.1": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.1 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.0.4", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version304To31Updater(this.plugin).performUpgrade();
                new Version31to32Updater(this.plugin).performUpgrade();
                new Version321to33Updater(this.plugin).performUpgrade();
                new Version332to34Updater(this.plugin).performUpgrade();
                new Version34to341Updater(this.plugin).performUpgrade();
                new Version341to342Updater(this.plugin).performUpgrade();
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.2": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.2 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.1", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version31to32Updater(this.plugin).performUpgrade();
                new Version321to33Updater(this.plugin).performUpgrade();
                new Version332to34Updater(this.plugin).performUpgrade();
                new Version34to341Updater(this.plugin).performUpgrade();
                new Version341to342Updater(this.plugin).performUpgrade();
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.3": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.3 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.2.1", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version321to33Updater(this.plugin).performUpgrade();
                new Version332to34Updater(this.plugin).performUpgrade();
                new Version34to341Updater(this.plugin).performUpgrade();
                new Version341to342Updater(this.plugin).performUpgrade();
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.4": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.4 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.3.2", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version332to34Updater(this.plugin).performUpgrade();
                new Version34to341Updater(this.plugin).performUpgrade();
                new Version341to342Updater(this.plugin).performUpgrade();
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.5": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.5 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.4", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version34to341Updater(this.plugin).performUpgrade();
                new Version341to342Updater(this.plugin).performUpgrade();
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.6": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.6 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.4.1", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version341to342Updater(this.plugin).performUpgrade();
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.7": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.7 config version detected, starting the update process...");
                this.backupUtility.createBackup(this.generateReadmeContent("3.4.2", this.plugin_version));
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Current configuration backed up successfully");
                new Version342to35Updater(this.plugin).performUpgrade();
                break;
            }
            default: {
                this.plugin.getLogger().severe("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Unknown config version detected! Something may break!");
                return;
            }
        }
        Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Update completed! Latest version: \u00a7r" + targetVersion);
    }

    private String generateReadmeContent(String currentVersion, String nextVersion) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        return "PlayTimeManager Data Folder Backup\n==================================\n\n!!! IMPORTANT VERSION UPGRADE NOTICE !!!\n========================================\nThis backup was automatically created during the upgrade from version " + currentVersion + " to " + nextVersion + ".\nIt contains the entire plugin data folder, including configuration and database files.\nUse this backup to restore the plugin to its previous state in case of issues.\n\nBackup Information:\n-------------------\nBackup created: " + timestamp + "\n\nRestore Instructions:\n---------------------\n!!! CRITICAL: This will revert ALL PlayTimeManager data and config to version " + currentVersion + " !!!\n\nSteps to restore:\n1. Stop your Minecraft server.\n2. Navigate to your server's 'plugins/PlayTimeManager' folder.\n4. Delete the entire contents of the 'PlayTimeManager' folder.\n5. Extract all files from this backup zip into the 'PlayTimeManager' folder.\n6. Start your server.\n\n";
    }
}

