/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Set;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;

public class StreakTracker {
    private final PlayTimeManager plugin;
    private final DBUsersManager dbUsersManager;

    public StreakTracker(PlayTimeManager plugin, DBUsersManager dbUsersManager) {
        this.plugin = plugin;
        this.dbUsersManager = dbUsersManager;
    }

    public void incrementAbsoluteStreak(OnlineUser user) {
        user.incrementAbsoluteJoinStreak();
    }

    public void incrementRelativeStreak(OnlineUser user) {
        user.incrementRelativeJoinStreak();
    }

    public void resetStreaks(OnlineUser user) {
        user.resetJoinStreaks();
    }

    public int resetInactivePlayerStreaks(Set<String> playersWithStreaks, long intervalSeconds, int missesAllowed) {
        int playersReset = 0;
        for (String playerUUID : playersWithStreaks) {
            DBUser user = this.dbUsersManager.getUserFromUUID(playerUUID);
            if (user == null) continue;
            LocalDateTime lastSeen = user.getLastSeen();
            if (lastSeen == null) {
                user.resetJoinStreaks();
                ++playersReset;
                continue;
            }
            long secondsSinceLastSeen = Duration.between(lastSeen, LocalDateTime.now()).getSeconds();
            if (missesAllowed <= 0) {
                missesAllowed = 1;
            }
            if (secondsSinceLastSeen <= intervalSeconds * (long)missesAllowed) continue;
            user.resetJoinStreaks();
            this.restartUserJoinStreakRewards(user);
            ++playersReset;
        }
        return playersReset;
    }

    public void restartUserJoinStreakRewards(DBUser user) {
        Set<String> userRewards = user.getReceivedRewards();
        for (String rewardId : userRewards) {
            user.unreceiveReward(rewardId);
        }
        user.migrateUnclaimedRewards();
        user.resetRelativeJoinStreak();
    }
}

