/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.JoinStreaks.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardMessageService;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RewardExecutor {
    private final PlayTimeManager plugin;
    private final RewardMessageService messageService;

    public RewardExecutor(PlayTimeManager plugin) {
        this.plugin = plugin;
        this.messageService = new RewardMessageService(plugin);
    }

    public void processCompletedReward(Player player, JoinStreakReward reward, String instance) {
        OnlineUser onlineUser = OnlineUsersManager.getInstance().getOnlineUser(player.getName());
        onlineUser.unclaimReward(instance);
        if (instance.endsWith("R")) {
            try {
                String[] parts = instance.split("\\.");
                int instancePart = Integer.parseInt(parts[1]);
                if (onlineUser.getRelativeJoinStreak() >= instancePart) {
                    onlineUser.addReceivedReward(instance.replace(".R", ""));
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {}
        } else {
            onlineUser.addReceivedReward(instance);
        }
        if (this.plugin.isPermissionsManagerConfigured()) {
            this.assignPermissionsForReward(onlineUser, reward);
        }
        this.executeRewardCommands(reward, player);
        this.messageService.sendRewardRelatedMessage(player, instance, reward.getRewardMessage(), 1);
        this.playRewardSound(player, reward);
    }

    private void assignPermissionsForReward(OnlineUser onlineUser, JoinStreakReward reward) {
        ArrayList<String> permissions = reward.getPermissions();
        if (permissions != null && !permissions.isEmpty()) {
            try {
                LuckPermsManager.getInstance(this.plugin).assignRewardPermissions(onlineUser.getUuid(), reward);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Failed to assign permissions for join streak reward %d to player %s: %s", reward.getId(), onlineUser.getNickname(), e.getMessage()));
            }
        }
    }

    private void executeRewardCommands(JoinStreakReward reward, Player player) {
        ArrayList<String> commands = reward.getCommands();
        if (commands != null && !commands.isEmpty()) {
            commands.forEach(command -> {
                try {
                    String formattedCommand = this.formatRewardCommand((String)command, player, reward);
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formattedCommand);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe(String.format("Failed to execute command for join streak reward %d: %s", reward.getId(), e.getMessage()));
                }
            });
        }
    }

    private String formatRewardCommand(String command, Player player, JoinStreakReward reward) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("PLAYER_NAME", player.getName());
        return this.replacePlaceholders(command, replacements).replaceFirst("/", "");
    }

    private void playRewardSound(Player player, JoinStreakReward reward) {
        try {
            Sound sound;
            String soundName;
            block6: {
                soundName = reward.getRewardSound();
                sound = null;
                try {
                    sound = (Sound)Sound.class.getField(soundName).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    if (!this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) break block6;
                    this.plugin.getLogger().info("Could not find sound directly, attempting fallback: " + e.getMessage());
                }
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for reward '%s'", soundName, reward.getId()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for goal '%s': %s", reward.getRewardSound(), reward.getId(), e.getMessage()));
        }
    }

    private String replacePlaceholders(String input, Map<String, String> replacements) {
        String result = input;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

