/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.quartz.CronExpression;

public class CycleScheduler {
    private final PlayTimeManager plugin;
    private CronExpression cronExpression;
    private TimeZone timezone;
    private Date nextIntervalReset;
    private long exactIntervalSeconds;
    private long currentCycleStartTime;
    private BukkitTask intervalTask;
    private final Set<String> playersJoinedDuringCurrentCycle = new HashSet<String>();

    public CycleScheduler(PlayTimeManager plugin) {
        this.plugin = plugin;
        this.currentCycleStartTime = System.currentTimeMillis();
    }

    public void initialize() {
        this.validateConfiguration();
        Date now = new Date();
        Date firstTrigger = this.cronExpression.getNextValidTimeAfter(now);
        Date secondTrigger = this.cronExpression.getNextValidTimeAfter(firstTrigger);
        long intervalMillis = secondTrigger.getTime() - firstTrigger.getTime();
        this.exactIntervalSeconds = intervalMillis / 1000L;
        this.updateIntervalResetTimes();
    }

    private void validateConfiguration() {
        try {
            String cronString = this.plugin.getConfiguration().getString("streak-reset-schedule");
            this.cronExpression = new CronExpression(cronString);
            String timezoneConfig = this.plugin.getConfiguration().getString("reset-schedule-timezone");
            this.timezone = "utc".equalsIgnoreCase(timezoneConfig) ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
            this.cronExpression.setTimeZone(this.timezone);
            if (this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
                this.plugin.getLogger().info("Join streak configuration validated successfully");
                this.plugin.getLogger().info("Using cron schedule: " + cronString);
                this.plugin.getLogger().info("Using timezone: " + this.timezone.getID());
            }
        }
        catch (ParseException e) {
            this.plugin.getLogger().severe("Invalid cron expression in config! Using default: 0 0 0 * * ?");
            try {
                this.cronExpression = new CronExpression("0 0 0 * * ?");
                this.timezone = TimeZone.getDefault();
                this.cronExpression.setTimeZone(this.timezone);
            }
            catch (ParseException ex) {
                this.plugin.getLogger().severe("Critical error initializing cron scheduler: " + ex.getMessage());
            }
        }
    }

    public void updateIntervalResetTimes() {
        Date now = new Date();
        this.nextIntervalReset = this.cronExpression.getNextValidTimeAfter(now);
    }

    public void startIntervalTask() {
        this.updateIntervalResetTimes();
        this.scheduleNextReset();
    }

    private void scheduleNextReset() {
        this.cancelIntervalTask();
        if (JoinStreaksManager.getInstance().getRewardRegistry().isEmpty() && this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
            this.plugin.getLogger().info("No active rewards found, but scheduler will continue running to track absolute join streaks.");
        }
        Date now = new Date();
        if (this.nextIntervalReset.getTime() - now.getTime() < 1000L) {
            this.nextIntervalReset = this.cronExpression.getNextValidTimeAfter(this.nextIntervalReset);
        }
        long delayInMillis = this.nextIntervalReset.getTime() - now.getTime();
        long delayInTicks = Math.max(20L, delayInMillis / 50L);
        if (this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
            this.plugin.getLogger().info("Next join streak interval reset scheduled for: " + String.valueOf(this.nextIntervalReset) + " (in " + Utils.ticksToFormattedPlaytime(delayInTicks) + ")");
        }
        this.intervalTask = new BukkitRunnable(){

            public void run() {
                CycleScheduler.this.playersJoinedDuringCurrentCycle.clear();
                CycleScheduler.this.currentCycleStartTime = System.currentTimeMillis();
                JoinStreaksManager.getInstance().resetMissingPlayerStreaks();
                Date oldNextReset = CycleScheduler.this.nextIntervalReset;
                CycleScheduler.this.updateIntervalResetTimes();
                if (Math.abs(CycleScheduler.this.nextIntervalReset.getTime() - oldNextReset.getTime()) < 1000L) {
                    CycleScheduler.this.nextIntervalReset = CycleScheduler.this.cronExpression.getNextValidTimeAfter(CycleScheduler.this.nextIntervalReset);
                }
                CycleScheduler.this.scheduleNextReset();
            }
        }.runTaskLater((Plugin)this.plugin, delayInTicks);
    }

    public void cancelIntervalTask() {
        if (this.intervalTask != null) {
            this.intervalTask.cancel();
            this.intervalTask = null;
        }
    }

    public boolean isEligibleForStreak(OnlineUser user) {
        if (!this.isCurrentCycle()) {
            this.playersJoinedDuringCurrentCycle.clear();
            this.currentCycleStartTime = System.currentTimeMillis();
        }
        if (this.playersJoinedDuringCurrentCycle.contains(user.getUuid())) {
            return false;
        }
        long secondsBetween = Duration.between(user.getLastSeen(), LocalDateTime.now()).getSeconds();
        return secondsBetween <= this.exactIntervalSeconds * (long)this.plugin.getConfiguration().getInt("reset-joinstreak.missed-joins").intValue();
    }

    public boolean isCurrentCycle() {
        Date now = new Date();
        Date previousReset = this.cronExpression.getTimeAfter(new Date(now.getTime() - this.exactIntervalSeconds * 1000L));
        return now.after(previousReset) && now.before(this.nextIntervalReset);
    }

    public Map<String, Object> getNextSchedule() {
        this.updateIntervalResetTimes();
        HashMap<String, Object> scheduleInfo = new HashMap<String, Object>();
        if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
            scheduleInfo.put("nextReset", this.nextIntervalReset);
            Date now = new Date();
            long delayInMillis = this.nextIntervalReset.getTime() - now.getTime();
            long delayInTicks = Math.max(20L, delayInMillis / 50L);
            scheduleInfo.put("timeRemaining", Utils.ticksToFormattedPlaytime(delayInTicks));
        } else {
            scheduleInfo.put("nextReset", null);
            scheduleInfo.put("timeRemaining", "-");
        }
        return scheduleInfo;
    }

    public void updateOnReload() {
        this.updateIntervalResetTimes();
        if (!this.isCurrentCycle()) {
            this.playersJoinedDuringCurrentCycle.clear();
            this.currentCycleStartTime = System.currentTimeMillis();
        }
        if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
            try {
                Set<String> playersWithStreaks = this.plugin.getDatabase().getPlayersWithActiveStreaks();
                Date cycleStartDate = new Date(this.nextIntervalReset.getTime() - this.exactIntervalSeconds * 1000L);
                for (String playerUUID : playersWithStreaks) {
                    Date lastSeenDate;
                    LocalDateTime lastSeen;
                    DBUser user = DBUsersManager.getInstance().getUserFromUUID(playerUUID);
                    if (user == null || (lastSeen = user.getLastSeen()) == null || !(lastSeenDate = Date.from(lastSeen.atZone(ZoneId.systemDefault()).toInstant())).after(cycleStartDate) || !lastSeenDate.before(this.nextIntervalReset)) continue;
                    this.playersJoinedDuringCurrentCycle.add(playerUUID);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing players during reload: " + e.getMessage());
            }
        }
    }

    public void markPlayerJoinedInCurrentCycle(String uuid) {
        this.playersJoinedDuringCurrentCycle.add(uuid);
    }

    public long getIntervalSeconds() {
        return this.exactIntervalSeconds;
    }

    public void cleanUp() {
        this.cancelIntervalTask();
        this.playersJoinedDuringCurrentCycle.clear();
    }
}

