/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class JoinStreakReward {
    private final PlayTimeManager plugin;
    private final JoinStreaksManager rewardsManager = JoinStreaksManager.getInstance();
    private final int id;
    private int[] requiredJoinsRange;
    private final File rewardFile;
    private ArrayList<String> permissions = new ArrayList();
    private ArrayList<String> commands = new ArrayList();
    private String rewardMessage;
    private String rewardSound;
    private String itemIcon;
    private String description;
    private String rewardDescription;

    public JoinStreakReward(PlayTimeManager plugin, int id, int requiredJoins) {
        this.plugin = plugin;
        this.id = id;
        this.requiredJoinsRange = new int[]{requiredJoins, requiredJoins};
        this.rewardFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Rewards" + File.separator + id + ".yml");
        this.loadFromFile();
        this.saveToFile();
        this.rewardsManager.getRewardRegistry().addReward(this);
    }

    private void loadFromFile() {
        if (this.rewardFile.exists()) {
            String[] parts;
            String rangeStr;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.rewardFile);
            if (config.contains("required-joins-range") && (rangeStr = config.getString("required-joins-range")) != null && rangeStr.contains("-") && (parts = rangeStr.split("-")).length == 2) {
                try {
                    int min = Integer.parseInt(parts[0]);
                    int max = Integer.parseInt(parts[1]);
                    if (min > 0 && max >= min) {
                        this.requiredJoinsRange = new int[]{min, max};
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.rewardMessage = config.getString("reward-message", this.getDefaultRewardMessage());
            this.rewardSound = config.getString("reward-sound", this.getDefaultRewardSound());
            this.description = config.getString("description", "");
            this.rewardDescription = config.getString("reward-description", "");
            this.permissions = new ArrayList(config.getStringList("permissions"));
            this.commands = new ArrayList(config.getStringList("commands"));
            this.itemIcon = config.getString("item-icon", Material.SUNFLOWER.toString());
        } else {
            this.rewardMessage = this.getDefaultRewardMessage();
            this.rewardSound = this.getDefaultRewardSound();
            this.permissions = new ArrayList();
            this.commands = new ArrayList();
            this.description = "";
            this.rewardDescription = "";
            this.itemIcon = Material.SUNFLOWER.toString();
        }
    }

    private void saveToFile() {
        try {
            if (!this.rewardFile.exists()) {
                this.rewardFile.getParentFile().mkdirs();
                this.rewardFile.createNewFile();
            }
            YamlConfiguration config = new YamlConfiguration();
            config.options().setHeader(Arrays.asList("GUIDE OF AVAILABLE OPTIONS:", "---------------------------", "required-joins-range specifies the range of joins for which this reward is active.", "Format: 'min-max' (e.g., '5-10' means the reward is active for 5th through 10th joins)", "For a single join count, use the same number twice (e.g., '5-5' for just the 5th join)", "---------------------------", "reward-sound is played to a player if it reaches the join streak specified in this config.", "A list of available sounds can be found here: https://jd.papermc.io/paper/<VERSION>/org/bukkit/Sound.html", "Replace '<VERSION>' in the link with your current minecraft version.", "---------------------------", "reward-message is showed to a player if it reaches the join streak specified in this config.", "Available placeholders: %REQUIRED_JOINS%, %PLAYER_NAME%", "---------------------------", "description provides a short text description of the reward.", "---------------------------", "reward-description provides detailed information about the reward.", "---------------------------", "item-icon represents the visual representation of the reward in GUI.", "---------------------------", "permissions defines what permissions will be granted to a player when they reach this reward", "You can specify multiple permissions and groups that will all be granted.", "---------------------------", "commands defines a list of commands that will be executed when a player reaches this reward", "Available placeholders: PLAYER_NAME", "Example commands:", "- '/give PLAYER_NAME diamond 64'", "- '/broadcast PLAYER_NAME has reached an amazing join streak!'"));
            config.set("required-joins-range", (Object)(this.requiredJoinsRange[0] + "-" + this.requiredJoinsRange[1]));
            config.set("reward-sound", (Object)this.rewardSound);
            config.set("reward-message", (Object)this.rewardMessage);
            config.set("description", (Object)this.description);
            config.set("reward-description", (Object)this.rewardDescription);
            config.set("permissions", this.permissions);
            config.set("commands", this.commands);
            config.set("item-icon", (Object)this.itemIcon);
            config.save(this.rewardFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save reward file for " + this.id + ": " + e.getMessage());
        }
    }

    private String getDefaultRewardSound() {
        return "ENTITY_PLAYER_LEVELUP";
    }

    private String getDefaultRewardMessage() {
        return this.plugin.getConfiguration().getString("prefix") + " Congratulations &e%PLAYER_NAME%&7, you have redeemed your reward successfully!";
    }

    public ItemStack getDefaultIcon() {
        return new ItemStack(Material.SUNFLOWER);
    }

    public int getId() {
        return this.id;
    }

    public int[] getRequiredJoinsRange() {
        return this.requiredJoinsRange;
    }

    public int getMinRequiredJoins() {
        return this.requiredJoinsRange[0];
    }

    public int getMaxRequiredJoins() {
        return this.requiredJoinsRange[1];
    }

    public boolean isSingleJoinReward() {
        return this.requiredJoinsRange[0] == this.requiredJoinsRange[1];
    }

    public String getRequiredJoinsDisplay() {
        if (this.isSingleJoinReward()) {
            return String.valueOf(this.requiredJoinsRange[0]);
        }
        return this.requiredJoinsRange[0] + "-" + this.requiredJoinsRange[1];
    }

    public String getRewardMessage() {
        return this.rewardMessage;
    }

    public String getRewardSound() {
        return this.rewardSound;
    }

    public ArrayList<String> getCommands() {
        return this.commands;
    }

    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public void setRequiredJoinsRange(int minJoins, int maxJoins) {
        if (maxJoins < minJoins) {
            maxJoins = minJoins;
        }
        this.requiredJoinsRange = new int[]{minJoins, maxJoins};
        this.saveToFile();
    }

    public boolean setRequiredJoinsFromString(String rangeStr) {
        if (rangeStr == null || rangeStr.isEmpty()) {
            return false;
        }
        if (rangeStr.equals("-1")) {
            this.setRequiredJoinsRange(-1, -1);
            return true;
        }
        if (rangeStr.contains("-")) {
            String[] parts = rangeStr.split("-");
            if (parts.length == 2) {
                try {
                    int min = Integer.parseInt(parts[0].trim());
                    int max = Integer.parseInt(parts[1].trim());
                    if (min <= 0 || max < min) {
                        return false;
                    }
                    this.setRequiredJoinsRange(min, max);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
        try {
            int value = Integer.parseInt(rangeStr.trim());
            if (value <= 0) {
                return false;
            }
            this.setRequiredJoinsRange(value, value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void setRewardMessage(String rewardMessage) {
        this.rewardMessage = rewardMessage;
        this.saveToFile();
    }

    public void setRewardSound(String rewardSound) {
        this.rewardSound = rewardSound;
        this.saveToFile();
    }

    public void addCommand(String command) {
        this.commands.add(command);
        this.saveToFile();
    }

    public void removeCommand(String command) {
        this.commands.remove(command);
        this.saveToFile();
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
        this.saveToFile();
    }

    public void removePermission(String permission) {
        this.permissions.remove(permission);
        this.saveToFile();
    }

    public String getItemIcon() {
        return this.itemIcon;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRewardDescription() {
        return this.rewardDescription;
    }

    public void setItemIcon(String itemIcon) {
        this.itemIcon = itemIcon;
        this.saveToFile();
    }

    public void setDescription(String description) {
        this.description = description;
        this.saveToFile();
    }

    public void setRewardDescription(String rewardDescription) {
        this.rewardDescription = rewardDescription;
        this.saveToFile();
    }

    public void kill() {
        this.rewardsManager.getRewardRegistry().removeReward(this);
        DBUsersManager.getInstance().removeRewardFromAllUsers(String.valueOf(this.id));
        this.deleteFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinStreakReward reward = (JoinStreakReward)o;
        return Objects.equals(this.id, reward.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void deleteFile() {
        if (this.rewardFile.exists() && !this.rewardFile.delete()) {
            this.plugin.getLogger().warning("Failed to delete reward file for " + this.id);
        }
    }

    public String toString() {
        return "JoinStreakReward{id='" + this.id + "', requiredJoins=" + this.getRequiredJoinsDisplay() + ", permissions=" + this.permissions.size() + ", commands=" + this.commands.size() + ", message='" + this.rewardMessage + "', sound='" + this.rewardSound + "', description='" + this.description + "', rewardDescription='" + this.rewardDescription + "', hasItemIcon=" + (this.itemIcon != null) + "}";
    }
}

