/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.util.ArrayList;
import java.util.List;
import me.thegabro.playtimemanager.ExternalPluginSupport.PlaceHolders.PlaceholderConditionEvaluator;
import org.bukkit.entity.Player;

public class GoalRewardRequirement {
    private List<String> permissions;
    private List<String> placeholderConditions;
    private long time;
    private PlaceholderConditionEvaluator placeholderConditionEvaluator = PlaceholderConditionEvaluator.getInstance();

    public GoalRewardRequirement() {
        this.permissions = new ArrayList<String>();
        this.placeholderConditions = new ArrayList<String>();
        this.time = Long.MAX_VALUE;
    }

    public boolean checkRequirements(Player player, long playerTime) {
        if (this.time != Long.MAX_VALUE && playerTime < this.time) {
            return false;
        }
        for (String permission : this.permissions) {
            if (player.hasPermission(permission)) continue;
            return false;
        }
        for (String condition : this.placeholderConditions) {
            if (this.placeholderConditionEvaluator.evaluate(player, condition)) continue;
            return false;
        }
        return true;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    public void removePermission(String permission) {
        this.permissions.remove(permission);
    }

    public List<String> getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    public void setPlaceholderConditions(List<String> placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }

    public void addPlaceholderCondition(String condition) {
        this.placeholderConditions.add(condition);
    }

    public void removePlaceholderCondition(String condition) {
        this.placeholderConditions.remove(condition);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }
}

