/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.thegabro.playtimemanager.Goals.GoalRewardRequirement;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class Goal {
    private final PlayTimeManager plugin;
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private String name;
    private final File goalFile;
    private GoalRewardRequirement requirements;
    private ArrayList<String> rewardPermissions = new ArrayList();
    private ArrayList<String> rewardCommands = new ArrayList();
    private String goalMessage;
    private String goalSound;
    private boolean active;

    public Goal(PlayTimeManager plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        this.goalFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Goals" + File.separator + name + ".yml");
        this.requirements = new GoalRewardRequirement();
        this.loadFromFile();
        this.goalsManager.addGoal(this);
    }

    public Goal(PlayTimeManager plugin, String name, boolean active) {
        this.plugin = plugin;
        this.name = name;
        this.goalFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Goals" + File.separator + name + ".yml");
        this.requirements = new GoalRewardRequirement();
        this.loadFromFile();
        this.active = active;
        this.saveToFile();
        this.goalsManager.addGoal(this);
    }

    private void loadFromFile() {
        if (this.goalFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.goalFile);
            this.requirements.setTime(config.getLong("requirements.time", Long.MAX_VALUE));
            this.requirements.setPermissions(new ArrayList<String>(config.getStringList("requirements.permissions")));
            this.requirements.setPlaceholderConditions(new ArrayList<String>(config.getStringList("requirements.placeholders")));
            this.goalMessage = config.getString("goal-message", this.getDefaultGoalMessage());
            this.goalSound = config.getString("goal-sound", this.getDefaultGoalSound());
            this.rewardPermissions = new ArrayList(config.getStringList("rewards.permissions"));
            this.rewardCommands = new ArrayList(config.getStringList("rewards.commands"));
            this.active = config.getBoolean("active", false);
        } else {
            this.goalMessage = this.getDefaultGoalMessage();
            this.goalSound = this.getDefaultGoalSound();
            this.rewardPermissions = new ArrayList();
            this.rewardCommands = new ArrayList();
        }
    }

    private void saveToFile() {
        try {
            if (!this.goalFile.exists()) {
                this.goalFile.getParentFile().mkdirs();
                this.goalFile.createNewFile();
            }
            YamlConfiguration config = new YamlConfiguration();
            config.options().setHeader(Arrays.asList("GUIDE OF AVAILABLE OPTIONS:", "---------------------------", "goal-sound is played to a player if it reaches the time specified in this config.", "A list of available sounds can be found here: https://jd.papermc.io/paper/<VERSION>/org/bukkit/Sound.html", "Replace '<VERSION>' in the link with your current minecraft version. If it doesn't work try with the ", "latest update of your version (e.g. '1.19' doesn't work and you need to use '1.19.4')", "---------------------------", "goal-message is showed to a player if it reaches the time specified in this config.", "Available placeholders: %TIME_REQUIRED%, %PLAYER_NAME%. %GOAL_NAME%", "---------------------------", "active determines whether this goal is enabled and being checked by the plugin", "Set to 'true' to enable the goal and track player progress", "Set to 'false' (default option) to disable the goal without deleting it", "This is useful for:", "* Temporarily disabling goals without removing them", "* Testing new goals before making them live", "* Managing seasonal or event-specific goals", "---------------------------", "requirements:", "  time: Required playtime (in seconds) for the goal to be completed", "   - Note: if time isn't set, it defaults to a very long number, it is intended!", "  permissions: List of permissions that the player must have to complete this goal", "  placeholders: List of placeholder conditions that must be met to complete this goal", "---------------------------", "reward:", "  permissions: Permissions that will be granted to a player when they reach this goal", "  commands: List of commands that will be executed when a player reaches this goal", "  Available placeholders in commands: PLAYER_NAME"));
            config.set("active", (Object)this.active);
            config.set("goal-sound", (Object)this.goalSound);
            config.set("goal-message", (Object)this.goalMessage);
            config.set("requirements.time", (Object)this.requirements.getTime());
            config.set("requirements.permissions", this.requirements.getPermissions());
            config.set("requirements.placeholders", this.requirements.getPlaceholderConditions());
            config.set("rewards.permissions", this.rewardPermissions);
            config.set("rewards.commands", this.rewardCommands);
            config.save(this.goalFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save goal file for " + this.name + ": " + e.getMessage());
        }
    }

    public void deleteFile() {
        if (this.goalFile.exists() && !this.goalFile.delete()) {
            this.plugin.getLogger().warning("Failed to delete goal file for " + this.name);
        }
    }

    private String getDefaultGoalSound() {
        return "ENTITY_PLAYER_LEVELUP";
    }

    private String getDefaultGoalMessage() {
        return "[&6PlayTime&eManager&f]&7 Congratulations &e%PLAYER_NAME%&7 you have completed a new goal!";
    }

    public String getName() {
        return this.name;
    }

    public GoalRewardRequirement getRequirements() {
        return this.requirements;
    }

    public String getGoalMessage() {
        return this.goalMessage;
    }

    public String getGoalSound() {
        return this.goalSound;
    }

    public boolean isActive() {
        return this.active;
    }

    public ArrayList<String> getRewardCommands() {
        return this.rewardCommands;
    }

    public ArrayList<String> getRewardPermissions() {
        return this.rewardPermissions;
    }

    public void rename(String newName) {
        File oldFile = this.goalFile;
        for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
            user.unmarkGoalAsCompleted(this.name);
            user.markGoalAsCompleted(newName);
        }
        this.name = newName;
        File newFile = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "Goals" + File.separator + newName + ".yml");
        try {
            if (!newFile.getParentFile().exists()) {
                newFile.getParentFile().mkdirs();
            }
            if (oldFile.exists() && !oldFile.renameTo(newFile)) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)oldFile);
                config.save(newFile);
                oldFile.delete();
            }
            this.saveToFile();
            this.plugin.getDatabase().updateGoalName(oldFile.getName().replace(".yml", ""), newName);
            oldFile.delete();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not rename goal file from " + oldFile.getName() + " to " + newFile.getName() + ": " + e.getMessage());
        }
    }

    public void setTime(long time) {
        this.requirements.setTime(time);
        this.saveToFile();
    }

    public void setGoalMessage(String goalMessage) {
        this.goalMessage = goalMessage;
        this.saveToFile();
    }

    public void setGoalSound(String goalSound) {
        this.goalSound = goalSound;
        this.saveToFile();
    }

    public void setActivation(boolean activation) {
        this.active = activation;
        this.saveToFile();
    }

    public void addCommand(String command) {
        this.rewardCommands.add(command);
        this.saveToFile();
    }

    public void removeCommand(String command) {
        this.rewardCommands.remove(command);
        this.saveToFile();
    }

    public void addPermission(String permission) {
        this.rewardPermissions.add(permission);
        this.saveToFile();
    }

    public void removePermission(String permission) {
        this.rewardPermissions.remove(permission);
        this.saveToFile();
    }

    public void addRequirementPermission(String permission) {
        this.requirements.addPermission(permission);
        this.saveToFile();
    }

    public void removeRequirementPermission(String permission) {
        this.requirements.removePermission(permission);
        this.saveToFile();
    }

    public void addPlaceholderCondition(String condition) {
        this.requirements.addPlaceholderCondition(condition);
        this.saveToFile();
    }

    public void removePlaceholderCondition(String condition) {
        this.requirements.removePlaceholderCondition(condition);
        this.saveToFile();
    }

    public void clearPlaceholderConditions() {
        this.getRequirements().getPlaceholderConditions().clear();
        this.saveToFile();
    }

    public void clearRequirementPermissions() {
        this.getRequirements().getPermissions().clear();
        this.saveToFile();
    }

    public void kill() {
        this.goalsManager.removeGoal(this);
        DBUsersManager.getInstance().removeGoalFromAllUsers(this.name);
        this.deleteFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Goal goal = (Goal)o;
        return Objects.equals(this.name, goal.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Goal{name='" + this.name + "', time=" + this.requirements.getTime() + ", active=" + this.active + ", requirementPermissions=" + this.requirements.getPermissions().size() + ", placeholderConditions=" + this.requirements.getPlaceholderConditions().size() + ", rewardPermissions=" + this.rewardPermissions.size() + ", commands=" + this.rewardCommands.size() + ", message='" + this.goalMessage + "', sound='" + this.goalSound + "'}";
    }
}

