/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.JoinStreak;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.GUIs.JoinStreak.InventoryListener;
import me.thegabro.playtimemanager.JoinStreaks.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RewardsInfoGui
implements InventoryHolder,
Listener {
    private Inventory inv;
    private final ArrayList<Integer> protectedSlots = new ArrayList();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final JoinStreaksManager rewardsManager = JoinStreaksManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final GUIsConfiguration config;
    private Player sender;
    private boolean isOwner;
    private DBUser subject;
    private int currentPage = 0;
    private final List<RewardDisplayItem> allDisplayItems = new ArrayList<RewardDisplayItem>();
    private final List<RewardDisplayItem> filteredDisplayItems = new ArrayList<RewardDisplayItem>();
    private final int REWARDS_PER_PAGE = 28;
    private final int NEXT_BUTTON_SLOT = 50;
    private final int PREV_BUTTON_SLOT = 48;
    private final int PAGE_INDICATOR_SLOT = 49;
    private final int SHOW_CLAIMED_BUTTON_SLOT = 3;
    private final int SHOW_AVAILABLE_BUTTON_SLOT = 4;
    private final int SHOW_LOCKED_BUTTON_SLOT = 5;
    private final int CLAIM_ALL_BUTTON_SLOT = 46;
    private FilterType currentFilter = FilterType.AVAILABLE;
    protected static boolean isListenerRegistered = false;
    protected static final Map<UUID, RewardsInfoGui> activeGuis = new HashMap<UUID, RewardsInfoGui>();
    private final String sessionToken;

    public RewardsInfoGui(Player sender, DBUser subject, String sessionToken) {
        this.sender = sender;
        this.sessionToken = sessionToken;
        this.config = GUIsConfiguration.getInstance();
        this.subject = subject;
        this.isOwner = sender.getName().equalsIgnoreCase(subject.getNickname());
        this.inv = this.isOwner ? Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors(this.config.getString("rewards-gui.gui.title"))) : Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors(subject.getNickname() + "'s rewards"));
        if (!isListenerRegistered) {
            Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)PlayTimeManager.getInstance());
            isListenerRegistered = true;
        }
    }

    public void openInventory() {
        this.currentPage = 0;
        this.loadRewards();
        this.applyFilters();
        this.initializeItems();
        activeGuis.put(this.sender.getUniqueId(), this);
        this.sender.openInventory(this.inv);
    }

    public void changePage(int page) {
        this.currentPage = page;
        this.initializeItems();
        this.sender.updateInventory();
    }

    private void applyFilters() {
        this.filteredDisplayItems.clear();
        for (RewardDisplayItem item : this.allDisplayItems) {
            switch (item.getStatus().ordinal()) {
                case 3: {
                    if (this.currentFilter != FilterType.CLAIMED) break;
                    this.filteredDisplayItems.add(item);
                    break;
                }
                case 0: 
                case 1: {
                    if (this.currentFilter != FilterType.AVAILABLE) break;
                    this.filteredDisplayItems.add(item);
                    break;
                }
                case 2: {
                    if (this.currentFilter != FilterType.LOCKED) break;
                    this.filteredDisplayItems.add(item);
                }
            }
        }
    }

    private void loadRewards() {
        this.allDisplayItems.clear();
        Map<Integer, LinkedHashSet<String>> joinRewardsMap = this.rewardsManager.getRewardRegistry().getJoinRewardsMap();
        Set<String> rewardsReceived = this.subject.getReceivedRewards();
        Set<String> rewardsToBeClaimed = this.subject.getRewardsToBeClaimed();
        for (Map.Entry<Integer, LinkedHashSet<String>> entry : joinRewardsMap.entrySet()) {
            Integer rewardId = entry.getKey();
            LinkedHashSet<String> instances = entry.getValue();
            JoinStreakReward reward = this.rewardsManager.getRewardRegistry().getMainInstance(String.valueOf(rewardId));
            if (reward == null) continue;
            for (String instance : instances) {
                RewardStatus status = rewardsReceived.contains(instance) ? RewardStatus.CLAIMED : (rewardsToBeClaimed.contains(instance) ? RewardStatus.AVAILABLE : RewardStatus.LOCKED);
                int specificJoinCount = this.calculateSpecificJoinCount(reward, instance);
                this.allDisplayItems.add(new RewardDisplayItem(reward, instance, status, specificJoinCount));
            }
        }
        for (String instance : this.subject.getRewardsToBeClaimed()) {
            JoinStreakReward reward;
            if (!instance.endsWith("R") || (reward = this.rewardsManager.getRewardRegistry().getMainInstance(instance)) == null) continue;
            RewardStatus status = RewardStatus.AVAILABLE_OLD;
            int specificJoinCount = this.calculateSpecificJoinCount(reward, instance.replace(".R", ""));
            this.allDisplayItems.add(new RewardDisplayItem(reward, instance, status, specificJoinCount));
        }
        Collections.sort(this.allDisplayItems);
    }

    public void initializeItems() {
        int totalPages;
        int leftIndex = 9;
        int rightIndex = 17;
        this.protectedSlots.clear();
        this.inv.clear();
        for (int i = 0; i < 54; ++i) {
            if (i > 9 && i < 45 && i != leftIndex && i != rightIndex) continue;
            this.inv.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Utils.parseColors(this.config.getString("rewards-gui.gui.border-item-name")), new Component[0]));
            this.protectedSlots.add(i);
            if (i == leftIndex) {
                leftIndex += 9;
            }
            if (i != rightIndex) continue;
            rightIndex += 9;
        }
        this.createFilterButtons();
        if (this.isOwner) {
            this.inv.setItem(46, this.createGuiItem(Material.CHEST, Utils.parseColors(this.config.getString("rewards-gui.claim-all.name")), new Component[0]));
            this.protectedSlots.add(46);
        }
        if ((totalPages = (int)Math.ceil((double)this.filteredDisplayItems.size() / 28.0)) > 1) {
            String pageIndicator = this.config.getString("rewards-gui.pagination.page-indicator").replace("{current_page}", String.valueOf(this.currentPage + 1)).replace("{total_pages}", String.valueOf(totalPages));
            this.inv.setItem(49, this.createGuiItem(Material.PAPER, Utils.parseColors(pageIndicator), new Component[0]));
            this.protectedSlots.add(49);
            if (this.currentPage < totalPages - 1) {
                this.inv.setItem(50, this.createGuiItem(Material.ARROW, Utils.parseColors(this.config.getString("rewards-gui.pagination.next-page.name")), Utils.parseColors(this.config.getString("rewards-gui.pagination.next-page.lore"))));
            } else {
                this.inv.setItem(50, this.createGuiItem(Material.BARRIER, Utils.parseColors(this.config.getString("rewards-gui.pagination.no-more-pages")), new Component[0]));
            }
            this.protectedSlots.add(50);
            if (this.currentPage > 0) {
                this.inv.setItem(48, this.createGuiItem(Material.ARROW, Utils.parseColors(this.config.getString("rewards-gui.pagination.prev-page.name")), Utils.parseColors(this.config.getString("rewards-gui.pagination.prev-page.lore"))));
            } else {
                this.inv.setItem(48, this.createGuiItem(Material.BARRIER, Utils.parseColors(this.config.getString("rewards-gui.pagination.first-page")), new Component[0]));
            }
            this.protectedSlots.add(48);
        }
        if (!this.filteredDisplayItems.isEmpty()) {
            int startIndex = this.currentPage * 28;
            int endIndex = Math.min(startIndex + 28, this.filteredDisplayItems.size());
            List<RewardDisplayItem> currentPageRewards = this.filteredDisplayItems.subList(startIndex, endIndex);
            int slot = 10;
            for (RewardDisplayItem displayItem : currentPageRewards) {
                while (this.protectedSlots.contains(slot)) {
                    ++slot;
                }
                if (slot < 45) {
                    String[] descriptionLines;
                    String statusPrefix;
                    Material material;
                    JoinStreakReward reward = displayItem.getReward();
                    String instance = displayItem.getInstance();
                    ArrayList<Component> lore = new ArrayList<Component>();
                    String rewardType = switch (displayItem.getStatus().ordinal()) {
                        case 0, 1 -> {
                            material = Material.valueOf((String)reward.getItemIcon());
                            statusPrefix = this.config.getString("rewards-gui.reward-items.available.prefix");
                            for (String loreLine : this.config.getStringList("rewards-gui.reward-items.available.lore")) {
                                lore.add(Utils.parseColors(loreLine));
                            }
                            yield "CLAIMABLE";
                        }
                        case 3 -> {
                            material = Material.valueOf((String)reward.getItemIcon());
                            statusPrefix = this.config.getString("rewards-gui.reward-items.claimed.prefix");
                            for (String loreLine : this.config.getStringList("rewards-gui.reward-items.claimed.lore")) {
                                lore.add(Utils.parseColors(loreLine));
                            }
                            yield "CLAIMED";
                        }
                        default -> {
                            material = Material.valueOf((String)reward.getItemIcon());
                            statusPrefix = this.config.getString("rewards-gui.reward-items.locked.prefix");
                            for (String loreLine : this.config.getStringList("rewards-gui.reward-items.locked.lore")) {
                                lore.add(Utils.parseColors(loreLine));
                            }
                            yield "LOCKED";
                        }
                    };
                    int specificJoinCount = displayItem.getSpecificJoinCount();
                    String requiredJoins = this.config.getString("rewards-gui.reward-items.info-lore.required-joins").replace("{required_joins}", specificJoinCount == -1 ? "-" : String.valueOf(specificJoinCount));
                    lore.add(Utils.parseColors(requiredJoins));
                    if (displayItem.getStatus() != RewardStatus.AVAILABLE_OLD && displayItem.getStatus() != RewardStatus.AVAILABLE) {
                        int currentStreak = this.subject.getRelativeJoinStreak();
                        String streakColor = currentStreak < specificJoinCount ? this.config.getString("rewards-gui.reward-items.info-lore.join-streak-color.insufficient") : this.config.getString("rewards-gui.reward-items.info-lore.join-streak-color.sufficient");
                        String string = this.config.getString("rewards-gui.reward-items.info-lore.join-streak").replace("{color}", streakColor).replace("{current_streak}", String.valueOf(currentStreak));
                        lore.add(Utils.parseColors(string));
                    }
                    if (!reward.getDescription().isEmpty()) {
                        lore.add(Utils.parseColors(this.config.getString("rewards-gui.reward-items.info-lore.description-separator")));
                        String descriptionTemplate = this.config.getString("rewards-gui.reward-items.info-lore.description");
                        for (String line : descriptionLines = reward.getDescription().split("/n")) {
                            lore.add(Utils.parseColors(descriptionTemplate.replace("{description}", line)));
                        }
                    }
                    if (!reward.getRewardDescription().isEmpty()) {
                        lore.add(Utils.parseColors(this.config.getString("rewards-gui.reward-items.info-lore.reward-description-separator")));
                        String descriptionTemplate = this.config.getString("rewards-gui.reward-items.info-lore.reward-description");
                        for (String line : descriptionLines = reward.getRewardDescription().split("/n")) {
                            lore.add(Utils.parseColors(descriptionTemplate.replace("{reward_description}", line)));
                        }
                    }
                    ItemStack item = new ItemStack(material);
                    ItemMeta meta = item.getItemMeta();
                    meta.displayName(Utils.parseColors(statusPrefix));
                    meta.lore(lore);
                    NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, "reward_id");
                    NamespacedKey typeKey = new NamespacedKey((Plugin)this.plugin, "reward_type");
                    meta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.STRING, (Object)instance);
                    meta.getPersistentDataContainer().set(typeKey, PersistentDataType.STRING, (Object)rewardType);
                    item.setItemMeta(meta);
                    this.inv.setItem(slot, this.createRewardItem(material, statusPrefix, lore, meta.getPersistentDataContainer()));
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            this.inv.setItem(22, this.createGuiItem(Material.BARRIER, Utils.parseColors(this.config.getString("rewards-gui.no-rewards.name")), Utils.parseColors(this.config.getString("rewards-gui.no-rewards.lore"))));
        }
    }

    private void createFilterButtons() {
        Material claimedMaterial = this.currentFilter == FilterType.CLAIMED ? Material.LIME_DYE : Material.GRAY_DYE;
        String claimedName = this.currentFilter == FilterType.CLAIMED ? this.config.getString("rewards-gui.filters.claimed.enabled-name") : this.config.getString("rewards-gui.filters.claimed.disabled-name");
        String claimedLore = this.currentFilter == FilterType.CLAIMED ? this.config.getString("rewards-gui.filters.claimed.lore-enabled") : this.config.getString("rewards-gui.filters.claimed.lore-disabled");
        this.inv.setItem(3, this.createGuiItem(claimedMaterial, Utils.parseColors(claimedName), Utils.parseColors(claimedLore)));
        this.protectedSlots.add(3);
        Material availableMaterial = this.currentFilter == FilterType.AVAILABLE ? Material.LIME_DYE : Material.GRAY_DYE;
        String availableName = this.currentFilter == FilterType.AVAILABLE ? this.config.getString("rewards-gui.filters.available.enabled-name") : this.config.getString("rewards-gui.filters.available.disabled-name");
        String availableLore = this.currentFilter == FilterType.AVAILABLE ? this.config.getString("rewards-gui.filters.available.lore-enabled") : this.config.getString("rewards-gui.filters.available.lore-disabled");
        this.inv.setItem(4, this.createGuiItem(availableMaterial, Utils.parseColors(availableName), Utils.parseColors(availableLore)));
        this.protectedSlots.add(4);
        Material lockedMaterial = this.currentFilter == FilterType.LOCKED ? Material.LIME_DYE : Material.GRAY_DYE;
        String lockedName = this.currentFilter == FilterType.LOCKED ? this.config.getString("rewards-gui.filters.locked.enabled-name") : this.config.getString("rewards-gui.filters.locked.disabled-name");
        String lockedLore = this.currentFilter == FilterType.LOCKED ? this.config.getString("rewards-gui.filters.locked.lore-enabled") : this.config.getString("rewards-gui.filters.locked.lore-disabled");
        this.inv.setItem(5, this.createGuiItem(lockedMaterial, Utils.parseColors(lockedName), Utils.parseColors(lockedLore)));
        this.protectedSlots.add(5);
    }

    private int calculateSpecificJoinCount(JoinStreakReward reward, String instance) {
        int min = reward.getMinRequiredJoins();
        int max = reward.getMaxRequiredJoins();
        if (min == -1) {
            return -1;
        }
        if (min == max) {
            return min;
        }
        Map<Integer, LinkedHashSet<String>> joinRewardsMap = this.rewardsManager.getRewardRegistry().getJoinRewardsMap();
        LinkedHashSet<String> instances = joinRewardsMap.get(reward.getId());
        if (instances == null || instances.isEmpty()) {
            return min;
        }
        ArrayList<String> sortedInstances = new ArrayList<String>(instances);
        Collections.sort(sortedInstances, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                try {
                    String[] aParts = a.split("\\.");
                    String[] bParts = b.split("\\.");
                    int aIntPart = Integer.parseInt(aParts[0]);
                    int bIntPart = Integer.parseInt(bParts[0]);
                    if (aIntPart != bIntPart) {
                        return Integer.compare(aIntPart, bIntPart);
                    }
                    int aDecimalPart = Integer.parseInt(aParts[1]);
                    int bDecimalPart = Integer.parseInt(bParts[1]);
                    return Integer.compare(aDecimalPart, bDecimalPart);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    return a.compareTo(b);
                }
            }
        });
        int index = sortedInstances.indexOf(instance);
        if (index == -1) {
            return min;
        }
        return min + index;
    }

    private ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createRewardItem(Material material, String name, List<Component> lore, PersistentDataContainer originalContainer) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Utils.parseColors(name).decoration(TextDecoration.ITALIC, false));
        ArrayList<Component> metalore = new ArrayList<Component>();
        for (Component loreLine : lore) {
            metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
        }
        if (originalContainer != null) {
            for (NamespacedKey key : originalContainer.getKeys()) {
                if (!originalContainer.has(key, PersistentDataType.STRING)) continue;
                String value = (String)originalContainer.get(key, PersistentDataType.STRING);
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)value);
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, @NotNull InventoryAction action, @NotNull InventoryClickEvent event) {
        NamespacedKey typeKey;
        PersistentDataContainer container;
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        if (slot == 3) {
            this.currentFilter = FilterType.CLAIMED;
            this.currentPage = 0;
            this.applyFilters();
            this.initializeItems();
            return;
        }
        if (slot == 4) {
            this.currentFilter = FilterType.AVAILABLE;
            this.currentPage = 0;
            this.applyFilters();
            this.initializeItems();
            return;
        }
        if (slot == 5) {
            this.currentFilter = FilterType.LOCKED;
            this.currentPage = 0;
            this.applyFilters();
            this.initializeItems();
            return;
        }
        if (slot == 46 && this.isOwner) {
            this.claimAllRewards();
            return;
        }
        if (slot == 50 && clickedItem.getType() == Material.ARROW) {
            this.changePage(this.currentPage + 1);
            return;
        }
        if (slot == 48 && clickedItem.getType() == Material.ARROW) {
            this.changePage(this.currentPage - 1);
            return;
        }
        if (clickedItem.getItemMeta().hasDisplayName() && this.isOwner && (container = clickedItem.getItemMeta().getPersistentDataContainer()).has(typeKey = new NamespacedKey((Plugin)this.plugin, "reward_type"), PersistentDataType.STRING) && ((String)container.get(typeKey, PersistentDataType.STRING)).equals("CLAIMABLE")) {
            NamespacedKey idKey = new NamespacedKey((Plugin)this.plugin, "reward_id");
            if (container.has(idKey, PersistentDataType.STRING)) {
                String instance = (String)container.get(idKey, PersistentDataType.STRING);
                this.claimReward(instance);
            } else {
                whoClicked.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.not-available")));
                whoClicked.playSound(whoClicked.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            }
        }
    }

    private void claimReward(String instance) {
        if (!this.plugin.getSessionManager().validateSession(this.sender.getUniqueId(), this.sessionToken)) {
            this.plugin.getLogger().warning("Player " + this.sender.getName() + " attempted GUI action with invalid session token!");
            this.sender.closeInventory();
            return;
        }
        if (!this.sender.hasPermission("playtime.joinstreak.claim")) {
            this.sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.no-permission")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        JoinStreakReward reward = this.rewardsManager.getRewardRegistry().getMainInstance(instance);
        if (reward == null) {
            this.sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.reward-not-found")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        try {
            this.rewardsManager.getRewardExecutor().processCompletedReward(this.sender, reward, instance);
            this.loadRewards();
            this.applyFilters();
            this.initializeItems();
            this.sender.updateInventory();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error processing reward for player " + this.sender.getName() + ": " + e.getMessage());
            e.printStackTrace();
            this.sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.error-processing")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
    }

    private void claimAllRewards() {
        if (!this.plugin.getSessionManager().validateSession(this.sender.getUniqueId(), this.sessionToken)) {
            this.plugin.getLogger().warning("Player " + this.sender.getName() + " attempted GUI action with invalid session token!");
            this.sender.closeInventory();
            return;
        }
        if (!this.sender.hasPermission("playtime.joinstreak.claim")) {
            this.sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.no-permission")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        HashSet<String> claimableRewards = new HashSet<String>(this.subject.getRewardsToBeClaimed());
        if (claimableRewards.isEmpty()) {
            return;
        }
        int claimedCount = 0;
        for (String instance : claimableRewards) {
            JoinStreakReward reward = this.rewardsManager.getRewardRegistry().getMainInstance(instance);
            if (reward == null) continue;
            try {
                this.rewardsManager.getRewardExecutor().processCompletedReward(this.sender, reward, instance);
                ++claimedCount;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing reward for player " + this.sender.getName() + ": " + e.getMessage());
            }
        }
        if (claimedCount > 0) {
            this.sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.claimed-rewards").replace("{count}", String.valueOf(claimedCount))));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            this.loadRewards();
            this.applyFilters();
            this.initializeItems();
        } else {
            this.sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " " + this.config.getString("rewards-gui.messages.error-processing")));
            this.sender.playSound(this.sender.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
        }
    }

    private static enum FilterType {
        CLAIMED,
        AVAILABLE,
        LOCKED;

    }

    public static class RewardDisplayItem
    implements Comparable<RewardDisplayItem> {
        private final JoinStreakReward reward;
        private final String instance;
        private final RewardStatus status;
        private final int specificJoinCount;
        private final int instanceNumber;
        private final int subInstanceNumber;

        public RewardDisplayItem(JoinStreakReward reward, String instance, RewardStatus status, int specificJoinCount) {
            int subInstanceNumber1;
            int instanceNumber1;
            this.reward = reward;
            this.instance = instance;
            this.status = status;
            this.specificJoinCount = specificJoinCount;
            String[] parts = instance.split("\\.");
            if (parts.length >= 2) {
                try {
                    instanceNumber1 = Integer.parseInt(parts[0]);
                    subInstanceNumber1 = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    instanceNumber1 = 0;
                    subInstanceNumber1 = 0;
                }
            } else {
                instanceNumber1 = 0;
                subInstanceNumber1 = 0;
            }
            this.subInstanceNumber = subInstanceNumber1;
            this.instanceNumber = instanceNumber1;
        }

        public JoinStreakReward getReward() {
            return this.reward;
        }

        public String getInstance() {
            return this.instance;
        }

        public RewardStatus getStatus() {
            return this.status;
        }

        public int getSpecificJoinCount() {
            return this.specificJoinCount;
        }

        @Override
        public int compareTo(RewardDisplayItem other) {
            if (this.status != other.status) {
                return this.status.ordinal() - other.status.ordinal();
            }
            if (this.specificJoinCount != other.specificJoinCount && this.specificJoinCount != -1 && other.specificJoinCount != -1) {
                return Integer.compare(this.specificJoinCount, other.specificJoinCount);
            }
            if (this.instanceNumber != other.instanceNumber) {
                return Integer.compare(this.instanceNumber, other.instanceNumber);
            }
            return Integer.compare(this.subInstanceNumber, other.subInstanceNumber);
        }
    }

    private static enum RewardStatus {
        AVAILABLE_OLD,
        AVAILABLE,
        LOCKED,
        CLAIMED;

    }
}

